/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingGeoLocationCity
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="distance_unit")
    private String mDistanceUnit = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="radius")
    private Long mRadius = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="region_id")
    private String mRegionId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static TargetingGeoLocationCity loadJSON(String json, APIContext context, String header) {
        TargetingGeoLocationCity targetingGeoLocationCity = (TargetingGeoLocationCity)TargetingGeoLocationCity.getGson().fromJson(json, TargetingGeoLocationCity.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingGeoLocationCity.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingGeoLocationCity.context = context;
        targetingGeoLocationCity.rawValue = json;
        targetingGeoLocationCity.header = header;
        return targetingGeoLocationCity;
    }

    public static APINodeList<TargetingGeoLocationCity> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TargetingGeoLocationCity> targetingGeoLocationCitys = new APINodeList<TargetingGeoLocationCity>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return targetingGeoLocationCitys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingGeoLocationCitys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingGeoLocationCitys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            targetingGeoLocationCitys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return targetingGeoLocationCitys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return targetingGeoLocationCitys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingGeoLocationCitys;
                }
                targetingGeoLocationCitys.clear();
                targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(json, context, header));
                return targetingGeoLocationCitys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingGeoLocationCity.getGson().toJson((Object)this);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public TargetingGeoLocationCity setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public String getFieldDistanceUnit() {
        return this.mDistanceUnit;
    }

    public TargetingGeoLocationCity setFieldDistanceUnit(String value) {
        this.mDistanceUnit = value;
        return this;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public TargetingGeoLocationCity setFieldKey(String value) {
        this.mKey = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public TargetingGeoLocationCity setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Long getFieldRadius() {
        return this.mRadius;
    }

    public TargetingGeoLocationCity setFieldRadius(Long value) {
        this.mRadius = value;
        return this;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public TargetingGeoLocationCity setFieldRegion(String value) {
        this.mRegion = value;
        return this;
    }

    public String getFieldRegionId() {
        return this.mRegionId;
    }

    public TargetingGeoLocationCity setFieldRegionId(String value) {
        this.mRegionId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingGeoLocationCity copyFrom(TargetingGeoLocationCity instance) {
        this.mCountry = instance.mCountry;
        this.mDistanceUnit = instance.mDistanceUnit;
        this.mKey = instance.mKey;
        this.mName = instance.mName;
        this.mRadius = instance.mRadius;
        this.mRegion = instance.mRegion;
        this.mRegionId = instance.mRegionId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingGeoLocationCity> getParser() {
        return new APIRequest.ResponseParser<TargetingGeoLocationCity>(){

            @Override
            public APINodeList<TargetingGeoLocationCity> parseResponse(String response, APIContext context, APIRequest<TargetingGeoLocationCity> request, String header) throws APIException.MalformedResponseException {
                return TargetingGeoLocationCity.parseResponse(response, context, request, header);
            }
        };
    }
}

