/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.airlift.testing.TestingTicker;
import com.facebook.drift.transport.client.InvokeRequest;
import com.facebook.drift.transport.client.MethodInvoker;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public class MockMethodInvoker
implements MethodInvoker,
Supplier<InvokeRequest> {
    private final Function<InvokeRequest, ListenableFuture<Object>> resultsSupplier;
    private final TestingTicker ticker;
    @GuardedBy(value="this")
    private InvokeRequest request;
    @GuardedBy(value="this")
    private final List<Duration> delays = new ArrayList<Duration>();

    public MockMethodInvoker(Supplier<ListenableFuture<Object>> resultsSupplier) {
        this(resultsSupplier, new TestingTicker());
    }

    public MockMethodInvoker(Function<InvokeRequest, ListenableFuture<Object>> resultsSupplier) {
        this(resultsSupplier, new TestingTicker());
    }

    public MockMethodInvoker(Supplier<ListenableFuture<Object>> resultsSupplier, TestingTicker ticker) {
        this((InvokeRequest request) -> (ListenableFuture)resultsSupplier.get(), ticker);
    }

    private MockMethodInvoker(Function<InvokeRequest, ListenableFuture<Object>> resultsSupplier, TestingTicker ticker) {
        this.resultsSupplier = Objects.requireNonNull(resultsSupplier, "resultsSupplier is null");
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
    }

    @Override
    public synchronized InvokeRequest get() {
        return this.request;
    }

    public synchronized List<Duration> getDelays() {
        return ImmutableList.copyOf(this.delays);
    }

    public synchronized ListenableFuture<Object> invoke(InvokeRequest request) {
        this.request = request;
        return this.resultsSupplier.apply(request);
    }

    public synchronized ListenableFuture<?> delay(Duration duration) {
        this.delays.add(duration);
        this.ticker.increment(duration.toMillis(), TimeUnit.MILLISECONDS);
        return Futures.immediateFuture(null);
    }
}

