/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.drift.TApplicationException;
import com.facebook.drift.TException;
import com.facebook.drift.annotations.ThriftException;
import com.facebook.drift.annotations.ThriftHeader;
import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.drift.client.DriftClient;
import com.facebook.drift.client.DriftClientFactory;
import com.facebook.drift.client.DriftClientFactoryManager;
import com.facebook.drift.client.ExceptionClassification;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.client.MethodInvocationFilter;
import com.facebook.drift.client.MockMethodInvokerFactory;
import com.facebook.drift.client.PassThroughFilter;
import com.facebook.drift.client.ResultsSupplier;
import com.facebook.drift.client.ShortCircuitFilter;
import com.facebook.drift.client.TestingMethodInvocationStat;
import com.facebook.drift.client.TestingMethodInvocationStatsFactory;
import com.facebook.drift.client.UncheckedTApplicationException;
import com.facebook.drift.client.UncheckedTException;
import com.facebook.drift.client.UncheckedTProtocolException;
import com.facebook.drift.client.UncheckedTTransportException;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.MockAddressSelector;
import com.facebook.drift.client.guice.DriftClientBinder;
import com.facebook.drift.client.guice.MethodInvocationFilterBinder;
import com.facebook.drift.client.stats.MethodInvocationStatsFactory;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.protocol.TProtocolException;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.client.DriftClientConfig;
import com.facebook.drift.transport.client.InvokeRequest;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Qualifier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriftClient {
    private static final ThriftCodecManager codecManager = new ThriftCodecManager(new ThriftCodec[0]);
    private static final Optional<String> ADDRESS_SELECTION_CONTEXT = Optional.of("addressSelectionContext");
    private static final ImmutableMap<String, String> HEADERS = ImmutableMap.of((Object)"key", (Object)"value");
    private static final Key<DriftClient<Client>> DEFAULT_CLIENT_KEY = Key.get((TypeLiteral)new TypeLiteral<DriftClient<Client>>(){});
    private static final Key<DriftClient<Client>> CUSTOM_CLIENT_KEY = Key.get((TypeLiteral)new TypeLiteral<DriftClient<Client>>(){}, CustomClient.class);
    private int invocationId;

    @Test
    public void testInvoker() throws Exception {
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        MockMethodInvokerFactory methodInvokerFactory = new MockMethodInvokerFactory(resultsSupplier);
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        ImmutableList classifiers = ImmutableList.of((Object)new TestingExceptionClassifier(), (Object)new TestingExceptionClassifier(), (Object)new TestingExceptionClassifier());
        DriftClientFactoryManager clientFactoryManager = new DriftClientFactoryManager(codecManager, methodInvokerFactory, (MethodInvocationStatsFactory)statsFactory);
        DriftClientFactory driftClientFactory = clientFactoryManager.createDriftClientFactory((Object)"clientIdentity", (AddressSelector)new MockAddressSelector(), ExceptionClassifier.mergeExceptionClassifiers((Iterable)classifiers));
        DriftClient driftClient = driftClientFactory.createDriftClient(Client.class, Optional.empty(), (List)ImmutableList.of(), new DriftClientConfig());
        Client client = (Client)driftClient.get(ADDRESS_SELECTION_CONTEXT, HEADERS);
        Assert.assertEquals((String)((String)methodInvokerFactory.getClientIdentity()), (String)"clientIdentity");
        this.testClient(resultsSupplier, (List<Supplier<InvokeRequest>>)ImmutableList.of((Object)methodInvokerFactory.getMethodInvoker()), (List<TestingExceptionClassifier>)classifiers, statsFactory, client, Optional.empty());
    }

    @Test
    public void testFilter() throws Exception {
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        PassThroughFilter passThroughFilter = new PassThroughFilter();
        ShortCircuitFilter shortCircuitFilter = new ShortCircuitFilter(resultsSupplier);
        MockMethodInvokerFactory invokerFactory = new MockMethodInvokerFactory(resultsSupplier);
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        ImmutableList classifiers = ImmutableList.of((Object)new TestingExceptionClassifier(), (Object)new TestingExceptionClassifier(), (Object)new TestingExceptionClassifier());
        DriftClientFactoryManager clientFactoryManager = new DriftClientFactoryManager(codecManager, invokerFactory, (MethodInvocationStatsFactory)statsFactory);
        DriftClientFactory driftClientFactory = clientFactoryManager.createDriftClientFactory((Object)"clientIdentity", (AddressSelector)new MockAddressSelector(), ExceptionClassifier.mergeExceptionClassifiers((Iterable)classifiers));
        DriftClient driftClient = driftClientFactory.createDriftClient(Client.class, Optional.empty(), (List)ImmutableList.of((Object)passThroughFilter, (Object)shortCircuitFilter), new DriftClientConfig());
        Client client = (Client)driftClient.get(ADDRESS_SELECTION_CONTEXT, HEADERS);
        Assert.assertEquals((String)((String)invokerFactory.getClientIdentity()), (String)"clientIdentity");
        this.testClient(resultsSupplier, (List<Supplier<InvokeRequest>>)ImmutableList.of((Object)passThroughFilter, (Object)shortCircuitFilter), (List<TestingExceptionClassifier>)classifiers, statsFactory, client, Optional.empty());
    }

    @Test
    public void testGuiceClient() {
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        MockMethodInvokerFactory invokerFactory = new MockMethodInvokerFactory(resultsSupplier);
        TestingExceptionClassifier globalClassifierOne = new TestingExceptionClassifier();
        TestingExceptionClassifier globalClassifierTwo = new TestingExceptionClassifier();
        TestingExceptionClassifier clientClassifier = new TestingExceptionClassifier();
        TestingExceptionClassifier customClientClassifier = new TestingExceptionClassifier();
        Bootstrap app = new Bootstrap(new Module[]{binder -> Multibinder.newSetBinder((Binder)binder, ExceptionClassifier.class).addBinding().toInstance((Object)globalClassifierOne), binder -> Multibinder.newSetBinder((Binder)binder, ExceptionClassifier.class).addBinding().toInstance((Object)globalClassifierTwo), binder -> binder.bind((TypeLiteral)new TypeLiteral<MethodInvokerFactory<Annotation>>(){}).toInstance((Object)invokerFactory), binder -> OptionalBinder.newOptionalBinder((Binder)binder, MethodInvocationStatsFactory.class).setBinding().toInstance((Object)statsFactory), binder -> DriftClientBinder.driftClientBinder((Binder)binder).bindDriftClient(Client.class).withAddressSelector((AddressSelector)new MockAddressSelector()).withExceptionClassifier((ExceptionClassifier)clientClassifier), binder -> DriftClientBinder.driftClientBinder((Binder)binder).bindDriftClient(Client.class, CustomClient.class).withAddressSelector((AddressSelector)new MockAddressSelector()).withExceptionClassifier((ExceptionClassifier)customClientClassifier)});
        LifeCycleManager lifeCycleManager = null;
        try {
            Injector injector = app.strictConfig().doNotInitializeLogging().initialize();
            lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            DriftClient driftClient = (DriftClient)injector.getInstance(DEFAULT_CLIENT_KEY);
            Assert.assertSame((Object)injector.getInstance(DEFAULT_CLIENT_KEY), (Object)driftClient);
            Client client = (Client)driftClient.get(ADDRESS_SELECTION_CONTEXT, HEADERS);
            this.testClient(resultsSupplier, (List<Supplier<InvokeRequest>>)ImmutableList.of((Object)invokerFactory.getMethodInvoker()), (List<TestingExceptionClassifier>)ImmutableList.of((Object)globalClassifierOne, (Object)globalClassifierTwo, (Object)clientClassifier), statsFactory, client, Optional.empty());
            DriftClient customDriftClient = (DriftClient)injector.getInstance(CUSTOM_CLIENT_KEY);
            Assert.assertSame((Object)injector.getInstance(CUSTOM_CLIENT_KEY), (Object)customDriftClient);
            Assert.assertNotSame((Object)driftClient, (Object)customDriftClient);
            Client customClient = (Client)customDriftClient.get(ADDRESS_SELECTION_CONTEXT, HEADERS);
            this.testClient(resultsSupplier, (List<Supplier<InvokeRequest>>)ImmutableList.of((Object)invokerFactory.getMethodInvoker()), (List<TestingExceptionClassifier>)ImmutableList.of((Object)globalClassifierOne, (Object)globalClassifierTwo, (Object)customClientClassifier), statsFactory, customClient, Optional.of(CustomClient.class.getSimpleName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (lifeCycleManager != null) {
                try {
                    lifeCycleManager.stop();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Test
    public void testGuiceClientFilter() {
        TestingMethodInvocationStatsFactory statsFactory = new TestingMethodInvocationStatsFactory();
        ResultsSupplier resultsSupplier = new ResultsSupplier();
        PassThroughFilter passThroughFilter = new PassThroughFilter();
        ShortCircuitFilter shortCircuitFilter = new ShortCircuitFilter(resultsSupplier);
        MockMethodInvokerFactory invokerFactory = new MockMethodInvokerFactory(resultsSupplier);
        TestingExceptionClassifier globalClassifierOne = new TestingExceptionClassifier();
        TestingExceptionClassifier globalClassifierTwo = new TestingExceptionClassifier();
        TestingExceptionClassifier clientClassifier = new TestingExceptionClassifier();
        TestingExceptionClassifier customClientClassifier = new TestingExceptionClassifier();
        Bootstrap app = new Bootstrap(new Module[]{binder -> Multibinder.newSetBinder((Binder)binder, ExceptionClassifier.class).addBinding().toInstance((Object)globalClassifierOne), binder -> Multibinder.newSetBinder((Binder)binder, ExceptionClassifier.class).addBinding().toInstance((Object)globalClassifierTwo), binder -> binder.bind((TypeLiteral)new TypeLiteral<MethodInvokerFactory<Annotation>>(){}).toInstance((Object)invokerFactory), binder -> OptionalBinder.newOptionalBinder((Binder)binder, MethodInvocationStatsFactory.class).setBinding().toInstance((Object)statsFactory), binder -> DriftClientBinder.driftClientBinder((Binder)binder).bindDriftClient(Client.class).withAddressSelector((AddressSelector)new MockAddressSelector()).withMethodInvocationFilter(MethodInvocationFilterBinder.staticFilterBinder((MethodInvocationFilter[])new MethodInvocationFilter[]{passThroughFilter, shortCircuitFilter})).withExceptionClassifier((ExceptionClassifier)clientClassifier), binder -> DriftClientBinder.driftClientBinder((Binder)binder).bindDriftClient(Client.class, CustomClient.class).withAddressSelector((AddressSelector)new MockAddressSelector()).withMethodInvocationFilter(MethodInvocationFilterBinder.staticFilterBinder((MethodInvocationFilter[])new MethodInvocationFilter[]{passThroughFilter, shortCircuitFilter})).withExceptionClassifier((ExceptionClassifier)customClientClassifier)});
        LifeCycleManager lifeCycleManager = null;
        try {
            Injector injector = app.strictConfig().doNotInitializeLogging().initialize();
            lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            DriftClient driftClient = (DriftClient)injector.getInstance(DEFAULT_CLIENT_KEY);
            Assert.assertSame((Object)injector.getInstance(DEFAULT_CLIENT_KEY), (Object)driftClient);
            Client client = (Client)driftClient.get(ADDRESS_SELECTION_CONTEXT, HEADERS);
            this.testClient(resultsSupplier, (List<Supplier<InvokeRequest>>)ImmutableList.of((Object)passThroughFilter, (Object)shortCircuitFilter), (List<TestingExceptionClassifier>)ImmutableList.of((Object)globalClassifierOne, (Object)globalClassifierTwo, (Object)clientClassifier), statsFactory, client, Optional.empty());
            DriftClient customDriftClient = (DriftClient)injector.getInstance(CUSTOM_CLIENT_KEY);
            Assert.assertSame((Object)injector.getInstance(CUSTOM_CLIENT_KEY), (Object)customDriftClient);
            Assert.assertNotSame((Object)driftClient, (Object)customDriftClient);
            Client customClient = (Client)customDriftClient.get(ADDRESS_SELECTION_CONTEXT, HEADERS);
            this.testClient(resultsSupplier, (List<Supplier<InvokeRequest>>)ImmutableList.of((Object)passThroughFilter, (Object)shortCircuitFilter), (List<TestingExceptionClassifier>)ImmutableList.of((Object)globalClassifierOne, (Object)globalClassifierTwo, (Object)customClientClassifier), statsFactory, customClient, Optional.of(CustomClient.class.getSimpleName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (lifeCycleManager != null) {
                try {
                    lifeCycleManager.stop();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void testClient(ResultsSupplier resultsSupplier, List<Supplier<InvokeRequest>> targets, List<TestingExceptionClassifier> classifiers, TestingMethodInvocationStatsFactory statsFactory, Client client, Optional<String> empty) throws Exception {
        resultsSupplier.setFailedResult(new Throwable());
        Assert.assertEquals((Object)client, (Object)client);
        Assert.assertEquals((int)client.hashCode(), (int)client.hashCode());
        Assert.assertEquals((String)client.toString(), (String)"clientService");
        TestDriftClient.assertNormalInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new ClientException(), new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TException(), new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TApplicationException(), new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TTransportException(), new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TProtocolException(), new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new Error(), new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new UnknownException(), TException.class);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new RuntimeException(), TException.class);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new InterruptedException(), TException.class);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new ClientException(){}, new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TException(){}, new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TApplicationException(){}, new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TTransportException(){}, new Class[0]);
        TestDriftClient.assertExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TProtocolException(){}, new Class[0]);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new ClientException(), new Class[0]);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TException(), UncheckedTException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TApplicationException(), UncheckedTApplicationException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TTransportException(), UncheckedTTransportException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TProtocolException(), UncheckedTProtocolException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new Error(), new Class[0]);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new UnknownException(), UncheckedTException.class, TException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new RuntimeException(), UncheckedTException.class, TException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new InterruptedException(), UncheckedTException.class, TException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, new ClientException(){}, new Class[0]);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TException(){}, UncheckedTException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TApplicationException(){}, UncheckedTApplicationException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TTransportException(){}, UncheckedTTransportException.class);
        this.assertNoTExceptionInvocation(resultsSupplier, targets, statsFactory, classifiers, client, empty, (Throwable)new TProtocolException(){}, UncheckedTProtocolException.class);
    }

    private static void assertNormalInvocation(ResultsSupplier resultsSupplier, Collection<Supplier<InvokeRequest>> targets, TestingMethodInvocationStatsFactory statsFactory, List<TestingExceptionClassifier> classifiers, Client client, Optional<String> qualifier) throws Exception {
        resultsSupplier.setSuccessResult("result");
        TestingMethodInvocationStat stat = statsFactory.getStat("clientService", qualifier, "test_method");
        stat.clear();
        int invocationId = ThreadLocalRandom.current().nextInt();
        Assert.assertEquals((String)client.test(invocationId, "normal"), (String)"result");
        TestDriftClient.verifyMethodInvocation(targets, "test_method", invocationId, "normal");
        classifiers.forEach(TestingExceptionClassifier::assertNoException);
        stat.assertSuccess(0);
        stat = statsFactory.getStat("clientService", qualifier, "test_method");
        stat.clear();
        invocationId = ThreadLocalRandom.current().nextInt();
        Assert.assertEquals((String)((String)client.testAsync(invocationId, "normal").get()), (String)"result");
        TestDriftClient.verifyMethodInvocation(targets, "test_method", invocationId, "normal");
        classifiers.forEach(TestingExceptionClassifier::assertNoException);
        stat.assertSuccess(0);
        stat = statsFactory.getStat("clientService", qualifier, "testHeader");
        stat.clear();
        invocationId = ThreadLocalRandom.current().nextInt();
        Assert.assertEquals((String)client.testHeader("headerValueA", invocationId, "headerValueB", "normal"), (String)"result");
        TestDriftClient.verifyMethodInvocation(targets, "testHeader", invocationId, "normal", (Map<String, String>)ImmutableMap.builder().putAll(HEADERS).put((Object)"headerA", (Object)"headerValueA").put((Object)"headerB", (Object)"headerValueB").build());
        classifiers.forEach(TestingExceptionClassifier::assertNoException);
        stat.assertSuccess(0);
    }

    @SafeVarargs
    private static void assertExceptionInvocation(ResultsSupplier resultsSupplier, Collection<Supplier<InvokeRequest>> targets, TestingMethodInvocationStatsFactory statsFactory, List<TestingExceptionClassifier> classifiers, Client client, Optional<String> qualifier, Throwable testException, Class<? extends Throwable> ... expectedWrapperTypes) throws InterruptedException {
        String name = "exception-" + testException.getClass().getName();
        TestingMethodInvocationStat stat = statsFactory.getStat("clientService", qualifier, "test_method");
        stat.clear();
        int invocationId = ThreadLocalRandom.current().nextInt();
        resultsSupplier.setFailedResult(testException);
        try {
            client.test(invocationId, name);
            Assert.fail((String)"Expected exception");
        }
        catch (Throwable e) {
            TestDriftClient.assertExceptionChain(e, testException, expectedWrapperTypes);
            classifiers.forEach(classifier -> classifier.assertLastException(testException));
        }
        TestDriftClient.verifyMethodInvocation(targets, "test_method", invocationId, name);
        stat.assertFailure(0);
        stat = statsFactory.getStat("clientService", qualifier, "test_method");
        stat.clear();
        invocationId = ThreadLocalRandom.current().nextInt();
        resultsSupplier.setFailedResult(testException);
        try {
            client.testAsync(invocationId, name).get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            TestDriftClient.assertExceptionChain(e.getCause(), testException, expectedWrapperTypes);
            classifiers.forEach(classifier -> classifier.assertLastException(testException));
        }
        TestDriftClient.verifyMethodInvocation(targets, "test_method", invocationId, name);
        stat.assertFailure(0);
    }

    @SafeVarargs
    private final void assertNoTExceptionInvocation(ResultsSupplier resultsSupplier, Collection<Supplier<InvokeRequest>> targets, TestingMethodInvocationStatsFactory statsFactory, List<TestingExceptionClassifier> classifiers, Client client, Optional<String> qualifier, Throwable testException, Class<? extends Throwable> ... expectedWrapperTypes) {
        String name = "exception-" + testException.getClass().getName();
        TestingMethodInvocationStat stat = statsFactory.getStat("clientService", qualifier, "testNoTException");
        stat.clear();
        resultsSupplier.setFailedResult(testException);
        try {
            ++this.invocationId;
            client.testNoTException(this.invocationId, name);
            Assert.fail((String)"Expected exception");
        }
        catch (Throwable e) {
            TestDriftClient.assertExceptionChain(e, testException, expectedWrapperTypes);
            classifiers.forEach(classifier -> classifier.assertLastException(testException));
        }
        TestDriftClient.verifyMethodInvocation(targets, "testNoTException", this.invocationId, name);
        stat.assertFailure(0);
    }

    private static void assertExceptionChain(Throwable actualException, Throwable expectedException, Class<? extends Throwable>[] expectedWrapperTypes) {
        Assert.assertSame((Object)Throwables.getRootCause((Throwable)actualException), (Object)expectedException);
        List actualTypes = Throwables.getCausalChain((Throwable)actualException).stream().map(Object::getClass).collect(Collectors.toList());
        ImmutableList expectedTypes = ImmutableList.builder().add((Object[])expectedWrapperTypes).add(expectedException.getClass()).build();
        if (!actualException.equals(expectedException)) {
            Assert.assertEquals((String)actualTypes.toString(), (String)expectedTypes.toString());
        }
        if (expectedException instanceof InterruptedException) {
            Thread.interrupted();
        }
    }

    private static void verifyMethodInvocation(Collection<Supplier<InvokeRequest>> targets, String methodName, int id, String name) {
        TestDriftClient.verifyMethodInvocation(targets, methodName, id, name, HEADERS);
    }

    private static void verifyMethodInvocation(Collection<Supplier<InvokeRequest>> targets, String methodName, int id, String name, Map<String, String> headers) {
        for (Supplier<InvokeRequest> target : targets) {
            InvokeRequest invokeRequest = target.get();
            Assert.assertEquals((String)invokeRequest.getMethod().getName(), (String)methodName);
            Assert.assertEquals((Collection)invokeRequest.getParameters(), (Collection)ImmutableList.of((Object)id, (Object)name));
            Assert.assertEquals((Map)invokeRequest.getHeaders(), headers);
        }
    }

    private static class TestingExceptionClassifier
    implements ExceptionClassifier {
        private final AtomicReference<Throwable> lastException = new AtomicReference();

        private TestingExceptionClassifier() {
        }

        public void assertLastException(Throwable expectedException) {
            if (expectedException instanceof InterruptedException) {
                Assert.assertNull((Object)this.lastException.get());
            } else {
                Assert.assertSame((Object)expectedException, (Object)this.lastException.get());
            }
            this.lastException.set(null);
        }

        public void assertNoException() {
            Assert.assertNull((Object)this.lastException.get());
            this.lastException.set(null);
        }

        public ExceptionClassification classifyException(Throwable throwable) {
            this.lastException.set(throwable);
            return new ExceptionClassification(Optional.of(false), ExceptionClassification.HostStatus.NORMAL);
        }
    }

    private static class UnknownException
    extends Exception {
        private UnknownException() {
        }
    }

    @ThriftStruct
    public static class ClientException
    extends Exception {
    }

    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    private static @interface CustomClient {
    }

    @ThriftService(value="clientService")
    public static interface Client {
        @ThriftMethod(value="test_method")
        public String test(int var1, String var2) throws ClientException, TException;

        @ThriftMethod
        public void testNoTException(int var1, String var2) throws ClientException;

        @ThriftMethod
        public String testHeader(@ThriftHeader(value="headerA") String var1, int var2, @ThriftHeader(value="headerB") String var3, String var4) throws ClientException;

        @ThriftMethod(value="test_method", exception={@ThriftException(id=0, type=ClientException.class)})
        public ListenableFuture<String> testAsync(int var1, String var2);
    }
}

