/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.airlift.testing.TestingTicker;
import com.facebook.drift.TException;
import com.facebook.drift.client.DriftMethodInvocation;
import com.facebook.drift.client.ExceptionClassification;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.client.MockMethodInvoker;
import com.facebook.drift.client.RetriesFailedException;
import com.facebook.drift.client.RetryPolicy;
import com.facebook.drift.client.TestingMethodInvocationStat;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.drift.client.stats.MethodInvocationStat;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.builtin.ShortThriftCodec;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.client.Address;
import com.facebook.drift.transport.client.ConnectionFailedException;
import com.facebook.drift.transport.client.DriftApplicationException;
import com.facebook.drift.transport.client.DriftClientConfig;
import com.facebook.drift.transport.client.MethodInvoker;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.concurrent.GuardedBy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriftMethodInvocation {
    private static final Object SUCCESS = "ok";
    private static final MethodMetadata METHOD_METADATA = new MethodMetadata("testMethod", (List)ImmutableList.of(), (ThriftCodec)new ShortThriftCodec(), (Map)ImmutableMap.of(), false, true);
    private static final Error UNEXPECTED_EXCEPTION = new Error("unexpected exception");

    @Test(timeOut=60000L)
    public void testFirstTrySuccess() throws Exception {
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(RetryPolicy.NO_RETRY_POLICY, stat, () -> Futures.immediateFuture((Object)SUCCESS));
        Assert.assertEquals((Object)methodInvocation.get(), (Object)SUCCESS);
        stat.assertSuccess(0);
    }

    @Test(timeOut=60000L)
    public void testBasicRetriesToSuccess() throws Exception {
        TestDriftMethodInvocation.testBasicRetriesToSuccess(0, true);
        TestDriftMethodInvocation.testBasicRetriesToSuccess(1, true);
        TestDriftMethodInvocation.testBasicRetriesToSuccess(3, true);
        TestDriftMethodInvocation.testBasicRetriesToSuccess(10, true);
        TestDriftMethodInvocation.testBasicRetriesToSuccess(0, false);
        TestDriftMethodInvocation.testBasicRetriesToSuccess(1, false);
        TestDriftMethodInvocation.testBasicRetriesToSuccess(3, false);
        TestDriftMethodInvocation.testBasicRetriesToSuccess(10, false);
    }

    private static void testBasicRetriesToSuccess(int expectedRetries, boolean wrapWithApplicationException) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10).setMinBackoffDelay(new Duration(1.0, TimeUnit.SECONDS)).setMaxBackoffDelay(new Duration(1.0, TimeUnit.DAYS)).setBackoffScaleFactor(2.0), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        MockMethodInvoker invoker = new MockMethodInvoker(() -> {
            int currentAttempts = attempts.getAndIncrement();
            if (currentAttempts < expectedRetries) {
                return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL, wrapWithApplicationException));
            }
            return Futures.immediateFuture((Object)SUCCESS);
        });
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, invoker, new TestingAddressSelector(100), Ticker.systemTicker());
        Assert.assertEquals((Object)methodInvocation.get(), (Object)SUCCESS);
        Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
        stat.assertSuccess(expectedRetries);
        TestDriftMethodInvocation.assertDelays(invoker, retryPolicy, expectedRetries);
    }

    @Test(timeOut=60000L)
    public void testBasicRetriesToFailure() throws Exception {
        TestDriftMethodInvocation.testBasicRetriesToFailure(0, true);
        TestDriftMethodInvocation.testBasicRetriesToFailure(1, true);
        TestDriftMethodInvocation.testBasicRetriesToFailure(5, true);
        TestDriftMethodInvocation.testBasicRetriesToFailure(10, true);
        TestDriftMethodInvocation.testBasicRetriesToFailure(0, false);
        TestDriftMethodInvocation.testBasicRetriesToFailure(1, false);
        TestDriftMethodInvocation.testBasicRetriesToFailure(5, false);
        TestDriftMethodInvocation.testBasicRetriesToFailure(10, false);
    }

    private static void testBasicRetriesToFailure(int expectedRetries, boolean wrapWithApplicationException) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10).setMinBackoffDelay(new Duration(1.0, TimeUnit.SECONDS)).setMaxBackoffDelay(new Duration(100.0, TimeUnit.SECONDS)).setBackoffScaleFactor(2.0), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        MockMethodInvoker invoker = new MockMethodInvoker(() -> {
            int currentAttempts = attempts.getAndIncrement();
            if (currentAttempts < expectedRetries) {
                return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL, wrapWithApplicationException));
            }
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(false, ExceptionClassification.HostStatus.NORMAL, wrapWithApplicationException));
        });
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, invoker, new TestingAddressSelector(100), Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
            TestDriftMethodInvocation.assertClassifiedException(e.getCause(), new ExceptionClassification(Optional.of(false), ExceptionClassification.HostStatus.NORMAL), expectedRetries);
        }
        stat.assertFailure(expectedRetries);
        TestDriftMethodInvocation.assertDelays(invoker, retryPolicy, expectedRetries);
    }

    @Test(timeOut=60000L)
    public void testBasicRetriesToNoHosts() throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(10), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        int expectedRetries = 3;
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, new MockMethodInvoker(() -> {
            attempts.getAndIncrement();
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        }), new TestingAddressSelector(expectedRetries + 1), Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
            TestDriftMethodInvocation.assertClassifiedException(e.getCause(), new ExceptionClassification(Optional.of(true), ExceptionClassification.HostStatus.NORMAL), expectedRetries);
        }
        stat.assertFailure(expectedRetries);
    }

    @Test(timeOut=60000L)
    public void testMaxRetries() throws Exception {
        int maxRetries = 5;
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(maxRetries), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, () -> {
            attempts.getAndIncrement();
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        });
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(maxRetries + 1));
            TestDriftMethodInvocation.assertClassifiedException(e.getCause(), new ExceptionClassification(Optional.of(true), ExceptionClassification.HostStatus.NORMAL), maxRetries);
        }
        stat.assertFailure(maxRetries);
    }

    @Test(timeOut=60000L)
    public void testMaxRetryTime() throws Exception {
        TestingTicker ticker = new TestingTicker();
        int maxRetries = 7;
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(maxRetries + 10).setMinBackoffDelay(new Duration(1.0, TimeUnit.SECONDS)).setMaxBackoffDelay(new Duration(1.0, TimeUnit.DAYS)).setMaxRetryTime(new Duration(127.0, TimeUnit.SECONDS)).setBackoffScaleFactor(2.0), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        MockMethodInvoker invoker = new MockMethodInvoker(() -> {
            attempts.getAndIncrement();
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        }, ticker);
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, invoker, new TestingAddressSelector(100), (Ticker)ticker);
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(maxRetries + 1));
            TestDriftMethodInvocation.assertClassifiedException(e.getCause(), new ExceptionClassification(Optional.of(true), ExceptionClassification.HostStatus.NORMAL), maxRetries);
        }
        stat.assertFailure(maxRetries);
        TestDriftMethodInvocation.assertDelays(invoker, retryPolicy, 7);
    }

    @Test(timeOut=60000L)
    public void testExhaustHosts() throws Exception {
        TestDriftMethodInvocation.testExhaustHosts(0, false);
        TestDriftMethodInvocation.testExhaustHosts(1, false);
        TestDriftMethodInvocation.testExhaustHosts(10, false);
        TestDriftMethodInvocation.testExhaustHosts(0, true);
        TestDriftMethodInvocation.testExhaustHosts(1, true);
        TestDriftMethodInvocation.testExhaustHosts(10, true);
    }

    private static void testExhaustHosts(int expectedRetries, boolean overloaded) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        TestingAddressSelector addressSelector = new TestingAddressSelector(expectedRetries);
        Set attemptedAddresses = Sets.newConcurrentHashSet();
        MockMethodInvoker invoker = new MockMethodInvoker(request -> {
            attempts.getAndIncrement();
            attemptedAddresses.add(request.getAddress());
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, overloaded ? ExceptionClassification.HostStatus.OVERLOADED : ExceptionClassification.HostStatus.DOWN));
        });
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, invoker, addressSelector, Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)expectedRetries);
            Assert.assertTrue((boolean)(e.getCause() instanceof TTransportException));
            TTransportException transportException = (TTransportException)e.getCause();
            Assert.assertTrue((boolean)transportException.getMessage().startsWith("No hosts available"));
            TestDriftMethodInvocation.assertRetriesFailedInformation((Throwable)transportException, 0, 0, overloaded ? expectedRetries : 0);
        }
        stat.assertNoHostsAvailable(expectedRetries);
        addressSelector.assertAllDown();
        Assert.assertEquals((int)invoker.getDelays().size(), (int)0);
        Assert.assertEquals((Set)attemptedAddresses, addressSelector.getLastAttemptedSet());
    }

    @Test(timeOut=60000L)
    public void testConnectionFailed() throws Exception {
        TestDriftMethodInvocation.testConnectionFailed(0, 3);
        TestDriftMethodInvocation.testConnectionFailed(1, 3);
        TestDriftMethodInvocation.testConnectionFailed(10, 3);
    }

    private static void testConnectionFailed(int expectedInvocationAttempts, int failedConnections) throws Exception {
        AtomicInteger attempts = new AtomicInteger();
        MockMethodInvoker invoker = new MockMethodInvoker(request -> {
            int tries = attempts.getAndIncrement();
            if (tries < expectedInvocationAttempts) {
                return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
            }
            if (tries < failedConnections + expectedInvocationAttempts) {
                return Futures.immediateFailedFuture((Throwable)new ConnectionFailedException(request.getAddress(), (Throwable)new Exception()));
            }
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(false, ExceptionClassification.HostStatus.DOWN));
        });
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(new RetryPolicy(new DriftClientConfig().setMaxRetries(100), (ExceptionClassifier)new TestingExceptionClassifier()), new TestingMethodInvocationStat(), invoker, new TestingAddressSelector(100), Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof DriftApplicationException));
            DriftApplicationException applicationException = (DriftApplicationException)e.getCause();
            Assert.assertTrue((boolean)(applicationException.getCause() instanceof ClassifiedException));
            ClassifiedException classifiedException = (ClassifiedException)applicationException.getCause();
            TestDriftMethodInvocation.assertRetriesFailedInformation(classifiedException, failedConnections, expectedInvocationAttempts, 0);
        }
    }

    @Test
    public void testConnectionFailedDelay() throws Exception {
        TestDriftMethodInvocation.testConnectionFailedDelay(0, 0, 0);
        TestDriftMethodInvocation.testConnectionFailedDelay(1, 1, 0);
        TestDriftMethodInvocation.testConnectionFailedDelay(10, 1, 0);
        TestDriftMethodInvocation.testConnectionFailedDelay(1, 2, 1);
        TestDriftMethodInvocation.testConnectionFailedDelay(2, 2, 2);
        TestDriftMethodInvocation.testConnectionFailedDelay(10, 2, 10);
        TestDriftMethodInvocation.testConnectionFailedDelay(10, 5, 40);
    }

    private static void testConnectionFailedDelay(int numberOfAddresses, int numberOfRetriesPerAddress, int expectedDelays) throws Exception {
        TestDriftMethodInvocation.testConnectionFailedDelay(false, numberOfAddresses, numberOfRetriesPerAddress, expectedDelays);
        TestDriftMethodInvocation.testConnectionFailedDelay(true, numberOfAddresses, numberOfRetriesPerAddress, expectedDelays);
    }

    private static void testConnectionFailedDelay(boolean overloaded, int numberOfAddresses, int numberOfRetriesPerAddress, int expectedDelays) throws Exception {
        ImmutableList.Builder addresses = ImmutableList.builder();
        for (int i = 0; i < numberOfAddresses; ++i) {
            Address address = TestDriftMethodInvocation.createTestingAddress(20000 + i);
            for (int j = 0; j < numberOfRetriesPerAddress; ++j) {
                addresses.add((Object)address);
            }
        }
        MockMethodInvoker invoker = new MockMethodInvoker(request -> Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, overloaded ? ExceptionClassification.HostStatus.OVERLOADED : ExceptionClassification.HostStatus.DOWN)));
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(new RetryPolicy(new DriftClientConfig(), (ExceptionClassifier)new TestingExceptionClassifier()), new TestingMethodInvocationStat(), invoker, new TestingAddressSelector((List<Address>)addresses.build()), Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TTransportException));
            TTransportException transportException = (TTransportException)e.getCause();
            Assert.assertTrue((boolean)transportException.getMessage().startsWith("No hosts available"));
        }
        Assert.assertEquals((int)invoker.getDelays().size(), (int)expectedDelays);
    }

    @Test(timeOut=60000L)
    public void testExceptionFromInvokerInvoke() throws Exception {
        TestDriftMethodInvocation.testExceptionFromInvokerInvoke(0);
        TestDriftMethodInvocation.testExceptionFromInvokerInvoke(1);
        TestDriftMethodInvocation.testExceptionFromInvokerInvoke(10);
    }

    private static void testExceptionFromInvokerInvoke(int expectedRetries) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, () -> {
            attempts.getAndIncrement();
            if (attempts.get() > expectedRetries) {
                throw UNEXPECTED_EXCEPTION;
            }
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        });
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
            TestDriftMethodInvocation.assertUnexpectedException(e.getCause());
        }
    }

    @Test(timeOut=60000L)
    public void testExceptionFromInvokerDelay() throws Exception {
        TestDriftMethodInvocation.testExceptionFromInvokerDelay(0, true);
        TestDriftMethodInvocation.testExceptionFromInvokerDelay(1, true);
        TestDriftMethodInvocation.testExceptionFromInvokerDelay(10, true);
        TestDriftMethodInvocation.testExceptionFromInvokerDelay(0, false);
        TestDriftMethodInvocation.testExceptionFromInvokerDelay(1, false);
        TestDriftMethodInvocation.testExceptionFromInvokerDelay(10, false);
    }

    private static void testExceptionFromInvokerDelay(final int expectedRetries, final boolean throwUnexpected) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        final AtomicInteger attempts = new AtomicInteger();
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, new MockMethodInvoker(() -> {
            attempts.getAndIncrement();
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        }){

            @Override
            public synchronized ListenableFuture<?> delay(Duration duration) {
                if (attempts.get() > expectedRetries) {
                    if (throwUnexpected) {
                        throw UNEXPECTED_EXCEPTION;
                    }
                    return Futures.immediateFailedFuture((Throwable)UNEXPECTED_EXCEPTION);
                }
                return super.delay(duration);
            }
        }, new TestingAddressSelector(100), Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
            TestDriftMethodInvocation.assertUnexpectedException(e.getCause());
        }
    }

    @Test(timeOut=60000L)
    public void testExceptionFromExceptionClassifier() throws Exception {
        TestDriftMethodInvocation.testExceptionFromExceptionClassifier(0);
        TestDriftMethodInvocation.testExceptionFromExceptionClassifier(1);
        TestDriftMethodInvocation.testExceptionFromExceptionClassifier(10);
    }

    private static void testExceptionFromExceptionClassifier(final int expectedRetries) throws Exception {
        final AtomicInteger attempts = new AtomicInteger();
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10), (ExceptionClassifier)new TestingExceptionClassifier(){

            @Override
            public ExceptionClassification classifyException(Throwable throwable) {
                if (attempts.get() > expectedRetries) {
                    throw UNEXPECTED_EXCEPTION;
                }
                return super.classifyException(throwable);
            }
        });
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, () -> {
            attempts.getAndIncrement();
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        });
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
            TestDriftMethodInvocation.assertUnexpectedException(e.getCause());
        }
    }

    @Test(timeOut=60000L)
    public void testExceptionFromAddressSelectorSelectAddress() throws Exception {
        TestDriftMethodInvocation.testExceptionFromAddressSelectorSelectAddress(0);
        TestDriftMethodInvocation.testExceptionFromAddressSelectorSelectAddress(1);
        TestDriftMethodInvocation.testExceptionFromAddressSelectorSelectAddress(10);
    }

    private static void testExceptionFromAddressSelectorSelectAddress(final int expectedRetries) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        final AtomicInteger attempts = new AtomicInteger();
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, new MockMethodInvoker(() -> {
            attempts.getAndIncrement();
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        }), new TestingAddressSelector(100){

            @Override
            public synchronized Optional<Address> selectAddress(Optional<String> addressSelectionContext, Set<Address> attempted) {
                if (attempts.get() < expectedRetries) {
                    return super.selectAddress(addressSelectionContext, attempted);
                }
                throw UNEXPECTED_EXCEPTION;
            }
        }, Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)expectedRetries);
            TestDriftMethodInvocation.assertUnexpectedException(e.getCause());
        }
    }

    @Test(timeOut=60000L)
    public void testExceptionFromAddressSelectorMarkDown() throws Exception {
        TestDriftMethodInvocation.testExceptionFromAddressSelectorMarkDown(0);
        TestDriftMethodInvocation.testExceptionFromAddressSelectorMarkDown(1);
        TestDriftMethodInvocation.testExceptionFromAddressSelectorMarkDown(10);
    }

    private static void testExceptionFromAddressSelectorMarkDown(final int expectedRetries) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        final AtomicInteger attempts = new AtomicInteger();
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, new MockMethodInvoker(() -> {
            attempts.getAndIncrement();
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.DOWN));
        }), new TestingAddressSelector(100){

            @Override
            public synchronized void markdown(Address address) {
                if (attempts.get() > expectedRetries) {
                    throw UNEXPECTED_EXCEPTION;
                }
            }
        }, Ticker.systemTicker());
        try {
            methodInvocation.get();
            Assert.fail((String)"Expected exception");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
            TestDriftMethodInvocation.assertUnexpectedException(e.getCause());
        }
    }

    @Test(timeOut=60000L)
    public void testPropagateCancel() throws Exception {
        TestDriftMethodInvocation.testPropagateCancel(0, false);
        TestDriftMethodInvocation.testPropagateCancel(1, false);
        TestDriftMethodInvocation.testPropagateCancel(10, false);
        TestDriftMethodInvocation.testPropagateCancel(0, true);
        TestDriftMethodInvocation.testPropagateCancel(1, true);
        TestDriftMethodInvocation.testPropagateCancel(10, true);
    }

    private static void testPropagateCancel(int expectedRetries, boolean interrupt) throws Exception {
        RetryPolicy retryPolicy = new RetryPolicy(new DriftClientConfig().setMaxRetries(expectedRetries + 10), (ExceptionClassifier)new TestingExceptionClassifier());
        TestingMethodInvocationStat stat = new TestingMethodInvocationStat();
        AtomicInteger attempts = new AtomicInteger();
        TestFuture future = new TestFuture();
        CountDownLatch settableFutureFetched = new CountDownLatch(1);
        DriftMethodInvocation<?> methodInvocation = TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, () -> {
            attempts.getAndIncrement();
            if (attempts.get() > expectedRetries) {
                settableFutureFetched.countDown();
                return future;
            }
            return Futures.immediateFailedFuture((Throwable)ClassifiedException.createClassifiedException(true, ExceptionClassification.HostStatus.NORMAL));
        });
        settableFutureFetched.await();
        methodInvocation.cancel(interrupt);
        Assert.assertTrue((boolean)future.isCancelled());
        Assert.assertEquals((boolean)future.checkWasInterrupted(), (boolean)interrupt);
        Assert.assertEquals((int)attempts.get(), (int)(expectedRetries + 1));
    }

    private static DriftMethodInvocation<?> createDriftMethodInvocation(RetryPolicy retryPolicy, TestingMethodInvocationStat stat, Supplier<ListenableFuture<Object>> resultsSupplier) {
        return TestDriftMethodInvocation.createDriftMethodInvocation(retryPolicy, stat, new MockMethodInvoker(resultsSupplier), new TestingAddressSelector(100), Ticker.systemTicker());
    }

    private static DriftMethodInvocation<?> createDriftMethodInvocation(RetryPolicy retryPolicy, TestingMethodInvocationStat stat, MockMethodInvoker invoker, AddressSelector<?> addressSelector, Ticker ticker) {
        return DriftMethodInvocation.createDriftMethodInvocation((MethodInvoker)invoker, (MethodMetadata)METHOD_METADATA, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (RetryPolicy)retryPolicy, addressSelector, Optional.empty(), (MethodInvocationStat)stat, (Ticker)ticker);
    }

    private static void assertClassifiedException(Throwable cause, ExceptionClassification exceptionClassification, int expectedRetries) {
        if (cause instanceof DriftApplicationException) {
            cause = cause.getCause();
        }
        Assert.assertTrue((boolean)(cause instanceof ClassifiedException));
        ClassifiedException classifiedException = (ClassifiedException)cause;
        Assert.assertEquals((Object)classifiedException.getClassification(), (Object)exceptionClassification);
        TestDriftMethodInvocation.assertRetriesFailedInformation(classifiedException, 0, expectedRetries + 1, 0);
    }

    private static void assertRetriesFailedInformation(Throwable exception, int expectedFailedConnections, int expectedInvocationAttempts, int expectedOverloaded) {
        RetriesFailedException retriesFailedException = TestDriftMethodInvocation.getRetriesFailedException(exception);
        Assert.assertEquals((int)retriesFailedException.getFailedConnections(), (int)expectedFailedConnections);
        Assert.assertEquals((int)retriesFailedException.getInvocationAttempts(), (int)expectedInvocationAttempts);
        Assert.assertEquals((int)retriesFailedException.getOverloadedRejects(), (int)expectedOverloaded);
    }

    private static RetriesFailedException getRetriesFailedException(Throwable exception) {
        Throwable[] suppressed = exception.getSuppressed();
        Assert.assertEquals((int)suppressed.length, (int)1);
        Assert.assertTrue((boolean)(suppressed[0] instanceof RetriesFailedException));
        return (RetriesFailedException)suppressed[0];
    }

    private static void assertUnexpectedException(Throwable cause) {
        Assert.assertEquals(cause.getClass(), TException.class);
        TException exception = (TException)cause;
        Assert.assertTrue((boolean)exception.getMessage().matches("Unexpected error processing.*" + METHOD_METADATA.getName() + ".*"));
        Assert.assertSame((Object)exception.getCause(), (Object)UNEXPECTED_EXCEPTION);
        Assert.assertEquals((int)exception.getSuppressed().length, (int)0);
    }

    private static void assertDelays(MockMethodInvoker invoker, RetryPolicy retryPolicy, int expectedRetries) {
        Assert.assertEquals(invoker.getDelays(), (Collection)((Collection)IntStream.range(0, expectedRetries).mapToObj(i -> retryPolicy.getBackoffDelay(i + 1)).collect(ImmutableList.toImmutableList())));
    }

    private static Address createTestingAddress(int port) {
        return new SimpleAddressSelector.SimpleAddress(HostAndPort.fromParts((String)"localhost", (int)port));
    }

    public static class TestFuture
    extends AbstractFuture<Object> {
        public boolean checkWasInterrupted() {
            return this.wasInterrupted();
        }
    }

    public static class TestingAddressSelector
    implements AddressSelector<Address> {
        private List<Address> addresses;
        @GuardedBy(value="this")
        private final Set<Address> markdownHosts = new HashSet<Address>();
        @GuardedBy(value="this")
        private int addressCount;
        @GuardedBy(value="this")
        private Set<Address> lastAttemptedSet = ImmutableSet.of();

        public TestingAddressSelector(int maxAddresses) {
            this(TestingAddressSelector.createAddresses(maxAddresses));
        }

        private static List<Address> createAddresses(int count) {
            return (List)IntStream.range(0, count).mapToObj(i -> TestDriftMethodInvocation.createTestingAddress(20000 + i)).collect(ImmutableList.toImmutableList());
        }

        public TestingAddressSelector(List<Address> addresses) {
            this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        }

        public synchronized Optional<Address> selectAddress(Optional<String> addressSelectionContext) {
            return this.selectAddress(addressSelectionContext, (Set<Address>)ImmutableSet.of());
        }

        public synchronized Optional<Address> selectAddress(Optional<String> addressSelectionContext, Set<Address> attempted) {
            this.lastAttemptedSet = ImmutableSet.copyOf(attempted);
            if (this.addressCount >= this.addresses.size()) {
                return Optional.empty();
            }
            return Optional.of(this.addresses.get(this.addressCount++));
        }

        public synchronized void markdown(Address address) {
            this.markdownHosts.add(address);
        }

        public synchronized void assertAllDown() {
            Assert.assertEquals(this.markdownHosts, (Set)ImmutableSet.copyOf(this.addresses));
        }

        public synchronized Set<Address> getLastAttemptedSet() {
            return this.lastAttemptedSet;
        }
    }

    public static class ClassifiedException
    extends Exception {
        private final ExceptionClassification classification;

        public static Exception createClassifiedException(boolean retry, ExceptionClassification.HostStatus hostStatus) {
            return ClassifiedException.createClassifiedException(retry, hostStatus, true);
        }

        public static Exception createClassifiedException(boolean retry, ExceptionClassification.HostStatus hostStatus, boolean wrapWithApplicationException) {
            ClassifiedException exception = new ClassifiedException(new ExceptionClassification(Optional.of(retry), hostStatus));
            if (wrapWithApplicationException) {
                exception = new DriftApplicationException((Throwable)exception);
            }
            return exception;
        }

        public ClassifiedException(ExceptionClassification classification) {
            super(classification.toString());
            this.classification = Objects.requireNonNull(classification, "classification is null");
        }

        public ExceptionClassification getClassification() {
            return this.classification;
        }
    }

    private static class TestingExceptionClassifier
    implements ExceptionClassifier {
        private TestingExceptionClassifier() {
        }

        public ExceptionClassification classifyException(Throwable throwable) {
            if (throwable instanceof DriftApplicationException) {
                throwable = throwable.getCause();
            }
            return ((ClassifiedException)throwable).getClassification();
        }
    }
}

