/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.drift.client.stats.MethodInvocationStat;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.testng.Assert;

public class TestingMethodInvocationStat
implements MethodInvocationStat {
    private final AtomicInteger invocations = new AtomicInteger();
    private final AtomicInteger successes = new AtomicInteger();
    private final AtomicInteger failures = new AtomicInteger();
    private final AtomicInteger retries = new AtomicInteger();
    private final AtomicLong lastStartTime = new AtomicLong();

    public void clear() {
        this.invocations.set(0);
        this.successes.set(0);
        this.failures.set(0);
        this.retries.set(0);
        this.lastStartTime.set(0L);
    }

    public void assertSuccess(int expectedRetries) {
        Assert.assertEquals((int)this.invocations.get(), (int)(expectedRetries + 1));
        Assert.assertEquals((int)this.successes.get(), (int)1);
        Assert.assertEquals((int)this.failures.get(), (int)expectedRetries);
        Assert.assertEquals((int)this.retries.get(), (int)expectedRetries);
        Assert.assertNotEquals((Object)this.lastStartTime.get(), (Object)0);
    }

    public void assertFailure(int expectedRetries) {
        Assert.assertEquals((int)this.invocations.get(), (int)(expectedRetries + 1));
        Assert.assertEquals((int)this.successes.get(), (int)0);
        Assert.assertEquals((int)this.failures.get(), (int)(expectedRetries + 1));
        Assert.assertEquals((int)this.retries.get(), (int)expectedRetries);
        Assert.assertNotEquals((Object)this.lastStartTime.get(), (Object)0);
    }

    public void assertNoHostsAvailable(int expectedRetries) {
        Assert.assertEquals((int)this.invocations.get(), (int)expectedRetries);
        Assert.assertEquals((int)this.successes.get(), (int)0);
        Assert.assertEquals((int)this.failures.get(), (int)expectedRetries);
        Assert.assertEquals((int)this.retries.get(), (int)0);
        Assert.assertNotEquals((Object)this.lastStartTime.get(), (Object)0);
    }

    public void recordResult(long startTime, ListenableFuture<Object> result) {
        this.invocations.incrementAndGet();
        result.addListener(() -> {
            this.lastStartTime.set(startTime);
            try {
                result.get();
                this.successes.incrementAndGet();
            }
            catch (Throwable throwable) {
                this.failures.incrementAndGet();
            }
        }, MoreExecutors.directExecutor());
    }

    public void recordRetry() {
        this.retries.incrementAndGet();
    }
}

