/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.drift.client.TestingMethodInvocationStat;
import com.facebook.drift.client.stats.MethodInvocationStatsFactory;
import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.facebook.drift.transport.MethodMetadata;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestingMethodInvocationStatsFactory
implements MethodInvocationStatsFactory {
    private final ConcurrentMap<Key, TestingMethodInvocationStat> stats = new ConcurrentHashMap<Key, TestingMethodInvocationStat>();

    public TestingMethodInvocationStat getStat(String serviceName, Optional<String> qualifier, String methodName) {
        return (TestingMethodInvocationStat)this.stats.get(new Key(serviceName, qualifier, methodName));
    }

    public TestingMethodInvocationStat getStat(ThriftServiceMetadata serviceMetadata, Optional<String> qualifier, MethodMetadata metadata) {
        return this.stats.computeIfAbsent(new Key(serviceMetadata.getName(), qualifier, metadata.getName()), key -> new TestingMethodInvocationStat());
    }

    private static class Key {
        private final String serviceName;
        private final Optional<String> qualifier;
        private final String methodName;

        public Key(String serviceName, Optional<String> qualifier, String methodName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName is null");
            this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
            this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.serviceName, key.serviceName) && Objects.equals(this.qualifier, key.qualifier) && Objects.equals(this.methodName, key.methodName);
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.qualifier, this.methodName);
        }

        public String toString() {
            return this.serviceName + this.qualifier.map(name -> "." + name).orElse("") + "." + this.methodName;
        }
    }
}

