/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client.address;

import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.transport.client.Address;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class MockAddressSelector
implements AddressSelector<Address> {
    private final List<HostAndPort> markdownHosts = new CopyOnWriteArrayList<HostAndPort>();
    private Optional<HostAndPort> address = Optional.of(HostAndPort.fromParts((String)"localhost", (int)9999));

    public List<HostAndPort> getMarkdownHosts() {
        return ImmutableList.copyOf(this.markdownHosts);
    }

    public void setAddress(Optional<HostAndPort> address) {
        this.address = address;
    }

    public Optional<Address> selectAddress(Optional<String> addressSelectionContext) {
        return this.address.map(hostAndPort -> () -> hostAndPort);
    }

    public void markdown(Address address) {
        this.markdownHosts.add(address.getHostAndPort());
    }
}

