/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client.address;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.testing.Assertions;
import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelectorBinder;
import com.facebook.drift.client.guice.AddressSelectorBinder;
import com.facebook.drift.client.guice.DefaultClient;
import com.facebook.drift.client.guice.DriftClientAnnotationFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimpleAddressSelectorBinder {
    private static final Annotation THRIFT_SERVICE_ANNOTATION = DriftClientAnnotationFactory.getDriftClientAnnotation(Client.class, DefaultClient.class);

    @Test
    public void testNoDefaults() throws Exception {
        ImmutableList addresses = ImmutableList.of((Object)HostAndPort.fromParts((String)"example.com", (int)1), (Object)HostAndPort.fromParts((String)"example.com", (int)2));
        ImmutableMap properties = ImmutableMap.of((Object)"testService.thrift.client.addresses", (Object)"example.com:1,example.com:2");
        TestSimpleAddressSelectorBinder.testAddressSelector(SimpleAddressSelectorBinder.simpleAddressSelector(), (Map<String, String>)properties, (List<HostAndPort>)addresses);
    }

    @Test
    public void testSingleDefault() throws Exception {
        HostAndPort address = HostAndPort.fromParts((String)"example.com", (int)1);
        TestSimpleAddressSelectorBinder.testAddressSelector(SimpleAddressSelectorBinder.simpleAddressSelector((HostAndPort)address), (Map<String, String>)ImmutableMap.of(), (List<HostAndPort>)ImmutableList.of((Object)address));
        TestSimpleAddressSelectorBinder.testAddressSelector(SimpleAddressSelectorBinder.simpleAddressSelector((HostAndPort)address), (Map<String, String>)ImmutableMap.of((Object)"testService.thrift.client.addresses", (Object)"example.com:11,example.com:22"), (List<HostAndPort>)ImmutableList.of((Object)HostAndPort.fromParts((String)"example.com", (int)11), (Object)HostAndPort.fromParts((String)"example.com", (int)22)));
    }

    @Test
    public void testMultipleDefaults() throws Exception {
        ImmutableList addresses = ImmutableList.of((Object)HostAndPort.fromParts((String)"example.com", (int)1), (Object)HostAndPort.fromParts((String)"example.com", (int)2));
        TestSimpleAddressSelectorBinder.testAddressSelector(SimpleAddressSelectorBinder.simpleAddressSelector((List)addresses), (Map<String, String>)ImmutableMap.of(), (List<HostAndPort>)addresses);
        TestSimpleAddressSelectorBinder.testAddressSelector(SimpleAddressSelectorBinder.simpleAddressSelector((List)addresses), (Map<String, String>)ImmutableMap.of((Object)"testService.thrift.client.addresses", (Object)"example.com:11,example.com:22"), (List<HostAndPort>)ImmutableList.of((Object)HostAndPort.fromParts((String)"example.com", (int)11), (Object)HostAndPort.fromParts((String)"example.com", (int)22)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAddressSelector(AddressSelectorBinder addressSelectorBinder, Map<String, String> configurationProperties, List<HostAndPort> expected) throws Exception {
        Bootstrap app = new Bootstrap(new Module[]{binder -> addressSelectorBinder.bind(binder, THRIFT_SERVICE_ANNOTATION, "testService")});
        LifeCycleManager lifeCycleManager = null;
        try {
            Injector injector = app.setRequiredConfigurationProperties(configurationProperties).strictConfig().doNotInitializeLogging().initialize();
            lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            AddressSelector addressSelector = (AddressSelector)injector.getInstance(Key.get(AddressSelector.class, (Annotation)THRIFT_SERVICE_ANNOTATION));
            Assertions.assertInstanceOf((Object)addressSelector, SimpleAddressSelector.class);
            SimpleAddressSelector simpleAddressSelector = (SimpleAddressSelector)addressSelector;
            Assert.assertEquals((Collection)simpleAddressSelector.getAddresses(), expected);
        }
        finally {
            if (lifeCycleManager != null) {
                try {
                    lifeCycleManager.stop();
                }
                catch (Exception exception) {}
            }
        }
    }

    @ThriftService(value="testService")
    public static interface Client {
        @ThriftMethod
        public String test();
    }
}

