/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client.address;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelector;
import com.facebook.drift.client.address.SimpleAddressSelectorConfig;
import com.facebook.drift.client.guice.AbstractAnnotatedProvider;
import com.facebook.drift.client.guice.AddressSelectorBinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Provider;

public final class SimpleAddressSelectorBinder
implements AddressSelectorBinder {
    private final Optional<List<HostAndPort>> defaultAddresses;

    public static AddressSelectorBinder simpleAddressSelector() {
        return new SimpleAddressSelectorBinder(Optional.empty());
    }

    public static AddressSelectorBinder simpleAddressSelector(HostAndPort defaultAddress) {
        Objects.requireNonNull(defaultAddress, "defaultAddress is null");
        return new SimpleAddressSelectorBinder(Optional.of(ImmutableList.of((Object)defaultAddress)));
    }

    public static AddressSelectorBinder simpleAddressSelector(List<HostAndPort> defaultAddresses) {
        Objects.requireNonNull(defaultAddresses, "defaultAddresses is null");
        Preconditions.checkArgument((!defaultAddresses.isEmpty() ? 1 : 0) != 0, (Object)"defaultAddresses is empty");
        return new SimpleAddressSelectorBinder(Optional.of(ImmutableList.copyOf(defaultAddresses)));
    }

    private SimpleAddressSelectorBinder(Optional<List<HostAndPort>> defaultAddresses) {
        this.defaultAddresses = Objects.requireNonNull(defaultAddresses, "defaultAddresses is null");
    }

    @Override
    public void bind(Binder binder, Annotation annotation, String prefix) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(SimpleAddressSelectorConfig.class, annotation, prefix);
        this.defaultAddresses.ifPresent(addresses -> ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(SimpleAddressSelectorConfig.class, annotation, config -> config.setAddressesList((List<HostAndPort>)addresses)));
        binder.bind(AddressSelector.class).annotatedWith(annotation).toProvider((Provider)new SimpleAddressSelectorProvider(annotation));
    }

    private static class SimpleAddressSelectorProvider
    extends AbstractAnnotatedProvider<AddressSelector<?>> {
        public SimpleAddressSelectorProvider(Annotation annotation) {
            super(annotation);
        }

        @Override
        protected AddressSelector<?> get(Injector injector, Annotation annotation) {
            return new SimpleAddressSelector((SimpleAddressSelectorConfig)injector.getInstance(Key.get(SimpleAddressSelectorConfig.class, (Annotation)annotation)));
        }
    }
}

