/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client.guice;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.configuration.ConfigDefaults;
import com.facebook.drift.client.DriftClient;
import com.facebook.drift.client.DriftClientFactory;
import com.facebook.drift.client.DriftClientFactoryManager;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.client.MethodInvocationFilter;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.guice.AbstractAnnotatedProvider;
import com.facebook.drift.client.guice.DefaultClient;
import com.facebook.drift.client.guice.DriftClientAnnotationFactory;
import com.facebook.drift.client.guice.DriftClientBindingBuilder;
import com.facebook.drift.client.stats.JmxMethodInvocationStatsFactory;
import com.facebook.drift.client.stats.MethodInvocationStatsFactory;
import com.facebook.drift.client.stats.NullMethodInvocationStatsFactory;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.guice.ThriftCodecModule;
import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.facebook.drift.transport.client.DriftClientConfig;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.weakref.jmx.MBeanExporter;

public class DriftClientBinder {
    private final Binder binder;

    public static DriftClientBinder driftClientBinder(Binder binder) {
        return new DriftClientBinder(binder);
    }

    private DriftClientBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        binder.install((Module)new ThriftCodecModule());
        binder.install((Module)new DriftClientBinderModule());
    }

    public <T> DriftClientBindingBuilder bindDriftClient(Class<T> clientInterface) {
        String configPrefix = DriftClientBinder.getServiceName(clientInterface);
        return this.bindDriftClient(clientInterface, configPrefix, DefaultClient.class);
    }

    public <T> DriftClientBindingBuilder bindDriftClient(Class<T> clientInterface, Class<? extends Annotation> annotationType) {
        String configPrefix = DriftClientBinder.getServiceName(clientInterface);
        if (annotationType != DefaultClient.class) {
            configPrefix = configPrefix + "." + annotationType.getSimpleName();
        }
        return this.bindDriftClient(clientInterface, configPrefix, annotationType);
    }

    private <T> DriftClientBindingBuilder bindDriftClient(Class<T> clientInterface, String configPrefix, Class<? extends Annotation> annotation) {
        Annotation clientAnnotation = DriftClientAnnotationFactory.getDriftClientAnnotation(clientInterface, annotation);
        ConfigBinder.configBinder((Binder)this.binder).bindConfig(DriftClientConfig.class, clientAnnotation, configPrefix);
        TypeLiteral<DriftClient<T>> typeLiteral = DriftClientBinder.driftClientTypeLiteral(clientInterface);
        DriftClientInstanceProvider instanceProvider = new DriftClientInstanceProvider(clientAnnotation, Key.get(typeLiteral, annotation));
        DriftClientProvider<T> factoryProvider = new DriftClientProvider<T>(clientInterface, clientAnnotation);
        this.binder.bind(Key.get(clientInterface, annotation)).toProvider(instanceProvider).in(Scopes.SINGLETON);
        this.binder.bind(Key.get(typeLiteral, annotation)).toProvider(factoryProvider).in(Scopes.SINGLETON);
        if (annotation == DefaultClient.class) {
            this.binder.bind(Key.get(clientInterface)).toProvider(instanceProvider).in(Scopes.SINGLETON);
            this.binder.bind(Key.get(typeLiteral)).toProvider(factoryProvider).in(Scopes.SINGLETON);
        }
        return new DriftClientBindingBuilder(this.binder, clientAnnotation, configPrefix);
    }

    public <T> void bindClientConfigDefaults(Class<T> clientInterface, ConfigDefaults<DriftClientConfig> configDefaults) {
        this.bindClientConfigDefaults(clientInterface, DefaultClient.class, configDefaults);
    }

    public <T> void bindClientConfigDefaults(Class<T> clientInterface, Class<? extends Annotation> annotationType, ConfigDefaults<DriftClientConfig> configDefaults) {
        this.bindConfigDefaults(clientInterface, annotationType, DriftClientConfig.class, configDefaults);
    }

    public <T, C> void bindConfigDefaults(Class<T> clientInterface, Class<C> configClass, ConfigDefaults<C> configDefaults) {
        this.bindConfigDefaults(configClass, DefaultClient.class, configClass, configDefaults);
    }

    public <T, C> void bindConfigDefaults(Class<T> clientInterface, Class<? extends Annotation> annotationType, Class<C> configClass, ConfigDefaults<C> configDefaults) {
        ConfigBinder.configBinder((Binder)this.binder).bindConfigDefaults(configClass, DriftClientAnnotationFactory.getDriftClientAnnotation(clientInterface, annotationType), configDefaults);
    }

    private static String getServiceName(Class<?> clientInterface) {
        Objects.requireNonNull(clientInterface, "clientInterface is null");
        String serviceName = ThriftServiceMetadata.getThriftServiceAnnotation(clientInterface).value();
        if (!serviceName.isEmpty()) {
            return serviceName;
        }
        return clientInterface.getSimpleName();
    }

    private static <T> TypeLiteral<DriftClient<T>> driftClientTypeLiteral(Class<T> clientInterface) {
        Type javaType = new TypeToken<DriftClient<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(clientInterface)).getType();
        return TypeLiteral.get((Type)javaType);
    }

    private static class DriftClientBinderModule
    implements Module {
        private DriftClientBinderModule() {
        }

        public void configure(Binder binder) {
            Multibinder.newSetBinder((Binder)binder, ExceptionClassifier.class);
            OptionalBinder.newOptionalBinder((Binder)binder, MBeanExporter.class);
            OptionalBinder.newOptionalBinder((Binder)binder, MethodInvocationStatsFactory.class).setDefault().toProvider(DefaultMethodInvocationStatsFactoryProvider.class).in(Scopes.SINGLETON);
        }

        @Provides
        @Singleton
        private static DriftClientFactoryManager<Annotation> getDriftClientFactory(ThriftCodecManager codecManager, MethodInvokerFactory<Annotation> methodInvokerFactory, MethodInvocationStatsFactory methodInvocationStatsFactory) {
            return new DriftClientFactoryManager<Annotation>(codecManager, methodInvokerFactory, methodInvocationStatsFactory);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class DriftClientInstanceProvider<T>
    extends AbstractAnnotatedProvider<T> {
        private final Key<DriftClient<T>> key;

        public DriftClientInstanceProvider(Annotation annotation, Key<DriftClient<T>> key) {
            super(annotation);
            this.key = Objects.requireNonNull(key, "key is null");
        }

        @Override
        protected T get(Injector injector, Annotation annotation) {
            return ((DriftClient)injector.getInstance(this.key)).get();
        }
    }

    private static class DriftClientProvider<T>
    extends AbstractAnnotatedProvider<DriftClient<T>> {
        private static final TypeLiteral<DriftClientFactoryManager<Annotation>> DRIFT_CLIENT_FACTORY_MANAGER_TYPE = new TypeLiteral<DriftClientFactoryManager<Annotation>>(){};
        private static final TypeLiteral<Set<MethodInvocationFilter>> SET_METHOD_INVOCATION_FILTERS_TYPE = new TypeLiteral<Set<MethodInvocationFilter>>(){};
        private static final TypeLiteral<Set<ExceptionClassifier>> SET_EXCEPTION_CLASSIFIER_TYPE = new TypeLiteral<Set<ExceptionClassifier>>(){};
        private final Class<T> clientInterface;

        public DriftClientProvider(Class<T> clientInterface, Annotation annotation) {
            super(annotation);
            this.clientInterface = Objects.requireNonNull(clientInterface, "clientInterface is null");
        }

        @Override
        protected DriftClient<T> get(Injector injector, Annotation clientAnnotation) {
            DriftClientConfig config = (DriftClientConfig)injector.getInstance(Key.get(DriftClientConfig.class, (Annotation)clientAnnotation));
            DriftClientFactoryManager driftClientFactoryManager = (DriftClientFactoryManager)injector.getInstance(Key.get(DRIFT_CLIENT_FACTORY_MANAGER_TYPE));
            AddressSelector addressSelector = (AddressSelector)injector.getInstance(Key.get(AddressSelector.class, (Annotation)clientAnnotation));
            ExceptionClassifier exceptionClassifier = ExceptionClassifier.mergeExceptionClassifiers((Iterable<? extends ExceptionClassifier>)ImmutableList.builder().addAll((Iterable)injector.getInstance(Key.get(SET_EXCEPTION_CLASSIFIER_TYPE, (Annotation)clientAnnotation))).addAll((Iterable)injector.getInstance(Key.get(SET_EXCEPTION_CLASSIFIER_TYPE))).build());
            ImmutableList filters = ImmutableList.copyOf((Collection)((Collection)injector.getInstance(Key.get(SET_METHOD_INVOCATION_FILTERS_TYPE, (Annotation)clientAnnotation))));
            DriftClientFactory driftClientFactory = driftClientFactoryManager.createDriftClientFactory(clientAnnotation, addressSelector, exceptionClassifier);
            return driftClientFactory.createDriftClient(this.clientInterface, DriftClientAnnotationFactory.extractDriftClientBindingAnnotation(clientAnnotation), (List<MethodInvocationFilter>)filters, config);
        }
    }

    private static class DefaultMethodInvocationStatsFactoryProvider
    implements Provider<MethodInvocationStatsFactory> {
        private final Optional<MBeanExporter> mbeanExporter;

        @Inject
        public DefaultMethodInvocationStatsFactoryProvider(Optional<MBeanExporter> mbeanExporter) {
            this.mbeanExporter = mbeanExporter;
        }

        public MethodInvocationStatsFactory get() {
            return this.mbeanExporter.map(JmxMethodInvocationStatsFactory::new).map(MethodInvocationStatsFactory.class::cast).orElseGet(NullMethodInvocationStatsFactory::new);
        }
    }
}

