/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.utils;

import com.facebook.drift.codec.CodecThriftType;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.coercion.FromThrift;
import com.facebook.drift.codec.internal.coercion.ToThrift;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import io.airlift.units.DataSize;
import java.util.Objects;
import javax.inject.Inject;

public class DataSizeToBytesThriftCodec
implements ThriftCodec<DataSize> {
    private static final ThriftType THRIFT_TYPE = new ThriftType(ThriftType.DOUBLE, DataSize.class);

    @Inject
    public DataSizeToBytesThriftCodec(ThriftCatalog thriftCatalog) {
        thriftCatalog.addDefaultCoercions(this.getClass());
    }

    @CodecThriftType
    public static ThriftType getThriftType() {
        return THRIFT_TYPE;
    }

    public ThriftType getType() {
        return THRIFT_TYPE;
    }

    public DataSize read(TProtocolReader protocol) throws Exception {
        return DataSizeToBytesThriftCodec.bytesToDataSize(protocol.readDouble());
    }

    public void write(DataSize dataSize, TProtocolWriter protocol) throws Exception {
        protocol.writeDouble(DataSizeToBytesThriftCodec.dataSizeToBytes(dataSize));
    }

    @FromThrift
    public static DataSize bytesToDataSize(double bytes) {
        return new DataSize(bytes, DataSize.Unit.BYTE);
    }

    @ToThrift
    public static double dataSizeToBytes(DataSize dataSize) {
        Objects.requireNonNull(dataSize, "dataSize is null");
        return dataSize.getValue(DataSize.Unit.BYTE);
    }
}

