/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.utils;

import com.facebook.drift.codec.CodecThriftType;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.coercion.FromThrift;
import com.facebook.drift.codec.internal.coercion.ToThrift;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.util.Objects;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class JodaDateTimeToEpochMillisThriftCodec
implements ThriftCodec<DateTime> {
    private static final ThriftType THRIFT_TYPE = new ThriftType(ThriftType.I64, DateTime.class);

    @Inject
    public JodaDateTimeToEpochMillisThriftCodec(ThriftCatalog thriftCatalog) {
        thriftCatalog.addDefaultCoercions(this.getClass());
    }

    @CodecThriftType
    public static ThriftType getThriftType() {
        return THRIFT_TYPE;
    }

    public ThriftType getType() {
        return THRIFT_TYPE;
    }

    public DateTime read(TProtocolReader protocol) throws Exception {
        return JodaDateTimeToEpochMillisThriftCodec.longToDateTime(protocol.readI64());
    }

    public void write(DateTime dateTime, TProtocolWriter protocol) throws Exception {
        protocol.writeI64(JodaDateTimeToEpochMillisThriftCodec.dateTimeToLong(dateTime));
    }

    @FromThrift
    public static DateTime longToDateTime(long instant) {
        return new DateTime(instant);
    }

    @ToThrift
    public static long dateTimeToLong(DateTime dateTime) {
        Objects.requireNonNull(dateTime, "dateTime is null");
        return dateTime.getMillis();
    }
}

