/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.compiler;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ForCompiler;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.ThriftCodecByteCodeGenerator;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.google.inject.Inject;
import io.airlift.bytecode.DynamicClassLoader;
import java.security.AccessController;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CompilerThriftCodecFactory
implements ThriftCodecFactory {
    private final boolean debug;
    private final DynamicClassLoader classLoader;

    @Inject
    public CompilerThriftCodecFactory(@ForCompiler ClassLoader parent) {
        this(false, parent);
    }

    public CompilerThriftCodecFactory(boolean debug) {
        this(debug, (ClassLoader)CompilerThriftCodecFactory.getPrivilegedClassLoader(CompilerThriftCodecFactory.class.getClassLoader()));
    }

    public CompilerThriftCodecFactory(boolean debug, ClassLoader parent) {
        this.debug = debug;
        this.classLoader = CompilerThriftCodecFactory.getPrivilegedClassLoader(parent);
    }

    @Override
    public ThriftCodec<?> generateThriftTypeCodec(ThriftCodecManager codecManager, ThriftStructMetadata metadata) {
        ThriftCodecByteCodeGenerator generator = new ThriftCodecByteCodeGenerator(codecManager, metadata, this.classLoader, this.debug);
        return generator.getThriftCodec();
    }

    private static DynamicClassLoader getPrivilegedClassLoader(ClassLoader parent) {
        return AccessController.doPrivileged(() -> new DynamicClassLoader(parent));
    }
}

