/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ThriftStruct(value="Array")
public final class ArrayField {
    @ThriftField(value=1)
    public boolean[] booleanArray;
    @ThriftField(value=2)
    public short[] shortArray;
    @ThriftField(value=3)
    public int[] intArray;
    @ThriftField(value=4)
    public long[] longArray;
    @ThriftField(value=5)
    public double[] doubleArray;
    @ThriftField(value=6)
    public byte[] byteArray;
    @ThriftField(value=11)
    public Map<Short, boolean[]> mapBooleanArray;
    @ThriftField(value=12)
    public Map<Short, short[]> mapShortArray;
    @ThriftField(value=13)
    public Map<Short, int[]> mapIntArray;
    @ThriftField(value=14)
    public Map<Short, long[]> mapLongArray;
    @ThriftField(value=15)
    public Map<Short, double[]> mapDoubleArray;

    public ArrayField() {
    }

    public ArrayField(boolean[] booleanArray, short[] shortArray, int[] intArray, long[] longArray, double[] doubleArray, byte[] byteArray) {
        this.booleanArray = booleanArray;
        this.shortArray = shortArray;
        this.intArray = intArray;
        this.longArray = longArray;
        this.doubleArray = doubleArray;
        this.byteArray = byteArray;
    }

    public ArrayField(boolean[] booleanArray, short[] shortArray, int[] intArray, long[] longArray, double[] doubleArray, byte[] byteArray, Map<Short, boolean[]> mapBooleanArray, Map<Short, short[]> mapShortArray, Map<Short, int[]> mapIntArray, Map<Short, long[]> mapLongArray, Map<Short, double[]> mapDoubleArray) {
        this.booleanArray = booleanArray;
        this.shortArray = shortArray;
        this.intArray = intArray;
        this.longArray = longArray;
        this.doubleArray = doubleArray;
        this.byteArray = byteArray;
        this.mapBooleanArray = mapBooleanArray;
        this.mapShortArray = mapShortArray;
        this.mapIntArray = mapIntArray;
        this.mapLongArray = mapLongArray;
        this.mapDoubleArray = mapDoubleArray;
    }

    public Map<Short, List<Boolean>> getMapBooleanList() {
        if (this.mapBooleanArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapBooleanArray, Booleans::asList);
    }

    public Map<Short, List<Short>> getMapShortList() {
        if (this.mapShortArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapShortArray, Shorts::asList);
    }

    public Map<Short, List<Integer>> getMapIntegerList() {
        if (this.mapIntArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapIntArray, Ints::asList);
    }

    public Map<Short, List<Long>> getMapLongList() {
        if (this.mapLongArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapLongArray, Longs::asList);
    }

    public Map<Short, List<Double>> getMapDoubleList() {
        if (this.mapDoubleArray == null) {
            return null;
        }
        return Maps.transformValues(this.mapDoubleArray, Doubles::asList);
    }

    public int hashCode() {
        return Objects.hash(this.booleanArray, this.shortArray, this.intArray, this.longArray, this.doubleArray, this.byteArray, this.getMapBooleanList(), this.getMapShortList(), this.getMapIntegerList(), this.getMapLongList(), this.getMapDoubleList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayField other = (ArrayField)obj;
        return Arrays.equals(this.booleanArray, other.booleanArray) && Arrays.equals(this.shortArray, other.shortArray) && Arrays.equals(this.intArray, other.intArray) && Arrays.equals(this.longArray, other.longArray) && Arrays.equals(this.doubleArray, other.doubleArray) && Arrays.equals(this.byteArray, other.byteArray) && Objects.equals(this.getMapBooleanList(), other.getMapBooleanList()) && Objects.equals(this.getMapShortList(), other.getMapShortList()) && Objects.equals(this.getMapIntegerList(), other.getMapIntegerList()) && Objects.equals(this.getMapLongList(), other.getMapLongList()) && Objects.equals(this.getMapDoubleList(), other.getMapDoubleList());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("booleanArray", (Object)Arrays.toString(this.booleanArray)).add("shortArray", (Object)Arrays.toString(this.shortArray)).add("intArray", (Object)Arrays.toString(this.intArray)).add("longArray", (Object)Arrays.toString(this.longArray)).add("doubleArray", (Object)Arrays.toString(this.doubleArray)).add("byteArray", (Object)Arrays.toString(this.byteArray)).add("mapBooleanArray", this.getMapBooleanList()).add("mapShortArray", this.getMapShortList()).add("mapIntArray", this.getMapIntegerList()).add("mapLongArray", this.getMapLongList()).add("mapDoubleArray", this.getMapDoubleList()).toString();
    }
}

