/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.codec.BonkField;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;

public class BonkFieldThriftCodec
implements ThriftCodec<BonkField> {
    private final ThriftType type;

    public BonkFieldThriftCodec(ThriftType type) {
        this.type = type;
    }

    public ThriftType getType() {
        return this.type;
    }

    public BonkField read(TProtocolReader protocol) throws Exception {
        ProtocolReader reader = new ProtocolReader(protocol);
        String message = null;
        int type = 0;
        reader.readStructBegin();
        block4: while (reader.nextField()) {
            switch (reader.getFieldId()) {
                case 1: {
                    message = reader.readStringField();
                    continue block4;
                }
                case 2: {
                    type = reader.readI32Field();
                    continue block4;
                }
            }
            reader.skipFieldData();
        }
        reader.readStructEnd();
        BonkField bonkField = new BonkField();
        if (message != null) {
            bonkField.message = message;
        }
        bonkField.type = type;
        return bonkField;
    }

    public void write(BonkField value, TProtocolWriter protocol) throws Exception {
        ProtocolWriter writer = new ProtocolWriter(protocol);
        writer.writeStructBegin("bonk");
        String message = value.message;
        if (message != null) {
            writer.writeStringField("message", (short)1, message);
        }
        writer.writeI32Field("type", (short)2, value.type);
        writer.writeStructEnd();
    }
}

