/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.codec.Fruit;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.UnionField;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.google.common.base.Preconditions;

public class UnionFieldThriftCodec
implements ThriftCodec<UnionField> {
    private final ThriftType type;
    private final ThriftCodec<Fruit> fruitCodec;

    public UnionFieldThriftCodec(ThriftType type, ThriftCodec<Fruit> fruitCodec) {
        this.type = type;
        this.fruitCodec = fruitCodec;
    }

    public ThriftType getType() {
        return this.type;
    }

    public UnionField read(TProtocolReader protocol) throws Exception {
        ProtocolReader reader = new ProtocolReader(protocol);
        UnionField field = new UnionField();
        reader.readStructBegin();
        boolean consumed = false;
        block5: while (reader.nextField()) {
            Preconditions.checkState((!consumed ? 1 : 0) != 0, (Object)"already consumed");
            field.id = reader.getFieldId();
            switch (field.id) {
                case 1: {
                    field.stringValue = reader.readStringField();
                    consumed = true;
                    continue block5;
                }
                case 2: {
                    field.longValue = reader.readI64Field();
                    consumed = true;
                    continue block5;
                }
                case 3: {
                    field.fruitValue = (Fruit)reader.readEnumField(this.fruitCodec);
                    consumed = true;
                    continue block5;
                }
            }
            field.id = (short)-1;
            reader.skipFieldData();
        }
        reader.readStructEnd();
        return field;
    }

    public void write(UnionField value, TProtocolWriter protocol) throws Exception {
        ProtocolWriter writer = new ProtocolWriter(protocol);
        writer.writeStructBegin("union");
        switch (value.id) {
            case 1: {
                writer.writeStringField("stringValue", (short)1, value.stringValue);
                break;
            }
            case 2: {
                writer.writeI64Field("longValue", (short)2, value.longValue.longValue());
                break;
            }
            case 3: {
                writer.writeEnumField("fruitValue", (short)3, this.fruitCodec, (Enum)value.fruitValue);
            }
        }
        writer.writeStructEnd();
    }
}

