/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.drift.annotations.ThriftUnion;
import com.facebook.drift.annotations.ThriftUnionId;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.FieldMetadata;
import com.facebook.drift.codec.metadata.MetadataErrorException;
import com.facebook.drift.codec.metadata.MetadataErrors;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadataBuilder;
import com.facebook.drift.codec.metadata.ThriftUnionMetadataBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.testng.annotations.Test;

public class TestLegacyFieldIds {
    @Test
    public void testLegacyIdCorrectlyAnnotated() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdCorrect.class);
        ThriftStructMetadata metadata = builder.build();
        HashSet<Integer> seen = new HashSet<Integer>();
        for (ThriftFieldMetadata field : metadata.getFields()) {
            seen.add(Integer.valueOf(field.getId()));
        }
        Assertions.assertThat(seen).as("fields found in LegacyIdCorrect", new Object[0]).isEqualTo((Object)LegacyIdCorrect.IDS);
    }

    @Test
    public void testLegacyIdCorrectlyAnnotatedWhiteBox() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdCorrect.class);
        HashSet<Integer> seen = new HashSet<Integer>();
        for (FieldMetadata field : builder.fields) {
            String name = field.getName();
            short id = field.getId();
            Boolean legacy = field.isLegacyId();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)name).as("name of field " + field, new Object[0])).matches((CharSequence)"^(notLegacy|legacy).*");
            if (name.startsWith("legacy")) {
                ((AbstractShortAssert)Assertions.assertThat((short)id).as("id of field " + field, new Object[0])).isLessThan((short)0);
                ((AbstractBooleanAssert)Assertions.assertThat((Boolean)legacy).as("isLegacyId of field " + field, new Object[0])).isTrue();
            } else {
                ((AbstractShortAssert)Assertions.assertThat((short)id).as("id of field " + field, new Object[0])).isGreaterThanOrEqualTo((short)0);
                ((AbstractBooleanAssert)Assertions.assertThat((Boolean)legacy).as("isLegacyId of field " + field, new Object[0])).isFalse();
            }
            seen.add(Integer.valueOf(id));
        }
        Assertions.assertThat(seen).as("present fields in the struct", new Object[0]).isEqualTo((Object)LegacyIdCorrect.IDS);
    }

    @Test
    public void testLegacyIdIncorrect() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdIncorrectlyMissing.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"has a negative field id but not isLegacyId=true");
        builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), LegacyIdIncorrectlyPresent.class);
        metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"has isLegacyId=true but not a negative field id");
        for (Class invalidClass : Arrays.asList(LegacyIdInconsistent1.class, LegacyIdInconsistent2.class, LegacyIdInconsistent3.class, LegacyIdInconsistent4.class)) {
            ThriftStructMetadataBuilder builder2 = new ThriftStructMetadataBuilder(new ThriftCatalog(), (Type)invalidClass);
            MetadataErrors metadataErrors2 = builder2.getMetadataErrors();
            Assertions.assertThat((List)metadataErrors2.getErrors()).as("metadata errors", new Object[0]).isNotEmpty();
            Assertions.assertThat((List)metadataErrors2.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors2.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"has both isLegacyId=true and isLegacyId=false");
        }
    }

    @Test
    public void testGetThriftFieldIsLegacyId() {
        Function<ThriftField, FieldMetadata> makeFakeFieldMetadata = input -> new FieldMetadata((ThriftField)input, FieldKind.THRIFT_FIELD){

            public Type getJavaType() {
                throw new UnsupportedOperationException();
            }

            public String extractName() {
                throw new UnsupportedOperationException();
            }
        };
        for (Field f : ReflectionHelper.findAnnotatedFields(SomeThriftFields.class, ThriftField.class)) {
            Optional<Boolean> expected;
            if (f.getName().startsWith("expectTrue")) {
                expected = Optional.of(true);
            } else if (f.getName().startsWith("expectFalse")) {
                expected = Optional.of(false);
            } else if (f.getName().startsWith("expectNothing")) {
                expected = Optional.empty();
            } else {
                Preconditions.checkArgument((boolean)f.getName().startsWith("broken"));
                continue;
            }
            Optional actual = makeFakeFieldMetadata.apply(f.getAnnotation(ThriftField.class)).getThriftFieldIsLegacyId();
            ((OptionalAssert)Assertions.assertThat((Optional)actual).as("result of getThriftFieldIsLegacyId on " + f, new Object[0])).isEqualTo(expected);
        }
    }

    @Test
    public void testLegacyIdOnUnion() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), LegacyIdUnionCorrect.class);
        ThriftStructMetadata metadata = builder.build();
        HashSet<Integer> seen = new HashSet<Integer>();
        for (ThriftFieldMetadata field : metadata.getFields()) {
            seen.add(Integer.valueOf(field.getId()));
        }
        Assertions.assertThat(seen).as("fields found in LegacyIdUnionCorrect", new Object[0]).isEqualTo((Object)LegacyIdUnionCorrect.IDS);
    }

    @ThriftUnion
    public static final class LegacyIdUnionCorrect {
        private static final Set<Integer> IDS = ImmutableSet.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object[])new Integer[]{2, Short.MIN_VALUE});
        @ThriftUnionId
        public short unionId;
        @ThriftField(value=0)
        public boolean notLegacyId0;
        @ThriftField(value=1)
        public boolean notLegacyId1;
        @ThriftField(value=2)
        public boolean notLegacyId2;
        @ThriftField(value=-1, isLegacyId=true)
        public boolean legacyIdOnField;

        @ThriftField(value=-2, isLegacyId=true)
        public boolean getLegacyIdOnGetterOnly() {
            return false;
        }

        @ThriftField
        public void setLegacyIdOnGetterOnly(boolean value) {
        }

        @ThriftField
        public boolean getLegacyIdOnSetterOnly() {
            return false;
        }

        @ThriftField(value=-3, isLegacyId=true)
        public void setLegacyIdOnSetterOnly(boolean value) {
        }

        @ThriftField(value=-4, isLegacyId=true)
        public boolean getLegacyIdOnBoth() {
            return false;
        }

        @ThriftField(value=-4, isLegacyId=true)
        public void setLegacyIdOnBoth(boolean value) {
        }
    }

    private static class SomeThriftFields {
        @ThriftField(value=1)
        boolean expectFalse1;
        @ThriftField(value=-1)
        boolean expectFalse2;
        @ThriftField
        boolean broken;
        @ThriftField(value=1, isLegacyId=true)
        boolean expectTrue1;
        @ThriftField(value=-1, isLegacyId=true)
        boolean expectTrue2;
        @ThriftField(isLegacyId=true)
        boolean expectTrue3;
        @ThriftField
        boolean expectNothing;

        private SomeThriftFields() {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent4 {
        @ThriftField(value=4)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=4, isLegacyId=true)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent3 {
        @ThriftField(value=4, isLegacyId=true)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=4)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent2 {
        @ThriftField(value=-4)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=-4, isLegacyId=true)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdInconsistent1 {
        @ThriftField(value=-4, isLegacyId=true)
        public boolean getField() {
            return false;
        }

        @ThriftField(value=-4)
        public void setField(boolean value) {
        }
    }

    @ThriftStruct
    public static final class LegacyIdIncorrectlyPresent {
        @ThriftField(value=4, isLegacyId=true)
        public boolean field;
    }

    @ThriftStruct
    public static final class LegacyIdIncorrectlyMissing {
        @ThriftField(value=-4)
        public boolean field;
    }

    @ThriftStruct
    public static final class LegacyIdCorrect {
        private static final Set<Integer> IDS = ImmutableSet.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object[])new Integer[]{2});
        @ThriftField(value=0)
        public boolean notLegacyId0;
        @ThriftField(value=1)
        public boolean notLegacyId1;
        @ThriftField(value=2)
        public boolean notLegacyId2;
        @ThriftField(value=-1, isLegacyId=true)
        public boolean legacyIdOnField;

        @ThriftField(value=-2, isLegacyId=true)
        public boolean getLegacyIdOnGetterOnly() {
            return false;
        }

        @ThriftField
        public void setLegacyIdOnGetterOnly(boolean value) {
        }

        @ThriftField
        public boolean getLegacyIdOnSetterOnly() {
            return false;
        }

        @ThriftField(value=-3, isLegacyId=true)
        public void setLegacyIdOnSetterOnly(boolean value) {
        }

        @ThriftField(value=-4, isLegacyId=true)
        public boolean getLegacyIdOnBoth() {
            return false;
        }

        @ThriftField(value=-4, isLegacyId=true)
        public void setLegacyIdOnBoth(boolean value) {
        }
    }
}

