/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Executable;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestReflectionHelper {
    @Test
    public void testExtractParameterNamesNoAnnotations() throws Exception {
        Assert.assertEquals((Collection)ReflectionHelper.extractParameterNames((Executable)this.getClass().getDeclaredMethod("noAnnotations", String.class, String.class, String.class)), (Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    private static void noAnnotations(String a, String b, String c) {
    }

    @Test
    public void testExtractParameterNamesThriftFieldAnnotation() throws Exception {
        Assert.assertEquals((Collection)ReflectionHelper.extractParameterNames((Executable)this.getClass().getDeclaredMethod("thriftFieldAnnotation", String.class, String.class, String.class)), (Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    private static void thriftFieldAnnotation(@ThriftField(name="a") String arg0, @ThriftField(name="b") String arg1, @ThriftField(name="c") String arg2) {
    }

    @Test
    public void testExtractParameterNamesMixedThriftFieldAnnotation() throws Exception {
        Assert.assertEquals((Collection)ReflectionHelper.extractParameterNames((Executable)this.getClass().getDeclaredMethod("mixedThriftFieldAnnotation", String.class, String.class, String.class)), (Collection)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    private static void mixedThriftFieldAnnotation(@ThriftField(name="a") String arg0, String b, @ThriftField(name="c") String arg2) {
    }
}

