/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.TException;
import com.facebook.drift.annotations.ThriftException;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftHeader;
import com.facebook.drift.annotations.ThriftId;
import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftHeaderParameter;
import com.facebook.drift.codec.metadata.ThriftMethodMetadata;
import com.facebook.drift.codec.metadata.ThriftType;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftMethodMetadata {
    private static final ThriftCatalog THRIFT_CATALOG = new ThriftCatalog();

    @Test
    public void testValidInferredFieldId() {
        ThriftMethodMetadata metadata = TestThriftMethodMetadata.extractThriftMethodMetadata("validInferredFieldId");
        TestThriftMethodMetadata.assertParameterId(metadata, 1);
    }

    @Test
    public void testValidNormalFieldId() {
        ThriftMethodMetadata metadata = TestThriftMethodMetadata.extractThriftMethodMetadata("validNormalFieldId");
        TestThriftMethodMetadata.assertParameterId(metadata, 4);
    }

    @Test
    public void testValidLegacyFieldId() {
        ThriftMethodMetadata metadata = TestThriftMethodMetadata.extractThriftMethodMetadata("validLegacyFieldId");
        TestThriftMethodMetadata.assertParameterId(metadata, -4);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="isLegacyId (must|should only) be specified.*")
    public void testInvalidNormalFieldIdMarkedLegacy() {
        TestThriftMethodMetadata.extractThriftMethodMetadata("invalidNormalFieldIdMarkedLegacy");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="isLegacyId (must|should only) be specified.*")
    public void invalidInferredFieldIdMarkedLegacy() {
        TestThriftMethodMetadata.extractThriftMethodMetadata("invalidInferredFieldIdMarkedLegacy");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="isLegacyId (must|should only) be specified.*")
    public void invalidLegacyFieldId() {
        TestThriftMethodMetadata.extractThriftMethodMetadata("invalidLegacyFieldId");
    }

    @Test
    public void testValidHeaderWithInferredFieldIds() {
        Method validHeaderWithInferredFieldIds = TestThriftMethodMetadata.getMethod("validHeaderParameters", String.class, Boolean.TYPE, String.class, Boolean.TYPE, Boolean.TYPE);
        ThriftMethodMetadata metadata = new ThriftMethodMetadata(validHeaderWithInferredFieldIds, THRIFT_CATALOG);
        List parameters = metadata.getParameters();
        Assert.assertEquals((int)parameters.size(), (int)3);
        Assert.assertEquals((int)((ThriftFieldMetadata)parameters.get(0)).getId(), (int)1);
        Assert.assertEquals((int)((ThriftFieldMetadata)parameters.get(1)).getId(), (int)22);
        Assert.assertEquals((int)((ThriftFieldMetadata)parameters.get(2)).getId(), (int)3);
        Assert.assertEquals((Set)metadata.getHeaderParameters(), (Set)ImmutableSet.of((Object)new ThriftHeaderParameter(0, "header1"), (Object)new ThriftHeaderParameter(2, "header2")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod .* parameter 1 must not be annotated with both @ThriftField and @ThriftHeader")
    public void invalidHeaderAndFieldParameter() {
        Method validHeaderWithInferredFieldIds = TestThriftMethodMetadata.getMethod("invalidHeaderAndFieldParameter", Boolean.TYPE, String.class);
        new ThriftMethodMetadata(validHeaderWithInferredFieldIds, THRIFT_CATALOG);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod .* parameter 1 annotated with @ThriftHeader must be a String")
    public void invalidHeaderType() {
        Method validHeaderWithInferredFieldIds = TestThriftMethodMetadata.getMethod("invalidHeaderType", Boolean.TYPE, Integer.TYPE);
        new ThriftMethodMetadata(validHeaderWithInferredFieldIds, THRIFT_CATALOG);
    }

    @Test
    public void testNoExceptions() {
        TestThriftMethodMetadata.assertExceptions("noExceptions", new Class[0]);
    }

    @Test
    public void testAnnotatedExceptions() {
        TestThriftMethodMetadata.assertExceptions("annotatedExceptionsMethod", ExceptionA.class, ExceptionB.class);
        TestThriftMethodMetadata.assertExceptions("annotatedExceptionsThrows", ExceptionA.class, ExceptionB.class);
    }

    @Test
    public void testInferredException() {
        TestThriftMethodMetadata.assertExceptions("inferredException", ExceptionA.class);
    }

    @Test
    public void testInferredExceptionWithTException() {
        TestThriftMethodMetadata.assertExceptions("inferredExceptionWithTException", ExceptionA.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod \\[.*\\.nonThriftException] exception \\[IllegalArgumentException] is not annotated with @ThriftStruct")
    public void testNonThriftException() {
        TestThriftMethodMetadata.assertExceptions("nonThriftException", new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod \\[.*\\.invalidInferredExceptionFirst] annotation must declare exception mapping when more than one custom exception is thrown")
    public void testInvalidInferredExceptionFirst() {
        TestThriftMethodMetadata.assertExceptions("invalidInferredExceptionFirst", new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod \\[.*\\.invalidInferredExceptionSecond] annotation must declare exception mapping when more than one custom exception is thrown")
    public void testInvalidInferredExceptionSecond() {
        TestThriftMethodMetadata.assertExceptions("invalidInferredExceptionSecond", new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod \\[.*\\.testDuplicateExceptionType] exception list contains multiple values for type \\[ExceptionA]")
    public void testInvalidExceptionDuplicateType() {
        TestThriftMethodMetadata.assertExceptions("testDuplicateExceptionType", new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod \\[.*\\.testDuplicateExceptionFieldMethod] exception list contains multiple values for field ID \\[3]")
    public void testDuplicateExceptionFieldMethod() {
        TestThriftMethodMetadata.assertExceptions("testDuplicateExceptionFieldMethod", new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod \\[.*\\.testDuplicateExceptionFieldThrows] exception list contains multiple values for field ID \\[4]")
    public void testDuplicateExceptionFieldThrows() {
        TestThriftMethodMetadata.assertExceptions("testDuplicateExceptionFieldThrows", new Class[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ThriftMethod \\[.*\\.testExceptionMixedAnnotationStyle] uses a mix of @ThriftException and @ThriftId")
    public void testExceptionMixedAnnotationStyle() {
        TestThriftMethodMetadata.assertExceptions("testExceptionMixedAnnotationStyle", new Class[0]);
    }

    @SafeVarargs
    private static void assertExceptions(String methodName, Class<? extends Exception> ... expectedExceptions) {
        ThriftMethodMetadata metadata = new ThriftMethodMetadata(TestThriftMethodMetadata.getMethod(methodName, new Class[0]), new ThriftCatalog());
        TreeMap actualIdMap = new TreeMap();
        TreeMap<Short, Class<? extends Exception>> expectedIdMap = new TreeMap<Short, Class<? extends Exception>>();
        for (Map.Entry entry : metadata.getExceptions().entrySet()) {
            actualIdMap.put(entry.getKey(), ((ThriftType)entry.getValue()).getJavaType());
        }
        short expectedId = 1;
        for (Class<? extends Exception> expectedException : expectedExceptions) {
            expectedIdMap.put(expectedId, expectedException);
            expectedId = (short)(expectedId + 1);
        }
        if (!actualIdMap.equals(expectedIdMap)) {
            Assert.assertEquals((String)((Object)actualIdMap).toString(), (String)((Object)expectedIdMap).toString());
        }
    }

    private static void assertParameterId(ThriftMethodMetadata metadata, int expectedFieldId) {
        List parameters = metadata.getParameters();
        Assert.assertEquals((int)parameters.size(), (int)1);
        Assert.assertEquals((int)((ThriftFieldMetadata)parameters.get(0)).getId(), (int)expectedFieldId);
    }

    private static ThriftMethodMetadata extractThriftMethodMetadata(String methodName) {
        return new ThriftMethodMetadata(TestThriftMethodMetadata.getMethod(methodName, Boolean.TYPE), THRIFT_CATALOG);
    }

    private static Method getMethod(String name, Class<?> ... parameterTypes) {
        try {
            return TestService.class.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("Method not found: " + name, e);
        }
    }

    @ThriftStruct
    public static final class ExceptionB
    extends Exception {
    }

    @ThriftStruct
    public static final class ExceptionA
    extends Exception {
    }

    public static interface TestService {
        @ThriftMethod
        public void validInferredFieldId(@ThriftField boolean var1);

        @ThriftMethod
        public void validNormalFieldId(@ThriftField(value=4) boolean var1);

        @ThriftMethod
        public void validLegacyFieldId(@ThriftField(value=-4, isLegacyId=true) boolean var1);

        @ThriftMethod
        public void invalidNormalFieldIdMarkedLegacy(@ThriftField(value=5, isLegacyId=true) boolean var1);

        @ThriftMethod
        public void invalidInferredFieldIdMarkedLegacy(@ThriftField(isLegacyId=true) boolean var1);

        @ThriftMethod
        public void invalidLegacyFieldId(@ThriftField(value=-5) boolean var1);

        @ThriftMethod
        public void validHeaderParameters(@ThriftHeader(value="header1") String var1, boolean var2, @ThriftHeader(value="header2") String var3, @ThriftField(value=22) boolean var4, boolean var5);

        @ThriftMethod
        public void invalidHeaderAndFieldParameter(boolean var1, @ThriftField(value=22) @ThriftHeader(value="header1") String var2);

        @ThriftMethod
        public void invalidHeaderType(boolean var1, @ThriftHeader(value="header1") int var2);

        @ThriftMethod
        public void noExceptions();

        @ThriftMethod(exception={@ThriftException(id=1, type=ExceptionA.class), @ThriftException(id=2, type=ExceptionB.class)})
        public void annotatedExceptionsMethod() throws ExceptionA, ExceptionB;

        @ThriftMethod
        public void annotatedExceptionsThrows() throws @ThriftId(value=1) ExceptionA, @ThriftId(value=2) ExceptionB;

        @ThriftMethod
        public void inferredException() throws ExceptionA;

        @ThriftMethod
        public void inferredExceptionWithTException() throws ExceptionA, TException;

        @ThriftMethod
        public void nonThriftException() throws IllegalArgumentException;

        @ThriftMethod(exception={@ThriftException(id=1, type=ExceptionA.class)})
        public void invalidInferredExceptionFirst() throws ExceptionA, ExceptionB;

        @ThriftMethod(exception={@ThriftException(id=1, type=ExceptionB.class)})
        public void invalidInferredExceptionSecond() throws ExceptionA, ExceptionB;

        @ThriftMethod(exception={@ThriftException(id=1, type=ExceptionA.class), @ThriftException(id=2, type=ExceptionA.class)})
        public void testDuplicateExceptionType() throws ExceptionA;

        @ThriftMethod(exception={@ThriftException(id=3, type=ExceptionA.class), @ThriftException(id=3, type=ExceptionB.class)})
        public void testDuplicateExceptionFieldMethod() throws ExceptionA, ExceptionB;

        @ThriftMethod
        public void testDuplicateExceptionFieldThrows() throws @ThriftId(value=4) ExceptionA, @ThriftId(value=4) ExceptionB;

        @ThriftMethod(exception={@ThriftException(id=5, type=ExceptionA.class)})
        public void testExceptionMixedAnnotationStyle() throws ExceptionA, @ThriftId(value=6) ExceptionB;
    }
}

