/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftOrder;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftMethodMetadata;
import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestThriftServiceMetadata {
    private ThriftCatalog catalog;

    @BeforeClass
    public void setUp() {
        this.catalog = new ThriftCatalog();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.catalog = null;
    }

    @Test
    public void testMethodOrder() throws Exception {
        this.assertMethodOrder(Service1.class, (List<Method>)ImmutableList.of());
        this.assertMethodOrder(Service2.class, (List<Method>)ImmutableList.of((Object)Service2.class.getMethod("method1", String.class)));
        this.assertMethodOrder(Service3.class, (List<Method>)ImmutableList.of((Object)Service3.class.getMethod("method1", String.class), (Object)Service3.class.getMethod("method2", String.class)));
        this.assertMethodOrder(Service4.class, (List<Method>)ImmutableList.of((Object)Service4.class.getMethod("method1", String.class), (Object)Service4.class.getMethod("method2", String.class)));
        this.assertMethodOrder(Service5.class, (List<Method>)ImmutableList.of((Object)Service5.class.getMethod("method3", String.class), (Object)Service5.class.getMethod("method1", String.class), (Object)Service5.class.getMethod("method2", String.class)));
        this.assertMethodOrder(Service6.class, (List<Method>)ImmutableList.of((Object)Service6.class.getMethod("method3", String.class), (Object)Service6.class.getMethod("method5", String.class), (Object)Service6.class.getMethod("method1", String.class), (Object)Service6.class.getMethod("method2", String.class), (Object)Service6.class.getMethod("method4", String.class)));
        this.assertMethodOrder(Service7.class, (List<Method>)ImmutableList.of((Object)Service7.class.getMethod("method5", String.class), (Object)Service7.class.getMethod("method3", String.class), (Object)Service7.class.getMethod("method1", String.class), (Object)Service7.class.getMethod("method2", String.class), (Object)Service7.class.getMethod("method4", String.class)));
        this.assertMethodOrder(Service8.class, (List<Method>)ImmutableList.of((Object)Service8.class.getMethod("method", String.class), (Object)Service8.class.getMethod("method", String.class, String.class)));
        this.assertMethodOrder(Service9.class, (List<Method>)ImmutableList.of((Object)Service9.class.getMethod("method", String.class, String.class, String.class), (Object)Service9.class.getMethod("method", String.class), (Object)Service9.class.getMethod("method", String.class, String.class)));
    }

    private void assertMethodOrder(Class<?> clazz, List<Method> expected) {
        ThriftServiceMetadata metadata = new ThriftServiceMetadata(clazz, this.catalog);
        List actual = (List)metadata.getMethods().stream().map(ThriftMethodMetadata::getMethod).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @ThriftService
    public static interface Service9 {
        @ThriftMethod
        public String method(String var1);

        @ThriftMethod
        public String method(String var1, String var2);

        @ThriftOrder(value=0)
        @ThriftMethod
        public String method(String var1, String var2, String var3);
    }

    @ThriftService
    public static interface Service8 {
        @ThriftMethod
        public String method(String var1);

        @ThriftMethod
        public String method(String var1, String var2);
    }

    @ThriftService
    public static interface Service7 {
        @ThriftMethod(value="method1")
        public String method1(String var1);

        @ThriftMethod(value="method2")
        public String method2(String var1);

        @ThriftOrder(value=1)
        @ThriftMethod(value="method3")
        public String method3(String var1);

        @ThriftMethod(value="method4")
        public String method4(String var1);

        @ThriftOrder(value=0)
        @ThriftMethod(value="method5")
        public String method5(String var1);
    }

    @ThriftService
    public static interface Service6 {
        @ThriftMethod(value="method1")
        public String method1(String var1);

        @ThriftMethod(value="method2")
        public String method2(String var1);

        @ThriftOrder(value=0)
        @ThriftMethod(value="method3")
        public String method3(String var1);

        @ThriftMethod(value="method4")
        public String method4(String var1);

        @ThriftOrder(value=0)
        @ThriftMethod(value="method5")
        public String method5(String var1);
    }

    @ThriftService
    public static interface Service5 {
        @ThriftMethod(value="method1")
        public String method1(String var1);

        @ThriftMethod(value="method2")
        public String method2(String var1);

        @ThriftOrder(value=0)
        @ThriftMethod(value="method3")
        public String method3(String var1);
    }

    @ThriftService
    public static interface Service4 {
        @ThriftMethod(value="method")
        public String method1(String var1);

        @ThriftMethod(value="method")
        public String method2(String var1);
    }

    @ThriftService
    public static interface Service3 {
        @ThriftMethod
        public String method1(String var1);

        @ThriftMethod
        public String method2(String var1);
    }

    @ThriftService
    public static interface Service2 {
        @ThriftMethod
        public String method1(String var1);
    }

    @ThriftService
    public static interface Service1 {
    }
}

