/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.codec.BonkBean;
import com.facebook.drift.codec.BonkBuilder;
import com.facebook.drift.codec.BonkConstructor;
import com.facebook.drift.codec.BonkField;
import com.facebook.drift.codec.BonkMethod;
import com.facebook.drift.codec.idlannotations.BeanWIthConflictingIdlAnnotationMapsForField;
import com.facebook.drift.codec.idlannotations.BeanWithMatchingIdlAnnotationsMapsForField;
import com.facebook.drift.codec.idlannotations.BeanWithOneIdlAnnotationMapForField;
import com.facebook.drift.codec.idlannotations.ExceptionWithIdlAnnotations;
import com.facebook.drift.codec.idlannotations.StructWithIdlAnnotations;
import com.facebook.drift.codec.idlannotations.UnionWithIdlAnnotations;
import com.facebook.drift.codec.metadata.AbstractThriftMetadataBuilder;
import com.facebook.drift.codec.metadata.MetadataErrorException;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftConstructorInjection;
import com.facebook.drift.codec.metadata.ThriftExtraction;
import com.facebook.drift.codec.metadata.ThriftFieldExtractor;
import com.facebook.drift.codec.metadata.ThriftFieldInjection;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftInjection;
import com.facebook.drift.codec.metadata.ThriftMethodExtractor;
import com.facebook.drift.codec.metadata.ThriftParameterInjection;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadataBuilder;
import com.facebook.drift.codec.metadata.ThriftUnionMetadataBuilder;
import java.lang.reflect.Type;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftStructMetadata {
    @Test
    public void testField() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(BonkField.class, 0, 0);
        this.verifyFieldInjection(metadata, 1, "message");
        this.verifyFieldExtraction(metadata, 1, "message");
        this.verifyFieldInjection(metadata, 2, "type");
        this.verifyFieldExtraction(metadata, 2, "type");
    }

    private void verifyFieldInjection(ThriftStructMetadata metadata, int id, String name) {
        ThriftInjection injection = (ThriftInjection)metadata.getField(id).getInjections().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)injection).isNotNull()).isInstanceOf(ThriftFieldInjection.class);
        ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
        Assert.assertEquals((String)fieldInjection.getField().getName(), (String)name);
    }

    private void verifyFieldExtraction(ThriftStructMetadata metadata, int id, String name) {
        Assert.assertTrue((boolean)metadata.getField(id).getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)metadata.getField(id).getExtraction().get();
        Assertions.assertThat((Object)extraction).isInstanceOf(ThriftFieldExtractor.class);
        ThriftFieldExtractor fieldExtractor = (ThriftFieldExtractor)extraction;
        Assert.assertEquals((String)fieldExtractor.getField().getName(), (String)name);
    }

    @Test
    public void testBean() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(BonkBean.class, 0, 2);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 0);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    private void verifyParameterInjection(ThriftStructMetadata metadata, int id, String name, int parameterIndex) {
        ThriftInjection injection = (ThriftInjection)metadata.getField(id).getInjections().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)injection).isNotNull()).isInstanceOf(ThriftParameterInjection.class);
        ThriftParameterInjection parameterInjection = (ThriftParameterInjection)injection;
        Assert.assertEquals((int)parameterInjection.getId(), (int)id);
        Assert.assertEquals((String)parameterInjection.getName(), (String)name);
        Assert.assertEquals((int)parameterInjection.getParameterIndex(), (int)parameterIndex);
    }

    private void verifyMethodExtraction(ThriftStructMetadata metadata, int id, String name, String methodName) {
        Assert.assertTrue((boolean)metadata.getField(id).getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)metadata.getField(id).getExtraction().get();
        Assertions.assertThat((Object)extraction).isInstanceOf(ThriftMethodExtractor.class);
        ThriftMethodExtractor methodExtractor = (ThriftMethodExtractor)extraction;
        Assert.assertEquals((String)methodExtractor.getMethod().getName(), (String)methodName);
        Assert.assertEquals((String)methodExtractor.getName(), (String)name);
    }

    @Test
    public void testConstructor() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(BonkConstructor.class, 2, 0);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 1);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    @Test
    public void testMethod() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(BonkMethod.class, 0, 1);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 1);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    @Test
    public void testBuilder() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(BonkBuilder.class, 0, 2);
        this.verifyParameterInjection(metadata, 1, "message", 0);
        this.verifyMethodExtraction(metadata, 1, "message", "getMessage");
        this.verifyParameterInjection(metadata, 2, "type", 0);
        this.verifyMethodExtraction(metadata, 2, "type", "getType");
    }

    @Test
    public void testFieldWithOneIdlAnnotationMap() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(BeanWithOneIdlAnnotationMapForField.class, 0, 1);
        Map idlAnnotations = metadata.getField(2).getIdlAnnotations();
        Assert.assertEquals((int)idlAnnotations.size(), (int)2);
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey1")), (String)"testvalue1");
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey2")), (String)"testvalue2");
    }

    @Test
    public void testFieldWithMatchingIdlAnnotationMaps() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(BeanWithMatchingIdlAnnotationsMapsForField.class, 0, 1);
        Map idlAnnotations = metadata.getField(2).getIdlAnnotations();
        Assert.assertEquals((int)idlAnnotations.size(), (int)2);
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey1")), (String)"testvalue1");
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey2")), (String)"testvalue2");
    }

    @Test(expectedExceptions={MetadataErrorException.class})
    public void testFieldWithConflictingIdlAnnotationMap() throws Exception {
        this.testStructMetadataBuild(BeanWIthConflictingIdlAnnotationMapsForField.class, 0, 1);
    }

    @Test
    public void testStructWithIdlAnnotationsMap() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(StructWithIdlAnnotations.class, 0, 0);
        Map idlAnnotations = metadata.getIdlAnnotations();
        Assert.assertEquals((int)idlAnnotations.size(), (int)2);
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey1")), (String)"testvalue1");
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey2")), (String)"testvalue2");
    }

    @Test
    public void testUnionWithIdlAnnotationsMap() throws Exception {
        ThriftStructMetadata metadata = this.testUnionMetadataBuild(UnionWithIdlAnnotations.class, 0, 2);
        Map idlAnnotations = metadata.getIdlAnnotations();
        Assert.assertEquals((int)idlAnnotations.size(), (int)2);
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey1")), (String)"testvalue1");
        Assert.assertEquals((String)((String)idlAnnotations.get("testkey2")), (String)"testvalue2");
    }

    @Test
    public void testExceptionWithIdlAnnotationsMap() throws Exception {
        ThriftStructMetadata metadata = this.testStructMetadataBuild(ExceptionWithIdlAnnotations.class, 2, 0);
        Map idlAnnotations = metadata.getIdlAnnotations();
        Assert.assertEquals((int)idlAnnotations.size(), (int)1);
        Assert.assertEquals((String)((String)idlAnnotations.get("message")), (String)"message");
    }

    private ThriftStructMetadata testStructMetadataBuild(Class<?> structClass, int expectedConstructorParameters, int expectedMethodInjections) throws Exception {
        return this.testMetadataBuild(ThriftStructMetadataBuilder.class, structClass, expectedConstructorParameters, expectedMethodInjections);
    }

    private ThriftStructMetadata testUnionMetadataBuild(Class<?> structClass, int expectedConstructorParameters, int expectedMethodInjections) throws Exception {
        return this.testMetadataBuild(ThriftUnionMetadataBuilder.class, structClass, expectedConstructorParameters, expectedMethodInjections);
    }

    private <T extends AbstractThriftMetadataBuilder> ThriftStructMetadata testMetadataBuild(Class<T> metadataBuilderType, Class<?> structClass, int expectedConstructorParameters, int expectedMethodInjections) throws Exception {
        ThriftStructMetadata metadata = this.buildMetadata(structClass, metadataBuilderType);
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((ThriftStructMetadata.MetadataType.UNION == metadata.getMetadataType() || ThriftStructMetadata.MetadataType.STRUCT == metadata.getMetadataType() ? 1 : 0) != 0);
        this.verifyField(metadata, 1, "message");
        this.verifyField(metadata, 2, "type");
        ThriftConstructorInjection constructorInjection = (ThriftConstructorInjection)metadata.getConstructorInjection().get();
        Assert.assertNotNull((Object)constructorInjection);
        Assert.assertEquals((int)constructorInjection.getParameters().size(), (int)expectedConstructorParameters);
        Assert.assertEquals((int)metadata.getMethodInjections().size(), (int)expectedMethodInjections);
        return metadata;
    }

    private <T extends AbstractThriftMetadataBuilder> ThriftStructMetadata buildMetadata(Class<?> structClass, Class<T> metadataBuilderType) throws Exception {
        ThriftCatalog catalog = new ThriftCatalog();
        AbstractThriftMetadataBuilder builder = (AbstractThriftMetadataBuilder)metadataBuilderType.getConstructor(ThriftCatalog.class, Type.class).newInstance(catalog, structClass);
        Assert.assertNotNull((Object)builder);
        Assert.assertNotNull((Object)builder.getMetadataErrors());
        builder.getMetadataErrors().throwIfHasErrors();
        Assert.assertEquals((int)builder.getMetadataErrors().getWarnings().size(), (int)0);
        return builder.build();
    }

    private void verifyField(ThriftStructMetadata metadata, int id, String name) {
        ThriftFieldMetadata messageField = metadata.getField(id);
        Assert.assertNotNull((Object)messageField, (String)("field '" + name + "' is null"));
        Assert.assertEquals((int)messageField.getId(), (int)id);
        Assert.assertEquals((String)messageField.getName(), (String)name);
        Assert.assertFalse((boolean)messageField.isReadOnly());
        Assert.assertFalse((boolean)messageField.isWriteOnly());
        Assert.assertTrue((boolean)messageField.getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)messageField.getExtraction().get();
        Assert.assertEquals((int)extraction.getId(), (int)id);
        Assert.assertEquals((String)extraction.getName(), (String)name);
        Assert.assertNotNull((Object)messageField.getInjections());
        Assert.assertEquals((int)messageField.getInjections().size(), (int)1);
        ThriftInjection injection = (ThriftInjection)messageField.getInjections().get(0);
        Assert.assertEquals((int)injection.getId(), (int)id);
        Assert.assertEquals((String)injection.getName(), (String)name);
    }
}

