/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftUnion;
import com.facebook.drift.annotations.ThriftUnionId;
import com.facebook.drift.codec.metadata.MetadataErrorException;
import com.facebook.drift.codec.metadata.MetadataErrors;
import com.facebook.drift.codec.metadata.MetadataWarningException;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftUnionMetadataBuilder;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestThriftUnionMetadataBuilder {
    @Test
    public void testNoId() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), NoId.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"not have an id");
    }

    @Test
    public void testMultipleIds() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), MultipleIds.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"multiple ids");
    }

    @Test
    public void testMultipleNames() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), MultipleNames.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).isEmpty();
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).hasSize(1);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataWarningException)metadataErrors.getWarnings().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"multiple names");
    }

    @Test
    public void testUnsupportedType() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), UnsupportedJavaType.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"not a supported Java type");
    }

    @Test
    public void testMultipleTypes() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), MultipleTypes.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)((Object)metadataErrors.getErrors().get(0))).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"multiple types");
    }

    @Test
    public void testNonFinalUnionOk() {
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(new ThriftCatalog(), NotFinalUnion.class);
        builder.build();
    }

    @ThriftUnion
    public static class NotFinalUnion {
        @ThriftUnionId
        public short id;
    }

    @ThriftUnion
    public static final class MultipleTypes {
        @ThriftUnionId
        public void setId(short id) {
        }

        @ThriftField(value=1)
        public int getFoo() {
            return 0;
        }

        @ThriftField
        public void setFoo(short value) {
        }
    }

    @ThriftUnion
    public static final class UnsupportedJavaType {
        @ThriftField(value=1)
        public Lock unsupportedJavaType;

        @ThriftUnionId
        public void setId(short id) {
        }
    }

    @ThriftUnion
    public static final class MultipleNames {
        @ThriftUnionId
        public void setId(short id) {
        }

        @ThriftField(value=1, name="foo")
        public String getFoo() {
            return null;
        }

        @ThriftField(value=1, name="bar")
        public void setFoo(String value) {
        }
    }

    @ThriftUnion
    public static final class MultipleIds {
        @ThriftUnionId
        public void setId(short id) {
        }

        @ThriftField(name="foo", value=1)
        public void setField1(String value) {
        }

        @ThriftField(name="foo", value=2)
        public void setField2(String value) {
        }

        @ThriftField(name="foo")
        public String getField1() {
            return null;
        }

        @ThriftField(name="foo")
        public String getField2() {
            return null;
        }
    }

    @ThriftUnion
    public static final class NoId {
        @ThriftUnionId
        public short id;

        @ThriftField
        public String getField1() {
            return null;
        }

        @ThriftField
        public void setField1(String value) {
        }
    }
}

