/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.codec.ArrayField;
import com.facebook.drift.codec.ArrayFieldThriftCodec;
import com.facebook.drift.codec.BonkBean;
import com.facebook.drift.codec.BonkBuilder;
import com.facebook.drift.codec.BonkConstructor;
import com.facebook.drift.codec.BonkConstructorNameOverride;
import com.facebook.drift.codec.BonkField;
import com.facebook.drift.codec.BonkFieldThriftCodec;
import com.facebook.drift.codec.BonkMethod;
import com.facebook.drift.codec.CoercionBean;
import com.facebook.drift.codec.Fruit;
import com.facebook.drift.codec.IsSetBean;
import com.facebook.drift.codec.Letter;
import com.facebook.drift.codec.OneOfEverything;
import com.facebook.drift.codec.OneOfEverythingThriftCodec;
import com.facebook.drift.codec.OptionalField;
import com.facebook.drift.codec.OptionalStruct;
import com.facebook.drift.codec.RecursiveOptionalStruct;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.UnionBean;
import com.facebook.drift.codec.UnionConstructor;
import com.facebook.drift.codec.UnionConstructorDuplicateTypes;
import com.facebook.drift.codec.UnionField;
import com.facebook.drift.codec.UnionFieldThriftCodec;
import com.facebook.drift.codec.UriField;
import com.facebook.drift.codec.generics.ConcreteDerivedFromGeneric;
import com.facebook.drift.codec.generics.ConcreteDerivedFromGenericBean;
import com.facebook.drift.codec.generics.ConcreteThriftStructDerivedFromGenericField;
import com.facebook.drift.codec.generics.GenericThriftStruct;
import com.facebook.drift.codec.generics.GenericThriftStructBean;
import com.facebook.drift.codec.generics.GenericThriftStructField;
import com.facebook.drift.codec.generics.GenericThriftStructFromBuilder;
import com.facebook.drift.codec.internal.EnumThriftCodec;
import com.facebook.drift.codec.internal.coercion.DefaultJavaCoercions;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.codec.recursion.CoRecursive;
import com.facebook.drift.codec.recursion.CoRecursiveHelper;
import com.facebook.drift.codec.recursion.CoRecursiveTree;
import com.facebook.drift.codec.recursion.CoRecursiveTreeHelper;
import com.facebook.drift.codec.recursion.RecursiveDefaultUnion;
import com.facebook.drift.codec.recursion.RecursiveUnion;
import com.facebook.drift.codec.recursion.ViaListElementType;
import com.facebook.drift.codec.recursion.ViaMapKeyAndValueTypes;
import com.facebook.drift.codec.recursion.ViaNestedListElementType;
import com.facebook.drift.codec.recursion.WithDriftRecursiveAnnotation;
import com.facebook.drift.codec.recursion.WithIdlRecursiveAnnotation;
import com.facebook.drift.codec.recursion.WithoutRecursiveAnnotation;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class AbstractThriftCodecManagerTest {
    private ThriftCodecManager readCodecManager;
    private ThriftCodecManager writeCodecManager;

    protected abstract ThriftCodecManager createReadCodecManager();

    protected abstract ThriftCodecManager createWriteCodecManager();

    @BeforeMethod
    protected void setUp() {
        this.readCodecManager = this.createReadCodecManager();
        this.writeCodecManager = this.createWriteCodecManager();
        this.readCodecManager.getCatalog().addDefaultCoercions(DefaultJavaCoercions.class);
        this.writeCodecManager.getCatalog().addDefaultCoercions(DefaultJavaCoercions.class);
    }

    @Test
    public void testUnionFieldsManual() throws Exception {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftType unionFieldType = catalog.getThriftType(UnionField.class);
        ThriftType fruitType = catalog.getThriftType(Fruit.class);
        EnumThriftCodec fruitCodec = new EnumThriftCodec(fruitType);
        UnionFieldThriftCodec unionFieldCodec = new UnionFieldThriftCodec(unionFieldType, (ThriftCodec<Fruit>)fruitCodec);
        UnionField unionField = new UnionField();
        unionField.id = 1;
        unionField.stringValue = "Hello, World";
        this.testRoundTripSerialize(unionFieldCodec, unionFieldCodec, unionField);
        unionField = new UnionField();
        unionField.id = (short)2;
        unionField.longValue = 4815162342L;
        this.testRoundTripSerialize(unionFieldCodec, unionFieldCodec, unionField);
        unionField = new UnionField();
        unionField.id = (short)3;
        unionField.fruitValue = Fruit.APPLE;
        this.testRoundTripSerialize(unionFieldCodec, unionFieldCodec, unionField);
    }

    @Test
    public void testUnionFields() throws Exception {
        UnionField unionField = new UnionField();
        unionField.id = 1;
        unionField.stringValue = "Hello, World";
        this.testRoundTripSerialize(unionField);
        unionField = new UnionField();
        unionField.id = (short)2;
        unionField.longValue = 4815162342L;
        this.testRoundTripSerialize(unionField);
        unionField = new UnionField();
        unionField.id = (short)3;
        unionField.fruitValue = Fruit.APPLE;
        this.testRoundTripSerialize(unionField);
    }

    @Test
    public void testUnionBean() throws Exception {
        UnionBean unionBean = new UnionBean();
        unionBean.setStringValue("Hello, World");
        this.testRoundTripSerialize(unionBean);
        unionBean = new UnionBean();
        unionBean.setLongValue(4815162342L);
        this.testRoundTripSerialize(unionBean);
        unionBean = new UnionBean();
        unionBean.setFruitValue(Fruit.CHERRY);
        this.testRoundTripSerialize(unionBean);
    }

    @Test
    public void testUnionConstructor() throws Exception {
        UnionConstructor unionConstructor = new UnionConstructor("Hello, World");
        this.testRoundTripSerialize(unionConstructor);
        unionConstructor = new UnionConstructor(4815162342L);
        this.testRoundTripSerialize(unionConstructor);
        unionConstructor = new UnionConstructor(Fruit.APPLE);
        this.testRoundTripSerialize(unionConstructor);
        unionConstructor = new UnionConstructor();
        this.testRoundTripSerialize(unionConstructor);
    }

    @Test
    public void testUnionConstructorDuplicateTypes() throws Exception {
        UnionConstructorDuplicateTypes unionConstructor = new UnionConstructorDuplicateTypes();
        unionConstructor.setFirstIntValue(1);
        this.testRoundTripSerialize(unionConstructor);
        unionConstructor = new UnionConstructorDuplicateTypes();
        unionConstructor.setSecondIntValue(2);
        this.testRoundTripSerialize(unionConstructor);
    }

    @Test
    public void testStructFieldsManual() throws Exception {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftType bonkFieldType = catalog.getThriftType(BonkField.class);
        BonkFieldThriftCodec bonkFieldCodec = new BonkFieldThriftCodec(bonkFieldType);
        BonkField bonkField = new BonkField("message", 42);
        this.testRoundTripSerialize(bonkFieldCodec, bonkFieldCodec, bonkField);
    }

    @Test
    public void testStructFields() throws Exception {
        BonkField bonkField = new BonkField("message", 42);
        this.testRoundTripSerialize(bonkField);
    }

    @Test
    public void testStructBean() throws Exception {
        BonkBean bonkBean = new BonkBean("message", 42);
        this.testRoundTripSerialize(bonkBean);
    }

    @Test
    public void testStructMethod() throws Exception {
        BonkMethod bonkMethod = new BonkMethod("message", 42);
        this.testRoundTripSerialize(bonkMethod);
    }

    @Test
    public void testStructConstructor() throws Exception {
        BonkConstructor bonkConstructor = new BonkConstructor("message", 42);
        this.testRoundTripSerialize(bonkConstructor);
    }

    @Test
    public void testMatchByJavaNameWithThriftNameOverride() throws Exception {
        ThriftCatalog catalog = this.readCodecManager.getCatalog();
        ThriftType thriftType = catalog.getThriftType(BonkConstructorNameOverride.class);
        ThriftStructMetadata structMetadata = thriftType.getStructMetadata();
        Assert.assertEquals((String)structMetadata.getField(1).getName(), (String)"myMessage");
        Assert.assertEquals((String)structMetadata.getField(2).getName(), (String)"myType");
        BonkConstructorNameOverride bonk = new BonkConstructorNameOverride("message", 42);
        this.testRoundTripSerialize(bonk);
    }

    @Test
    public void testBuilder() throws Exception {
        BonkBuilder bonkBuilder = new BonkBuilder("message", 42);
        this.testRoundTripSerialize(bonkBuilder);
    }

    @Test
    public void testArraysManual() throws Exception {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftType thriftType = catalog.getThriftType(ArrayField.class);
        ArrayFieldThriftCodec arrayFieldCodec = new ArrayFieldThriftCodec(thriftType);
        ArrayField arrayField = new ArrayField(new boolean[]{true, false, false, true}, new short[]{0, 1, 2, 3}, new int[]{10, 11, 12, 13}, new long[]{20L, Long.MAX_VALUE, Long.MIN_VALUE}, new double[]{3.0, Double.MAX_VALUE, Double.MIN_VALUE}, "hello".getBytes(StandardCharsets.UTF_8));
        this.testRoundTripSerialize(arrayFieldCodec, arrayFieldCodec, arrayField);
    }

    @Test
    public void testArrays() throws Exception {
        ArrayField arrayField = new ArrayField(new boolean[]{true, false, false, true}, new short[]{0, 1, 2, 3}, new int[]{10, 11, 12, 13}, new long[]{20L, Long.MAX_VALUE, Long.MIN_VALUE}, new double[]{3.0, Double.MAX_VALUE, Double.MIN_VALUE}, "hello".getBytes(StandardCharsets.UTF_8), (Map<Short, boolean[]>)ImmutableMap.of((Object)1, (Object)new boolean[]{false, false}, (Object)2, (Object)new boolean[]{true, true}), (Map<Short, short[]>)ImmutableMap.of((Object)1, (Object)new short[]{10, 11, 12, 13}, (Object)2, (Object)new short[]{15, 16, 17, 18}), (Map<Short, int[]>)ImmutableMap.of((Object)1, (Object)new int[]{20, 21, 22, 23}, (Object)2, (Object)new int[]{25, 26, 27, 28}), (Map<Short, long[]>)ImmutableMap.of((Object)1, (Object)new long[]{30L, 31L, 32L, 33L}, (Object)2, (Object)new long[]{35L, 36L, 37L, 38L}), (Map<Short, double[]>)ImmutableMap.of((Object)1, (Object)new double[]{40.0, 41.0, 42.0, 43.0}, (Object)2, (Object)new double[]{45.0, 46.0, 47.0, 48.0}));
        this.testRoundTripSerialize(arrayField, TCompactProtocol::new);
    }

    @Test
    public void testUri() throws Exception {
        UriField uriField = new UriField(URI.create("http://fake.uri"));
        this.testRoundTripSerialize(uriField);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testUriInvalid() throws Exception {
        UriField uriField = new UriField(URI.create(">fake"));
        this.testRoundTripSerialize(uriField);
    }

    @Test
    public void testUriFile() throws Exception {
        UriField uriField = new UriField(URI.create("file://host/path"));
        this.testRoundTripSerialize(uriField);
    }

    @Test
    public void testUriMailTo() throws Exception {
        UriField uriField = new UriField(URI.create("mailto:someone@example.com"));
        this.testRoundTripSerialize(uriField);
    }

    @Test
    public void testAllOptionalField() throws Exception {
        OptionalField optionalField = new OptionalField();
        optionalField.aBooleanOptional = Optional.of(true);
        optionalField.aByteOptional = Optional.of((byte)-128);
        optionalField.aShortOptional = Optional.of((short)Short.MIN_VALUE);
        optionalField.aIntegerOptional = Optional.of(Integer.MIN_VALUE);
        optionalField.aLongOptional = Optional.of(Long.MIN_VALUE);
        optionalField.aDoubleOptional = Optional.of(-42.1);
        optionalField.aStringOptional = Optional.of("a");
        optionalField.aStructOptional = Optional.of(new BonkField("message", 42));
        optionalField.aEnumOptional = Optional.of(Fruit.BANANA);
        optionalField.aOptionalDouble = OptionalDouble.of(87.6);
        optionalField.aOptionalInt = OptionalInt.of(0x7FFFFFF5);
        optionalField.aOptionalLong = OptionalLong.of(9223372036854775787L);
        optionalField.aCustomEnumOptional = Optional.of(Letter.C);
        optionalField.aListBooleanOptional = Optional.of(ImmutableList.of((Object)true));
        optionalField.aListByteOptional = Optional.of(ImmutableList.of((Object)127));
        optionalField.aListShortOptional = Optional.of(ImmutableList.of((Object)Short.MAX_VALUE));
        optionalField.aListIntegerOptional = Optional.of(ImmutableList.of((Object)Integer.MAX_VALUE));
        optionalField.aListLongOptional = Optional.of(ImmutableList.of((Object)Long.MAX_VALUE));
        optionalField.aListDoubleOptional = Optional.of(ImmutableList.of((Object)-42.1));
        optionalField.aListStringOptional = Optional.of(ImmutableList.of((Object)"a"));
        optionalField.aListStructOptional = Optional.of(ImmutableList.of((Object)new BonkField("message", 42)));
        optionalField.aListEnumOptional = Optional.of(ImmutableList.of((Object)((Object)Fruit.BANANA)));
        optionalField.aListCustomEnumOptional = Optional.of(ImmutableList.of((Object)((Object)Letter.C)));
        this.testRoundTripSerialize(optionalField);
    }

    @Test
    public void testAllOptionalFieldEmpty() throws Exception {
        this.testRoundTripSerialize(new OptionalField());
    }

    @Test
    public void testAllOptionalStruct() throws Exception {
        OptionalStruct optionalStruct = new OptionalStruct(Optional.of(true), Optional.of((byte)-128), Optional.of((short)Short.MIN_VALUE), Optional.of(Integer.MIN_VALUE), Optional.of(Long.MIN_VALUE), Optional.of(-42.1), Optional.of("a"), Optional.of(new BonkField("message", 42)), Optional.of(Fruit.BANANA), Optional.of(Letter.C), OptionalDouble.of(87.6), OptionalInt.of(0x7FFFFFF5), OptionalLong.of(9223372036854775787L), Optional.of(ImmutableList.of((Object)true)), Optional.of(ImmutableList.of((Object)127)), Optional.of(ImmutableList.of((Object)Short.MAX_VALUE)), Optional.of(ImmutableList.of((Object)Integer.MAX_VALUE)), Optional.of(ImmutableList.of((Object)Long.MAX_VALUE)), Optional.of(ImmutableList.of((Object)-42.1)), Optional.of(ImmutableList.of((Object)"a")), Optional.of(ImmutableList.of((Object)new BonkField("message", 42))), Optional.of(ImmutableList.of((Object)((Object)Fruit.BANANA))), Optional.of(ImmutableList.of((Object)((Object)Letter.C))));
        this.testRoundTripSerialize(optionalStruct);
    }

    @Test
    public void testAllOptionalStructEmpty() throws Exception {
        this.testRoundTripSerialize(new OptionalStruct());
    }

    @Test
    public void testOneOfEverythingField() throws Exception {
        this.testRoundTripSerialize(this.createOneOfEverything());
    }

    @Test
    public void testOneOfEverythingFieldManual() throws Exception {
        ThriftCatalog catalog = this.readCodecManager.getCatalog();
        ThriftType bonkFieldType = catalog.getThriftType(BonkField.class);
        ThriftType unionFieldType = catalog.getThriftType(UnionField.class);
        ThriftType fruitType = catalog.getThriftType(Fruit.class);
        EnumThriftCodec fruitCodec = new EnumThriftCodec(fruitType);
        BonkFieldThriftCodec bonkFieldCodec = new BonkFieldThriftCodec(bonkFieldType);
        UnionFieldThriftCodec unionFieldCodec = new UnionFieldThriftCodec(unionFieldType, (ThriftCodec<Fruit>)fruitCodec);
        ThriftType oneOfEverythingType = catalog.getThriftType(OneOfEverything.class);
        OneOfEverythingThriftCodec codec = new OneOfEverythingThriftCodec(oneOfEverythingType, bonkFieldCodec, unionFieldCodec, (ThriftCodec<Fruit>)fruitCodec);
        OneOfEverything one = new OneOfEverything();
        one.aBoolean = true;
        one.aByte = (byte)11;
        one.aShort = (short)22;
        one.aInt = 33;
        one.aLong = 44L;
        one.aDouble = 55.0;
        one.aString = "message";
        one.aEnum = Fruit.CHERRY;
        one.aStruct = new BonkField("struct", 66);
        this.testRoundTripSerialize(codec, codec, one);
    }

    @Test
    public void testOneOfEverythingFieldEmpty() throws Exception {
        this.testRoundTripSerialize(new OneOfEverything());
    }

    @Test
    public void testDefaultCoercion() throws Exception {
        CoercionBean coercion = new CoercionBean(true, (byte)1, (short)2, 3, 4L, Float.valueOf(5.5f), 6.6, 7.7f, (List<Float>)ImmutableList.of((Object)Float.valueOf(1.1f), (Object)Float.valueOf(2.2f), (Object)Float.valueOf(3.3f)));
        this.testRoundTripSerialize(coercion);
    }

    @Test
    public void testIsSetBean() throws Exception {
        IsSetBean full = IsSetBean.createFull();
        this.assertAllFieldsSet(full, false);
        full.field = ByteBuffer.wrap("full".getBytes(StandardCharsets.UTF_8));
        this.testRoundTripSerialize(full, (T result) -> this.assertAllFieldsSet((IsSetBean)result, true));
        IsSetBean empty = IsSetBean.createEmpty();
        this.assertAllFieldsSet(empty, false);
        this.testRoundTripSerialize(empty, (T result) -> this.assertAllFieldsSet((IsSetBean)result, false));
    }

    @Test
    public void testBeanGeneric() throws Exception {
        GenericThriftStructBean<String> bean = new GenericThriftStructBean<String>();
        bean.setGenericProperty("genericValue");
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructBean<String>>(){}, bean);
        GenericThriftStructBean<Long> beanForLong = new GenericThriftStructBean<Long>();
        beanForLong.setGenericProperty(123L);
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructBean<Long>>(){}, beanForLong);
        GenericThriftStructBean<ImmutableList> beanForList = new GenericThriftStructBean<ImmutableList>();
        beanForList.setGenericProperty(ImmutableList.of((Object)"abc", (Object)"xyz"));
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructBean<List<String>>>(){}, beanForList);
        GenericThriftStructBean<ImmutableMap> beanForMap = new GenericThriftStructBean<ImmutableMap>();
        beanForMap.setGenericProperty(ImmutableMap.of((Object)"test", (Object)ImmutableList.of((Object)"abc", (Object)"xyz")));
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructBean<Map<String, List<String>>>>(){}, beanForMap);
    }

    @Test
    public void testBeanDerivedFromGeneric() throws Exception {
        ConcreteDerivedFromGenericBean bean = new ConcreteDerivedFromGenericBean();
        bean.setGenericProperty("generic");
        bean.setConcreteField("concrete");
        this.testRoundTripSerialize(bean);
    }

    @Test
    public void testImmutableGeneric() throws Exception {
        GenericThriftStruct<Double> immutable = new GenericThriftStruct<Double>(Math.PI);
        this.testRoundTripSerialize(new TypeToken<GenericThriftStruct<Double>>(){}, immutable);
    }

    @Test
    public void testImmutableDerivedFromGeneric() throws Exception {
        ConcreteDerivedFromGeneric immutable = new ConcreteDerivedFromGeneric(Math.E, Math.PI);
        this.testRoundTripSerialize(immutable);
    }

    @Test
    public void testGenericFromBuilder() throws Exception {
        GenericThriftStructFromBuilder<Integer, Double> builderObject = new GenericThriftStructFromBuilder.Builder().setFirstGenericProperty(12345).setSecondGenericProperty(1.2345).build();
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructFromBuilder<Integer, Double>>(){}, builderObject);
    }

    @Test
    public void testFieldGeneric() throws Exception {
        GenericThriftStructField fieldObject = new GenericThriftStructField();
        fieldObject.genericField = 5757;
        this.testRoundTripSerialize(new TypeToken<GenericThriftStructField<Integer>>(){}, fieldObject);
    }

    @Test
    public void testFieldDerivedFromGeneric() throws Exception {
        ConcreteThriftStructDerivedFromGenericField fieldObject = new ConcreteThriftStructDerivedFromGenericField();
        fieldObject.genericField = "genericValue";
        fieldObject.concreteField = "concreteValue";
        this.testRoundTripSerialize(fieldObject);
    }

    @Test
    public void testRecursiveStructWithDriftAnnotation() throws Exception {
        WithDriftRecursiveAnnotation recursiveObject = new WithDriftRecursiveAnnotation();
        recursiveObject.data = "parent";
        recursiveObject.child = new WithDriftRecursiveAnnotation();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new WithDriftRecursiveAnnotation();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test
    public void testStructWithRecursiveOptionalStruct() throws Exception {
        RecursiveOptionalStruct struct = new RecursiveOptionalStruct(Optional.of(new RecursiveOptionalStruct.InnerOptionalStruct(Optional.empty())));
        this.testRoundTripSerialize(struct);
    }

    @Test
    public void testRecursiveStructWithIdlAnnotation() throws Exception {
        WithIdlRecursiveAnnotation recursiveObject = new WithIdlRecursiveAnnotation();
        recursiveObject.data = "parent";
        recursiveObject.child = new WithIdlRecursiveAnnotation();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new WithIdlRecursiveAnnotation();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRecursiveStructWithoutRecursiveAnnotation() throws Exception {
        WithoutRecursiveAnnotation recursiveObject = new WithoutRecursiveAnnotation();
        recursiveObject.data = "parent";
        recursiveObject.child = new WithoutRecursiveAnnotation();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new WithoutRecursiveAnnotation();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test
    public void testStructWithRecursionViaListElementTypes() throws Exception {
        ViaListElementType recursiveObject = new ViaListElementType();
        recursiveObject.data = "parent";
        recursiveObject.children = Lists.newArrayList((Object[])new ViaListElementType[]{new ViaListElementType()});
        recursiveObject.children.get((int)0).data = "child";
        recursiveObject.children.get((int)0).children = Lists.newArrayList((Object[])new ViaListElementType[]{new ViaListElementType()});
        recursiveObject.children.get((int)0).children.get((int)0).data = "grandchild";
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test
    public void testStructWithRecursionViaNestedListElementTypes() throws Exception {
        ViaNestedListElementType recursiveObject = new ViaNestedListElementType();
        recursiveObject.data = "parent";
        recursiveObject.children = ImmutableList.of(new ArrayList());
        ViaNestedListElementType child = new ViaNestedListElementType();
        child.data = "child";
        recursiveObject.children.get(0).add(child);
        child.children = ImmutableList.of(new ArrayList());
        ViaNestedListElementType grandChild = new ViaNestedListElementType();
        grandChild.data = "grandchild";
        child.children.get(0).add(grandChild);
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test
    void testStructWithRecursionViaMapKeyAndValueTypes() throws Exception {
        ViaMapKeyAndValueTypes recursiveObject = new ViaMapKeyAndValueTypes();
        recursiveObject.data = "parent";
        ViaMapKeyAndValueTypes keyChild = new ViaMapKeyAndValueTypes();
        keyChild.data = "keychild";
        ViaMapKeyAndValueTypes valueChild = new ViaMapKeyAndValueTypes();
        valueChild.data = "valuechild";
        recursiveObject.children = ImmutableMap.of((Object)keyChild, (Object)valueChild);
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test
    void testCoRecursive() throws Exception {
        CoRecursive recursiveObject = new CoRecursive();
        recursiveObject.data = "parent";
        recursiveObject.child = new CoRecursiveHelper();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new CoRecursive();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test
    void testCoRecursiveStartingAtHelper() throws Exception {
        CoRecursiveHelper recursiveObject = new CoRecursiveHelper();
        recursiveObject.data = "parent";
        recursiveObject.child = new CoRecursive();
        recursiveObject.child.data = "child";
        recursiveObject.child.child = new CoRecursiveHelper();
        recursiveObject.child.child.data = "grandchild";
        this.testRoundTripSerialize(recursiveObject);
    }

    @Test
    void testCoRecursiveTree() throws Exception {
        Object recursiveLeaf = new CoRecursiveTree();
        ((CoRecursiveTree)recursiveLeaf).data = "grandchild";
        Object recursiveNode = new CoRecursiveTreeHelper();
        ((CoRecursiveTreeHelper)recursiveNode).data = "child";
        ((CoRecursiveTreeHelper)recursiveNode).child = recursiveLeaf;
        Object recursiveRoot = new CoRecursiveTree();
        ((CoRecursiveTree)recursiveRoot).data = "root";
        ((CoRecursiveTree)recursiveRoot).children = Lists.newArrayList((Object[])new CoRecursiveTreeHelper[]{recursiveNode});
        this.testRoundTripSerialize(recursiveRoot);
        recursiveLeaf = new CoRecursiveTreeHelper();
        ((CoRecursiveTreeHelper)recursiveLeaf).data = "grandchild";
        recursiveNode = new CoRecursiveTree();
        ((CoRecursiveTree)recursiveNode).data = "child";
        ((CoRecursiveTree)recursiveNode).children = Lists.newArrayList((Object[])new CoRecursiveTreeHelper[]{recursiveLeaf});
        recursiveRoot = new CoRecursiveTreeHelper();
        ((CoRecursiveTreeHelper)recursiveRoot).data = "root";
        ((CoRecursiveTreeHelper)recursiveRoot).child = recursiveNode;
        this.testRoundTripSerialize(recursiveRoot);
    }

    @Test
    public void testRecursiveUnion() throws Exception {
        RecursiveUnion recursiveUnion = new RecursiveUnion(new RecursiveUnion("child"));
        this.testRoundTripSerialize(recursiveUnion);
    }

    @Test
    public void testRecursiveDefaultUnion() throws Exception {
        RecursiveDefaultUnion recursiveDefaultUnion = new RecursiveDefaultUnion(new RecursiveDefaultUnion("child"));
        this.testRoundTripSerialize(recursiveDefaultUnion);
    }

    private void assertAllFieldsSet(IsSetBean isSetBean, boolean expected) {
        Assert.assertEquals((boolean)isSetBean.isBooleanSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isByteSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isShortSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isIntegerSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isLongSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isDoubleSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isStringSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isStructSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isSetSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isListSet(), (boolean)expected);
        Assert.assertEquals((boolean)isSetBean.isMapSet(), (boolean)expected);
        Assert.assertEquals((!ByteBuffer.wrap("empty".getBytes(StandardCharsets.UTF_8)).equals(isSetBean.field) ? 1 : 0) != 0, (boolean)expected);
    }

    private <T> void testRoundTripSerialize(T value) throws Exception {
        this.testRoundTripSerialize(value, (T x) -> {});
    }

    private <T> void testRoundTripSerialize(T value, Consumer<T> consumer) throws Exception {
        consumer.accept(this.testRoundTripSerialize(value, TBinaryProtocol::new));
        consumer.accept(this.testRoundTripSerialize(value, TCompactProtocol::new));
        consumer.accept(this.testRoundTripSerialize(value, TFacebookCompactProtocol::new));
    }

    private <T> T testRoundTripSerialize(T value, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        ThriftCodec readCodec = this.readCodecManager.getCodec(value.getClass());
        ThriftCodec writeCodec = this.writeCodecManager.getCodec(value.getClass());
        return this.testRoundTripSerialize(readCodec, writeCodec, value, protocolFactory);
    }

    private <T> void testRoundTripSerialize(TypeToken<T> typeToken, T value) throws Exception {
        this.testRoundTripSerialize(typeToken, value, TBinaryProtocol::new);
        this.testRoundTripSerialize(typeToken, value, TCompactProtocol::new);
        this.testRoundTripSerialize(typeToken, value, TFacebookCompactProtocol::new);
    }

    private <T> void testRoundTripSerialize(TypeToken<T> typeToken, T value, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        ThriftCodec readCodec = this.readCodecManager.getCodec(typeToken.getType());
        ThriftCodec writeCodec = this.writeCodecManager.getCodec(typeToken.getType());
        this.testRoundTripSerialize(readCodec, writeCodec, typeToken.getType(), value, protocolFactory);
    }

    private <T> void testRoundTripSerialize(ThriftCodec<T> readCodec, ThriftCodec<T> writeCodec, T structInstance) throws Exception {
        this.testRoundTripSerialize(readCodec, writeCodec, structInstance, TBinaryProtocol::new);
        this.testRoundTripSerialize(readCodec, writeCodec, structInstance, TCompactProtocol::new);
        this.testRoundTripSerialize(readCodec, writeCodec, structInstance, TFacebookCompactProtocol::new);
    }

    private <T> T testRoundTripSerialize(ThriftCodec<T> readCodec, ThriftCodec<T> writeCodec, T structInstance, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        Class<?> structClass = structInstance.getClass();
        return this.testRoundTripSerialize(readCodec, writeCodec, structClass, structInstance, protocolFactory);
    }

    private <T> T testRoundTripSerialize(ThriftCodec<T> readCodec, ThriftCodec<T> writeCodec, Type structType, T structInstance, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        ThriftCatalog readCatalog = this.readCodecManager.getCatalog();
        ThriftStructMetadata readMetadata = readCatalog.getThriftStructMetadata(structType);
        Assert.assertNotNull((Object)readMetadata);
        ThriftCatalog writeCatalog = this.writeCodecManager.getCatalog();
        ThriftStructMetadata writeMetadata = writeCatalog.getThriftStructMetadata(structType);
        Assert.assertNotNull((Object)writeMetadata);
        TMemoryBuffer transport = new TMemoryBuffer(10240);
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write(structInstance, (TProtocolWriter)protocol);
        Object copy = readCodec.read((TProtocolReader)protocol);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)copy, structInstance);
        return (T)copy;
    }

    private OneOfEverything createOneOfEverything() {
        OneOfEverything one = new OneOfEverything();
        one.aBoolean = true;
        one.aByte = (byte)11;
        one.aShort = (short)22;
        one.aInt = 33;
        one.aLong = 44L;
        one.aDouble = 55.0;
        one.aString = "message";
        one.aStruct = new BonkField("struct", 66);
        one.aEnum = Fruit.CHERRY;
        one.aCustomEnum = Letter.C;
        one.aBooleanSet = ImmutableSet.of((Object)true, (Object)false);
        one.aByteSet = ImmutableSet.of((Object)-1, (Object)0, (Object)1);
        one.aShortSet = ImmutableSet.of((Object)-1, (Object)0, (Object)1);
        one.aIntegerSet = ImmutableSet.of((Object)-1, (Object)0, (Object)1);
        one.aLongSet = ImmutableSet.of((Object)-1L, (Object)0L, (Object)1L);
        one.aDoubleSet = ImmutableSet.of((Object)-42.1, (Object)0.0, (Object)42.1);
        one.aStringSet = ImmutableSet.of((Object)"a", (Object)"string", (Object)"set");
        one.aStructSet = ImmutableSet.of((Object)new BonkField("message", 42), (Object)new BonkField("other", 11));
        one.aEnumSet = ImmutableSet.copyOf((Object[])Fruit.values());
        one.aCustomEnumSet = ImmutableSet.copyOf((Object[])Letter.values());
        one.aBooleanList = ImmutableList.of((Object)true, (Object)false);
        one.aByteList = ImmutableList.of((Object)-1, (Object)0, (Object)1);
        one.aShortList = ImmutableList.of((Object)-1, (Object)0, (Object)1);
        one.aIntegerList = ImmutableList.of((Object)-1, (Object)0, (Object)1);
        one.aLongList = ImmutableList.of((Object)-1L, (Object)0L, (Object)1L);
        one.aDoubleList = ImmutableList.of((Object)-42.1, (Object)0.0, (Object)42.1);
        one.aStringList = ImmutableList.of((Object)"a", (Object)"string", (Object)"list");
        one.aStructList = ImmutableList.of((Object)new BonkField("message", 42), (Object)new BonkField("other", 11));
        one.aEnumList = ImmutableList.copyOf((Object[])Fruit.values());
        one.aCustomEnumList = ImmutableList.copyOf((Object[])Letter.values());
        one.aBooleanValueMap = ImmutableMap.of((Object)"TRUE", (Object)true, (Object)"FALSE", (Object)false);
        one.aByteValueMap = ImmutableMap.of((Object)"-1", (Object)-1, (Object)"0", (Object)0, (Object)"1", (Object)1);
        one.aShortValueMap = ImmutableMap.of((Object)"-1", (Object)-1, (Object)"0", (Object)0, (Object)"1", (Object)1);
        one.aIntegerValueMap = ImmutableMap.of((Object)"-1", (Object)-1, (Object)"0", (Object)0, (Object)"1", (Object)1);
        one.aLongValueMap = ImmutableMap.of((Object)"-1", (Object)-1L, (Object)"0", (Object)0L, (Object)"1", (Object)1L);
        one.aDoubleValueMap = ImmutableMap.of((Object)"neg", (Object)-42.1, (Object)"0", (Object)0.0, (Object)"pos", (Object)42.1);
        one.aStringValueMap = ImmutableMap.of((Object)"1", (Object)"a", (Object)"2", (Object)"string", (Object)"3", (Object)"map");
        one.aStructValueMap = ImmutableMap.of((Object)"main", (Object)new BonkField("message", 42), (Object)"other", (Object)new BonkField("other", 11));
        one.aEnumValueMap = ImmutableMap.of((Object)"apple", (Object)((Object)Fruit.APPLE), (Object)"banana", (Object)((Object)Fruit.BANANA));
        one.aCustomEnumValueMap = ImmutableMap.of((Object)"a", (Object)((Object)Letter.A), (Object)"b", (Object)((Object)Letter.B));
        one.aBooleanKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aBooleanValueMap).inverse());
        one.aByteKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aByteValueMap).inverse());
        one.aShortKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aShortValueMap).inverse());
        one.aIntegerKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aIntegerValueMap).inverse());
        one.aLongKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aLongValueMap).inverse());
        one.aDoubleKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aDoubleValueMap).inverse());
        one.aStringKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aStringValueMap).inverse());
        one.aStructKeyMap = ImmutableMap.copyOf((Map)HashBiMap.create(one.aStructValueMap).inverse());
        one.aEnumKeyMap = ImmutableMap.of((Object)((Object)Fruit.APPLE), (Object)"apple", (Object)((Object)Fruit.BANANA), (Object)"banana");
        one.aCustomEnumKeyMap = ImmutableMap.of((Object)((Object)Letter.A), (Object)"a", (Object)((Object)Letter.B), (Object)"b");
        one.aBooleanOptional = Optional.of(true);
        one.aByteOptional = Optional.of((byte)-1);
        one.aShortOptional = Optional.of((short)-1);
        one.aIntegerOptional = Optional.of(-1);
        one.aLongOptional = Optional.of(-1L);
        one.aDoubleOptional = Optional.of(-42.1);
        one.aStringOptional = Optional.of("a");
        one.aStructOptional = Optional.of(new BonkField("message", 42));
        one.aEnumOptional = Optional.of(Fruit.BANANA);
        one.aCustomEnumOptional = Optional.of(Letter.C);
        one.aOptionalDouble = OptionalDouble.of(87.6);
        one.aOptionalInt = OptionalInt.of(0x7FFFFFF5);
        one.aOptionalLong = OptionalLong.of(9223372036854775787L);
        one.aSetOfListsOfMaps = ImmutableSet.of((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"1: main", (Object)new BonkField("message", 42), (Object)"1: other", (Object)new BonkField("other", 11)), (Object)ImmutableMap.of((Object)"1: main", (Object)new BonkField("message", 42), (Object)"1: other", (Object)new BonkField("other", 11))), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"2: main", (Object)new BonkField("message", 42), (Object)"2: other", (Object)new BonkField("other", 11)), (Object)ImmutableMap.of((Object)"2: main", (Object)new BonkField("message", 42), (Object)"2: other", (Object)new BonkField("other", 11))));
        one.aMapOfListToSet = ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableSet.of((Object)new BonkField("1: message", 42), (Object)new BonkField("1: other", 11)), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableSet.of((Object)new BonkField("2: message", 42), (Object)new BonkField("2: other", 11)));
        one.aUnion = new UnionField("Hello, World");
        one.aUnionSet = ImmutableSet.of((Object)new UnionField("Hello, World"), (Object)new UnionField(123456L), (Object)new UnionField(Fruit.CHERRY));
        one.aUnionList = ImmutableList.of((Object)new UnionField("Hello, World"), (Object)new UnionField(123456L), (Object)new UnionField(Fruit.CHERRY));
        one.aUnionKeyMap = ImmutableMap.of((Object)new UnionField("Hello, World"), (Object)"Eins", (Object)new UnionField(123456L), (Object)"Zwei", (Object)new UnionField(Fruit.CHERRY), (Object)"Drei");
        one.aUnionValueMap = ImmutableMap.of((Object)"Eins", (Object)new UnionField("Hello, World"), (Object)"Zwei", (Object)new UnionField(123456L), (Object)"Drei", (Object)new UnionField(Fruit.CHERRY));
        return one;
    }
}

