/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.codec.ArrayField;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.nio.ByteBuffer;

public class ArrayFieldThriftCodec
implements ThriftCodec<ArrayField> {
    private final ThriftType type;

    public ArrayFieldThriftCodec(ThriftType type) {
        this.type = type;
    }

    public ThriftType getType() {
        return this.type;
    }

    public ArrayField read(TProtocolReader protocol) throws Exception {
        ProtocolReader reader = new ProtocolReader(protocol);
        boolean[] booleanArray = null;
        short[] shortArray = null;
        int[] intArray = null;
        long[] longArray = null;
        double[] doubleArray = null;
        byte[] byteArray = null;
        reader.readStructBegin();
        block8: while (reader.nextField()) {
            switch (reader.getFieldId()) {
                case 1: {
                    booleanArray = reader.readBoolArrayField();
                    continue block8;
                }
                case 2: {
                    shortArray = reader.readI16ArrayField();
                    continue block8;
                }
                case 3: {
                    intArray = reader.readI32ArrayField();
                    continue block8;
                }
                case 4: {
                    longArray = reader.readI64ArrayField();
                    continue block8;
                }
                case 5: {
                    doubleArray = reader.readDoubleArrayField();
                    continue block8;
                }
                case 6: {
                    byteArray = reader.readBinaryField().array();
                    continue block8;
                }
            }
            reader.skipFieldData();
        }
        reader.readStructEnd();
        ArrayField arrayField = new ArrayField();
        if (booleanArray != null) {
            arrayField.booleanArray = booleanArray;
        }
        if (shortArray != null) {
            arrayField.shortArray = shortArray;
        }
        if (intArray != null) {
            arrayField.intArray = intArray;
        }
        if (longArray != null) {
            arrayField.longArray = longArray;
        }
        if (doubleArray != null) {
            arrayField.doubleArray = doubleArray;
        }
        if (booleanArray != null) {
            arrayField.byteArray = byteArray;
        }
        return arrayField;
    }

    public void write(ArrayField value, TProtocolWriter protocol) throws Exception {
        byte[] byteArray;
        double[] doubleArray;
        long[] longArray;
        int[] intArray;
        short[] shortArray;
        ProtocolWriter writer = new ProtocolWriter(protocol);
        writer.writeStructBegin("array");
        boolean[] booleanArray = value.booleanArray;
        if (booleanArray != null) {
            writer.writeBoolArrayField("booleanArray", (short)1, booleanArray);
        }
        if ((shortArray = value.shortArray) != null) {
            writer.writeI16ArrayField("shortArray", (short)2, shortArray);
        }
        if ((intArray = value.intArray) != null) {
            writer.writeI32ArrayField("intArray", (short)3, intArray);
        }
        if ((longArray = value.longArray) != null) {
            writer.writeI64ArrayField("longArray", (short)4, longArray);
        }
        if ((doubleArray = value.doubleArray) != null) {
            writer.writeDoubleArrayField("doubleArray", (short)5, doubleArray);
        }
        if ((byteArray = value.byteArray) != null) {
            writer.writeBinaryField("byteArray", (short)6, ByteBuffer.wrap(byteArray));
        }
        writer.writeStructEnd();
    }
}

