/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.codec.BonkField;
import com.facebook.drift.codec.BonkFieldThriftCodec;
import com.facebook.drift.codec.Fruit;
import com.facebook.drift.codec.Letter;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.UnionField;
import com.facebook.drift.codec.UnionFieldThriftCodec;
import com.facebook.drift.codec.internal.EnumThriftCodec;
import com.facebook.drift.codec.internal.coercion.DefaultJavaCoercions;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftEnumMetadata;
import com.facebook.drift.codec.metadata.ThriftEnumMetadataBuilder;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestThriftCodecManager {
    public static final String UTF8_TEST_STRING = "A\u00ea\u00f1\u00fcC";
    private ThriftCodecManager codecManager;

    @BeforeMethod
    protected void setUp() {
        this.codecManager = new ThriftCodecManager((codecManager, metadata) -> {
            throw new UnsupportedOperationException();
        }, new ThriftCodec[0]);
        ThriftCatalog catalog = this.codecManager.getCatalog();
        catalog.addDefaultCoercions(DefaultJavaCoercions.class);
        ThriftType fruitType = catalog.getThriftType(Fruit.class);
        this.codecManager.addCodec((ThriftCodec)new EnumThriftCodec(fruitType));
    }

    @Test
    public void testBasicTypes() throws Exception {
        this.testRoundTripSerialize(true);
        this.testRoundTripSerialize(false);
        this.testRoundTripSerialize((byte)100);
        this.testRoundTripSerialize((short)1000);
        this.testRoundTripSerialize(10000);
        this.testRoundTripSerialize(10000000L);
        this.testRoundTripSerialize(42.42);
        this.testRoundTripSerialize("some string");
        this.testRoundTripSerialize(UTF8_TEST_STRING);
    }

    @Test
    public void testBasicThriftTypes() throws Exception {
        this.testRoundTripSerialize(ThriftType.BOOL, true);
        this.testRoundTripSerialize(ThriftType.BOOL, false);
        this.testRoundTripSerialize(ThriftType.BYTE, (byte)100);
        this.testRoundTripSerialize(ThriftType.I16, (short)1000);
        this.testRoundTripSerialize(ThriftType.I32, 10000);
        this.testRoundTripSerialize(ThriftType.I64, 10000000L);
        this.testRoundTripSerialize(ThriftType.DOUBLE, 42.42);
        this.testRoundTripSerialize(ThriftType.STRING, "some string");
        this.testRoundTripSerialize(ThriftType.STRING, UTF8_TEST_STRING);
    }

    @Test
    public void testEnum() throws Exception {
        ThriftEnumMetadata fruitEnumMetadata = ThriftEnumMetadataBuilder.thriftEnumMetadata(Fruit.class);
        ThriftEnumMetadata letterEnumMetadata = ThriftEnumMetadataBuilder.thriftEnumMetadata(Letter.class);
        this.testRoundTripSerialize(Fruit.CHERRY);
        this.testRoundTripSerialize(Letter.C);
        this.testRoundTripSerialize(ThriftType.enumType((ThriftEnumMetadata)fruitEnumMetadata), Fruit.CHERRY);
        this.testRoundTripSerialize(ThriftType.enumType((ThriftEnumMetadata)letterEnumMetadata), Letter.C);
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.enumType((ThriftEnumMetadata)fruitEnumMetadata)), ImmutableList.copyOf((Object[])Fruit.values()));
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.enumType((ThriftEnumMetadata)letterEnumMetadata)), ImmutableList.copyOf((Object[])Letter.values()));
        this.testRoundTripSerialize(ThriftType.I32, 500, ThriftType.enumType((ThriftEnumMetadata)letterEnumMetadata), Letter.UNKNOWN);
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.I32.coerceTo(Integer.class)), ImmutableList.of((Object)-100, (Object)-1, (Object)0, (Object)1, (Object)67, (Object)65, (Object)66, (Object)1000), ThriftType.list((ThriftType)ThriftType.enumType((ThriftEnumMetadata)letterEnumMetadata)), ImmutableList.of((Object)((Object)Letter.UNKNOWN), (Object)((Object)Letter.UNKNOWN), (Object)((Object)Letter.UNKNOWN), (Object)((Object)Letter.UNKNOWN), (Object)((Object)Letter.C), (Object)((Object)Letter.A), (Object)((Object)Letter.B), (Object)((Object)Letter.UNKNOWN)));
    }

    @Test
    public void testCollectionThriftTypes() throws Exception {
        this.testRoundTripSerialize(ThriftType.set((ThriftType)ThriftType.STRING), ImmutableSet.of((Object)"some string", (Object)"another string"));
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.STRING), ImmutableList.of((Object)"some string", (Object)"another string"));
        this.testRoundTripSerialize(ThriftType.map((ThriftType)ThriftType.STRING, (ThriftType)ThriftType.STRING), ImmutableMap.of((Object)"1", (Object)"one", (Object)"2", (Object)"two"));
    }

    @Test
    public void testCoercedCollection() throws Exception {
        this.testRoundTripSerialize(ThriftType.set((ThriftType)ThriftType.I32.coerceTo(Integer.class)), ImmutableSet.of((Object)1, (Object)2, (Object)3));
        this.testRoundTripSerialize(ThriftType.list((ThriftType)ThriftType.I32.coerceTo(Integer.class)), ImmutableList.of((Object)4, (Object)5, (Object)6));
        this.testRoundTripSerialize(ThriftType.map((ThriftType)ThriftType.I32.coerceTo(Integer.class), (ThriftType)ThriftType.I32.coerceTo(Integer.class)), ImmutableMap.of((Object)1, (Object)2, (Object)2, (Object)4, (Object)3, (Object)9));
    }

    @Test
    public void testAddStructCodec() throws Exception {
        BonkField bonk = new BonkField("message", 42);
        try {
            this.testRoundTripSerialize(bonk);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThriftType type = this.codecManager.getCatalog().getThriftType(BonkField.class);
        this.codecManager.addCodec((ThriftCodec)new BonkFieldThriftCodec(type));
        this.testRoundTripSerialize(bonk);
    }

    @Test
    public void testAddUnionCodec() throws Exception {
        UnionField union = new UnionField();
        union.id = 1;
        union.stringValue = "Hello, World";
        try {
            this.testRoundTripSerialize(union);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThriftType type = this.codecManager.getCatalog().getThriftType(UnionField.class);
        this.codecManager.addCodec((ThriftCodec)new UnionFieldThriftCodec(type, (ThriftCodec<Fruit>)this.codecManager.getCodec(Fruit.class)));
        this.testRoundTripSerialize(union);
        union = new UnionField();
        union.id = (short)2;
        union.longValue = 4815162342L;
        this.testRoundTripSerialize(union);
        union = new UnionField();
        union.id = (short)3;
        union.fruitValue = Fruit.BANANA;
        this.testRoundTripSerialize(union);
    }

    private <T> void testRoundTripSerialize(T value) throws Exception {
        ThriftType type = this.codecManager.getCatalog().getThriftType(value.getClass());
        this.testRoundTripSerialize(type, value);
    }

    private <T> void testRoundTripSerialize(ThriftType type, T value) throws Exception {
        this.testRoundTripSerialize(type, value, type, value);
    }

    private <T> void testRoundTripSerialize(ThriftType actualType, T actualValue, ThriftType expectedType, T expectedValue) throws Exception {
        this.testRoundTripSerialize(actualType, actualValue, expectedType, expectedValue, TBinaryProtocol::new);
        this.testRoundTripSerialize(actualType, actualValue, expectedType, expectedValue, TCompactProtocol::new);
        this.testRoundTripSerialize(actualType, actualValue, expectedType, expectedValue, TFacebookCompactProtocol::new);
    }

    private <T> void testRoundTripSerialize(ThriftType actualType, T actualValue, ThriftType expectedType, T expectedValue, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TMemoryBuffer transport = new TMemoryBuffer(10240);
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        this.codecManager.write(actualType, actualValue, (TProtocolWriter)protocol);
        Object copy = this.codecManager.read(expectedType, (TProtocolReader)protocol);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)copy, expectedValue);
    }
}

