/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftUnion;
import com.facebook.drift.annotations.ThriftUnionId;
import com.facebook.drift.codec.Fruit;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@ThriftUnion(value="Union", builder=Builder.class)
public final class UnionBuilder {
    private final Object value;
    @ThriftUnionId
    public final int type;

    UnionBuilder(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @ThriftField(value=1)
    public String getStringValue() {
        if (this.type != 1) {
            throw new IllegalStateException("not a stringValue");
        }
        return (String)this.value;
    }

    @ThriftField(value=2)
    public Long getLongValue() {
        if (this.type != 2) {
            throw new IllegalStateException("not a longValue");
        }
        return (Long)this.value;
    }

    @ThriftField(value=3)
    public Fruit getFruitValue() {
        if (this.type != 3) {
            throw new IllegalStateException("not a fruitValue");
        }
        return (Fruit)((Object)this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionBuilder that = (UnionBuilder)o;
        return this.type == that.type && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        if (this.type == 1) {
            helper.add("stringValue", this.value);
        } else if (this.type == 2) {
            helper.add("longValue", this.value);
        } else if (this.type == 3) {
            helper.add("fruitValue", this.value);
        }
        return helper.toString();
    }

    public static class Builder {
        private Object value;
        private int type;

        @ThriftField
        public void setStringValue(String stringValue) {
            this.value = stringValue;
            this.type = 1;
        }

        @ThriftField
        public void setLongValue(Long longValue) {
            this.value = longValue;
            this.type = 2;
        }

        @ThriftField
        public void setFruitValue(Fruit fruitValue) {
            this.value = fruitValue;
            this.type = 3;
        }

        @ThriftConstructor
        public UnionBuilder create() {
            return new UnionBuilder(this.value, this.type);
        }
    }
}

