/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.guice;

import com.facebook.drift.codec.BonkConstructor;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.guice.ThriftCodecBinder;
import com.facebook.drift.codec.guice.ThriftCodecModule;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftCodecModule {
    @Test
    public void testThriftClientAndServerModules() throws Exception {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThriftCodecModule(), binder -> {
            ThriftCodecBinder.thriftCodecBinder((Binder)binder).bindThriftCodec(BonkConstructor.class);
            ThriftCodecBinder.thriftCodecBinder((Binder)binder).bindListThriftCodec(BonkConstructor.class);
            ThriftCodecBinder.thriftCodecBinder((Binder)binder).bindMapThriftCodec(String.class, BonkConstructor.class);
            ThriftCodecBinder.thriftCodecBinder((Binder)binder).bindThriftCodec((TypeLiteral)new TypeLiteral<Map<Integer, List<String>>>(){});
            ThriftCodecBinder.thriftCodecBinder((Binder)binder).bindCustomThriftCodec((ThriftCodec)new ThriftCodec<ValueClass>(){

                public ThriftType getType() {
                    return new ThriftType(ThriftType.STRING, ValueClass.class);
                }

                public ValueClass read(TProtocolReader protocol) throws Exception {
                    return new ValueClass(protocol.readString());
                }

                public void write(ValueClass value, TProtocolWriter protocol) throws Exception {
                    protocol.writeString(value.getValue());
                }
            });
        }});
        TestThriftCodecModule.testRoundTripSerialize((ThriftCodec)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftCodec<BonkConstructor>>(){})), new BonkConstructor("message", 42));
        TestThriftCodecModule.testRoundTripSerialize((ThriftCodec)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftCodec<List<BonkConstructor>>>(){})), ImmutableList.of((Object)new BonkConstructor("one", 1), (Object)new BonkConstructor("two", 2)));
        TestThriftCodecModule.testRoundTripSerialize((ThriftCodec)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftCodec<Map<String, BonkConstructor>>>(){})), ImmutableMap.of((Object)"uno", (Object)new BonkConstructor("one", 1), (Object)"dos", (Object)new BonkConstructor("two", 2)));
        TestThriftCodecModule.testRoundTripSerialize((ThriftCodec)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftCodec<Map<Integer, List<String>>>>(){})), ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)"one", (Object)"uno"), (Object)2, (Object)ImmutableList.of((Object)"two", (Object)"dos")));
        TestThriftCodecModule.testRoundTripSerialize((ThriftCodec)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<ThriftCodec<ValueClass>>(){})), new ValueClass("my value"));
    }

    public static <T> void testRoundTripSerialize(ThriftCodec<T> codec, T value) throws Exception {
        TMemoryBuffer transport = new TMemoryBuffer(10240);
        TCompactProtocol protocol = new TCompactProtocol((TTransport)transport);
        codec.write(value, (TProtocolWriter)protocol);
        Object copy = codec.read((TProtocolReader)protocol);
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)copy, value);
    }

    public static class ValueClass {
        private final String value;

        public ValueClass(String value) {
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueClass that = (ValueClass)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }
}

