/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.facebook.drift.codec.Letter;
import com.facebook.drift.codec.metadata.ThriftEnumMetadata;
import com.facebook.drift.codec.metadata.ThriftEnumMetadataBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftEnumMetadata {
    @Test
    public void testValid() {
        ThriftEnumMetadata metadata = ThriftEnumMetadataBuilder.thriftEnumMetadata(Letter.class);
        Assert.assertEquals((Object)metadata.getEnumClass(), Letter.class);
        Assert.assertEquals((String)metadata.getEnumName(), (String)"Letter");
        Assert.assertEquals((Map)metadata.getByEnumConstant(), (Map)ImmutableMap.builder().put((Object)Letter.A, (Object)65).put((Object)Letter.B, (Object)66).put((Object)Letter.C, (Object)67).put((Object)Letter.D, (Object)68).put((Object)Letter.UNKNOWN, (Object)-1).build());
        Assert.assertEquals((Map)metadata.getByEnumValue(), (Map)ImmutableMap.builder().put((Object)65, (Object)Letter.A).put((Object)66, (Object)Letter.B).put((Object)67, (Object)Letter.C).put((Object)68, (Object)Letter.D).put((Object)-1, (Object)Letter.UNKNOWN).build());
        Assert.assertEquals((Object)metadata.getUnknownEnumConstant(), Optional.of(Letter.UNKNOWN));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Enum class .*MissingEnumAnnotation is not annotated with @ThriftEnum")
    public void testMissingEnumAnnotation() {
        ThriftEnumMetadataBuilder.thriftEnumMetadata(MissingEnumAnnotation.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Enum class .*MissingValueMethod must have a method annotated with @ThriftEnumValue")
    public void testMissingValueMethod() {
        ThriftEnumMetadataBuilder.thriftEnumMetadata(MissingValueMethod.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Enum class .*MultipleValueMethods has multiple methods annotated with @ThriftEnumValue")
    public void testMultipleValueMethods() {
        ThriftEnumMetadataBuilder.thriftEnumMetadata(MultipleValueMethods.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Enum class .*DuplicateValues returned duplicate enum values: 42")
    public void testDuplicateValues() {
        ThriftEnumMetadataBuilder.thriftEnumMetadata(DuplicateValues.class);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Enum class .*MultipleUnknownValues has multiple constants annotated with @ThriftEnumUnknownValue")
    public void testMultipleUnknownValues() {
        ThriftEnumMetadataBuilder.thriftEnumMetadata(MultipleUnknownValues.class);
    }

    @ThriftEnum
    public static enum MultipleUnknownValues {
        FOO,
        BAR;


        @ThriftEnumValue
        public int value() {
            return this.ordinal();
        }
    }

    @ThriftEnum
    public static enum DuplicateValues {
        FOO,
        BAR;


        @ThriftEnumValue
        public int value() {
            return 42;
        }
    }

    @ThriftEnum
    public static enum MultipleValueMethods {
        FOO;


        @ThriftEnumValue
        public int value1() {
            return 1;
        }

        @ThriftEnumValue
        public int value2() {
            return 2;
        }
    }

    @ThriftEnum
    public static enum MissingValueMethod {
        FOO;

    }

    public static enum MissingEnumAnnotation {
        FOO;


        @ThriftEnumValue
        public int value() {
            return 42;
        }
    }
}

