/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.drift.codec.metadata.MetadataErrorException;
import com.facebook.drift.codec.metadata.MetadataErrors;
import com.facebook.drift.codec.metadata.MetadataWarningException;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadataBuilder;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestThriftStructMetadataBuilder {
    @Test
    public void testNoId() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), NoId.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"not have an id");
    }

    @Test
    public void testMultipleIds() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleIds.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"multiple ids");
    }

    @Test
    public void testMultipleNames() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleNames.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).isEmpty();
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).hasSize(1);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataWarningException)metadataErrors.getWarnings().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"multiple names");
    }

    @Test
    public void testUnsupportedType() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), UnsupportedJavaType.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"not a supported Java type");
    }

    @Test
    public void testMultipleTypes() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleTypes.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"multiple types");
    }

    @Test
    public void testGenericBuilder() {
        Type structType = new TypeToken<GenericStruct<String>>(){}.getType();
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), structType);
        builder.build();
    }

    @Test(expectedExceptions={MetadataErrorException.class})
    public void testGenericBuilderForNonGenericStruct() {
        Type structType = new TypeToken<NonGenericStruct>(){}.getType();
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), structType);
        builder.build();
    }

    @Test
    public void testMultipleRequiredness() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), MultipleRequiredness.class);
        MetadataErrors metadataErrors = builder.getMetadataErrors();
        Assertions.assertThat((List)metadataErrors.getErrors()).as("metadata errors", new Object[0]).hasSize(1);
        Assertions.assertThat((List)metadataErrors.getWarnings()).as("metadata warnings", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((MetadataErrorException)metadataErrors.getErrors().get(0)).getMessage()).as("error message", new Object[0])).containsIgnoringCase((CharSequence)"multiple requiredness");
    }

    @Test
    public void testMergeableRequiredness() {
        ThriftStructMetadata metadata = new ThriftStructMetadataBuilder(new ThriftCatalog(), MergeableRequiredness.class).build();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadata.getField(1).getRequiredness()).as("requiredness of field 'foo'", new Object[0])).isEqualTo((Object)ThriftField.Requiredness.OPTIONAL);
    }

    @Test
    public void testNonFinalStructsOk() {
        ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(new ThriftCatalog(), NotFinalStruct.class);
        builder.build();
    }

    @ThriftStruct
    public static class NotFinalStruct {
    }

    @ThriftStruct
    public static final class MergeableRequiredness {
        @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
        public int getFoo() {
            return 0;
        }

        @ThriftField
        public void setFoo(int value) {
        }
    }

    @ThriftStruct
    public static final class MultipleRequiredness {
        @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
        public int getFoo() {
            return 0;
        }

        @ThriftField(value=1, requiredness=ThriftField.Requiredness.NONE)
        public void setFoo(int value) {
        }
    }

    @ThriftStruct(builder=GenericBuilder.class)
    public static class NonGenericStruct {
        private NonGenericStruct() {
        }

        public static class GenericBuilder<T> {
            @ThriftConstructor
            public NonGenericStruct build() {
                return new NonGenericStruct();
            }
        }
    }

    @ThriftStruct(builder=GenericBuilder.class)
    public static final class GenericStruct<T> {
        private final T fieldValue;

        private GenericStruct(T fieldValue) {
            this.fieldValue = fieldValue;
        }

        @ThriftField(value=1)
        public T getFieldValue() {
            return this.fieldValue;
        }

        public static class GenericBuilder<T> {
            private T fieldValue;

            @ThriftField(value=1)
            public GenericBuilder<T> setFieldValue(T fieldValue) {
                this.fieldValue = fieldValue;
                return this;
            }

            @ThriftConstructor
            public GenericStruct<T> build() {
                return new GenericStruct(this.fieldValue);
            }
        }
    }

    @ThriftStruct
    public static final class MultipleTypes {
        @ThriftField(value=1)
        public int getFoo() {
            return 0;
        }

        @ThriftField
        public void setFoo(short value) {
        }
    }

    @ThriftStruct
    public static final class UnsupportedJavaType {
        @ThriftField(value=1)
        public Lock unsupportedJavaType;
    }

    @ThriftStruct
    public static final class MultipleNames {
        @ThriftField(value=1, name="foo")
        public String getFoo() {
            return null;
        }

        @ThriftField(value=1, name="bar")
        public void setFoo(String value) {
        }
    }

    @ThriftStruct
    public static final class MultipleIds {
        @ThriftField(name="foo", value=1)
        public void setField1(String value) {
        }

        @ThriftField(name="foo", value=2)
        public void setField2(String value) {
        }

        @ThriftField(name="foo")
        public String getField1() {
            return null;
        }

        @ThriftField(name="foo")
        public String getField2() {
            return null;
        }
    }

    @ThriftStruct
    public static final class NoId {
        @ThriftField
        public String getField1() {
            return null;
        }

        @ThriftField
        public void setField1(String value) {
        }
    }
}

