/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.codec.UnionBean;
import com.facebook.drift.codec.UnionBuilder;
import com.facebook.drift.codec.UnionConstructor;
import com.facebook.drift.codec.UnionField;
import com.facebook.drift.codec.UnionMethod;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.MetadataErrorException;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftConstructorInjection;
import com.facebook.drift.codec.metadata.ThriftExtraction;
import com.facebook.drift.codec.metadata.ThriftFieldExtractor;
import com.facebook.drift.codec.metadata.ThriftFieldInjection;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftInjection;
import com.facebook.drift.codec.metadata.ThriftMethodExtractor;
import com.facebook.drift.codec.metadata.ThriftParameterInjection;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftUnionMetadataBuilder;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThriftUnionMetadata {
    @Test
    public void testField() {
        ThriftStructMetadata metadata = this.testMetadataBuild(UnionField.class, 0, 0);
        this.verifyFieldInjection(metadata, 1, "stringValue");
        this.verifyFieldExtraction(metadata, 1, "stringValue");
        this.verifyFieldInjection(metadata, 2, "longValue");
        this.verifyFieldExtraction(metadata, 2, "longValue");
        this.verifyFieldInjection(metadata, 3, "fruitValue");
        this.verifyFieldExtraction(metadata, 3, "fruitValue");
    }

    @Test
    public void testBean() {
        ThriftStructMetadata metadata = this.testMetadataBuild(UnionBean.class, 0, 3);
        this.verifyParameterInjection(metadata, 1, "stringValue", 0);
        this.verifyMethodExtraction(metadata, 1, "stringValue", "getStringValue");
        this.verifyParameterInjection(metadata, 2, "longValue", 0);
        this.verifyMethodExtraction(metadata, 2, "longValue", "getLongValue");
        this.verifyParameterInjection(metadata, 3, "fruitValue", 0);
        this.verifyMethodExtraction(metadata, 3, "fruitValue", "getFruitValue");
    }

    @Test
    public void testConstructor() {
        ThriftStructMetadata metadata = this.testMetadataBuild(UnionConstructor.class, 1, 0);
        this.verifyParameterInjection(metadata, 1, "stringValue", 0);
        this.verifyMethodExtraction(metadata, 1, "stringValue", "getStringValue");
        this.verifyParameterInjection(metadata, 2, "longValue", 0);
        this.verifyMethodExtraction(metadata, 2, "longValue", "getLongValue");
        this.verifyParameterInjection(metadata, 3, "fruitValue", 0);
        this.verifyMethodExtraction(metadata, 3, "fruitValue", "getFruitValue");
    }

    @Test
    public void testMethod() {
        try {
            this.testMetadataBuild(UnionMethod.class, 0, 1);
            Assert.fail();
        }
        catch (MetadataErrorException e) {
            Assert.assertEquals((int)1, (int)e.getSuppressed().length);
            Assert.assertEquals(e.getSuppressed()[0].getClass(), MetadataErrorException.class);
            Assert.assertTrue((boolean)e.getSuppressed()[0].getMessage().contains("setData is not a supported getter or setter"));
        }
    }

    @Test
    public void testBuilder() {
        ThriftStructMetadata metadata = this.testMetadataBuild(UnionBuilder.class, 0, 3);
        this.verifyParameterInjection(metadata, 1, "stringValue", 0);
        this.verifyMethodExtraction(metadata, 1, "stringValue", "getStringValue");
        this.verifyParameterInjection(metadata, 2, "longValue", 0);
        this.verifyMethodExtraction(metadata, 2, "longValue", "getLongValue");
        this.verifyParameterInjection(metadata, 3, "fruitValue", 0);
        this.verifyMethodExtraction(metadata, 3, "fruitValue", "getFruitValue");
    }

    private void verifyFieldInjection(ThriftStructMetadata metadata, int id, String name) {
        ThriftInjection injection = (ThriftInjection)metadata.getField(id).getInjections().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)injection).isNotNull()).isInstanceOf(ThriftFieldInjection.class);
        ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
        Assert.assertEquals((String)fieldInjection.getField().getName(), (String)name);
    }

    private void verifyFieldExtraction(ThriftStructMetadata metadata, int id, String name) {
        Assert.assertTrue((boolean)metadata.getField(id).getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)metadata.getField(id).getExtraction().get();
        Assertions.assertThat((Object)extraction).isInstanceOf(ThriftFieldExtractor.class);
        ThriftFieldExtractor fieldExtractor = (ThriftFieldExtractor)extraction;
        Assert.assertEquals((String)fieldExtractor.getField().getName(), (String)name);
    }

    private void verifyParameterInjection(ThriftStructMetadata metadata, int id, String name, int parameterIndex) {
        ThriftInjection injection = (ThriftInjection)metadata.getField(id).getInjections().get(0);
        ((AbstractObjectAssert)Assertions.assertThat((Object)injection).isNotNull()).isInstanceOf(ThriftParameterInjection.class);
        ThriftParameterInjection parameterInjection = (ThriftParameterInjection)injection;
        Assert.assertEquals((int)parameterInjection.getId(), (int)id);
        Assert.assertEquals((String)parameterInjection.getName(), (String)name);
        Assert.assertEquals((int)parameterInjection.getParameterIndex(), (int)parameterIndex);
    }

    private void verifyMethodExtraction(ThriftStructMetadata metadata, int id, String name, String methodName) {
        Assert.assertTrue((boolean)metadata.getField(id).getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)metadata.getField(id).getExtraction().get();
        Assertions.assertThat((Object)extraction).isInstanceOf(ThriftMethodExtractor.class);
        ThriftMethodExtractor methodExtractor = (ThriftMethodExtractor)extraction;
        Assert.assertEquals((String)methodExtractor.getMethod().getName(), (String)methodName);
        Assert.assertEquals((String)methodExtractor.getName(), (String)name);
    }

    private ThriftStructMetadata testMetadataBuild(Class<?> structClass, int expectedConstructorParameters, int expectedMethodInjections) {
        ThriftCatalog catalog = new ThriftCatalog();
        ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(catalog, structClass);
        Assert.assertNotNull((Object)builder);
        Assert.assertNotNull((Object)builder.getMetadataErrors());
        builder.getMetadataErrors().throwIfHasErrors();
        Assert.assertEquals((int)builder.getMetadataErrors().getWarnings().size(), (int)0);
        ThriftStructMetadata metadata = builder.build();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((Object)ThriftStructMetadata.MetadataType.UNION, (Object)metadata.getMetadataType());
        this.verifyField(metadata, 1, "stringValue");
        this.verifyField(metadata, 2, "longValue");
        this.verifyField(metadata, 3, "fruitValue");
        if (expectedConstructorParameters == 0) {
            Assert.assertTrue((boolean)metadata.getConstructorInjection().isPresent());
            ThriftConstructorInjection constructorInjection = (ThriftConstructorInjection)metadata.getConstructorInjection().get();
            Assert.assertEquals((int)constructorInjection.getParameters().size(), (int)0);
        } else {
            for (ThriftFieldMetadata fieldMetadata : metadata.getFields(FieldKind.THRIFT_FIELD)) {
                Assert.assertTrue((boolean)fieldMetadata.getConstructorInjection().isPresent());
                Assert.assertEquals((int)((ThriftConstructorInjection)fieldMetadata.getConstructorInjection().get()).getParameters().size(), (int)expectedConstructorParameters);
            }
        }
        Assert.assertEquals((int)metadata.getMethodInjections().size(), (int)expectedMethodInjections);
        return metadata;
    }

    private <T> void verifyField(ThriftStructMetadata metadata, int id, String name) {
        ThriftFieldMetadata metadataField = metadata.getField(id);
        Assert.assertNotNull((Object)metadataField, (String)"metadataField is null");
        Assert.assertEquals((int)metadataField.getId(), (int)id);
        Assert.assertEquals((String)metadataField.getName(), (String)name);
        Assert.assertFalse((boolean)metadataField.isReadOnly());
        Assert.assertFalse((boolean)metadataField.isWriteOnly());
        Assert.assertTrue((boolean)metadataField.getExtraction().isPresent());
        ThriftExtraction extraction = (ThriftExtraction)metadataField.getExtraction().get();
        Assert.assertEquals((int)extraction.getId(), (int)id);
        Assert.assertEquals((String)extraction.getName(), (String)name);
        Assert.assertNotNull((Object)metadataField.getInjections());
        Assert.assertEquals((int)metadataField.getInjections().size(), (int)1);
        ThriftInjection injection = (ThriftInjection)metadataField.getInjections().get(0);
        Assert.assertEquals((int)injection.getId(), (int)id);
        Assert.assertEquals((String)injection.getName(), (String)name);
    }
}

