/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftDocumentation;
import com.facebook.drift.annotations.ThriftOrder;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.drift.annotations.ThriftUnion;
import com.facebook.drift.codec.ThriftProtocolType;
import com.facebook.drift.codec.internal.builtin.OptionalDoubleThriftCodec;
import com.facebook.drift.codec.internal.builtin.OptionalIntThriftCodec;
import com.facebook.drift.codec.internal.builtin.OptionalLongThriftCodec;
import com.facebook.drift.codec.internal.coercion.DefaultJavaCoercions;
import com.facebook.drift.codec.internal.coercion.FromThrift;
import com.facebook.drift.codec.internal.coercion.ToThrift;
import com.facebook.drift.codec.metadata.DefaultThriftTypeReference;
import com.facebook.drift.codec.metadata.FieldMetadata;
import com.facebook.drift.codec.metadata.MetadataErrors;
import com.facebook.drift.codec.metadata.RecursiveThriftTypeReference;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.facebook.drift.codec.metadata.ThriftEnumMetadata;
import com.facebook.drift.codec.metadata.ThriftEnumMetadataBuilder;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadataBuilder;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.codec.metadata.ThriftTypeReference;
import com.facebook.drift.codec.metadata.ThriftUnionMetadataBuilder;
import com.facebook.drift.codec.metadata.TypeCoercion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ThriftCatalog {
    private final MetadataErrors.Monitor monitor;
    private final ConcurrentMap<Type, ThriftStructMetadata> structs = new ConcurrentHashMap<Type, ThriftStructMetadata>();
    private final ConcurrentMap<Class<?>, ThriftEnumMetadata<?>> enums = new ConcurrentHashMap();
    private final ConcurrentMap<Type, TypeCoercion> coercions = new ConcurrentHashMap<Type, TypeCoercion>();
    private final ConcurrentMap<Class<?>, ThriftType> manualTypes = new ConcurrentHashMap();
    private final ConcurrentMap<Type, ThriftType> typeCache = new ConcurrentHashMap<Type, ThriftType>();
    private final ThreadLocal<Deque<Type>> stack = ThreadLocal.withInitial(ArrayDeque::new);
    private final ThreadLocal<Deque<Type>> deferredTypesWorkList = ThreadLocal.withInitial(ArrayDeque::new);

    public ThriftCatalog() {
        this(MetadataErrors.NULL_MONITOR);
    }

    public ThriftCatalog(MetadataErrors.Monitor monitor) {
        this.monitor = monitor;
        this.addDefaultCoercions(DefaultJavaCoercions.class);
        this.addThriftType(new OptionalDoubleThriftCodec().getType());
        this.addThriftType(new OptionalIntThriftCodec().getType());
        this.addThriftType(new OptionalLongThriftCodec().getType());
    }

    @VisibleForTesting
    MetadataErrors.Monitor getMonitor() {
        return this.monitor;
    }

    public void addThriftType(ThriftType thriftType) {
        this.manualTypes.put(TypeToken.of((Type)thriftType.getJavaType()).getRawType(), thriftType);
    }

    public void addDefaultCoercions(Class<?> coercionsClass) {
        Objects.requireNonNull(coercionsClass, "coercionsClass is null");
        HashMap<ThriftType, Method> toThriftCoercions = new HashMap<ThriftType, Method>();
        HashMap<ThriftType, Method> fromThriftCoercions = new HashMap<ThriftType, Method>();
        for (Method method : coercionsClass.getDeclaredMethods()) {
            Method oldValue;
            ThriftType coercedType;
            ThriftType thriftType;
            if (method.isAnnotationPresent(ToThrift.class)) {
                this.verifyCoercionMethod(method);
                thriftType = this.getThriftType(method.getGenericReturnType());
                coercedType = thriftType.coerceTo(method.getGenericParameterTypes()[0]);
                oldValue = toThriftCoercions.put(coercedType, method);
                Preconditions.checkArgument((oldValue == null ? 1 : 0) != 0, (String)"Coercion class two @ToThrift methods (%s and %s) for type %s", (Object)coercionsClass.getName(), (Object)method, (Object)oldValue, (Object)coercedType);
                continue;
            }
            if (!method.isAnnotationPresent(FromThrift.class)) continue;
            this.verifyCoercionMethod(method);
            thriftType = this.getThriftType(method.getGenericParameterTypes()[0]);
            coercedType = thriftType.coerceTo(method.getGenericReturnType());
            oldValue = fromThriftCoercions.put(coercedType, method);
            Preconditions.checkArgument((oldValue == null ? 1 : 0) != 0, (String)"Coercion class two @FromThrift methods (%s and %s) for type %s", (Object)coercionsClass.getName(), (Object)method, (Object)oldValue, (Object)coercedType);
        }
        Sets.SetView difference = Sets.symmetricDifference(toThriftCoercions.keySet(), fromThriftCoercions.keySet());
        Preconditions.checkArgument((boolean)difference.isEmpty(), (String)"Coercion class %s does not have matched @ToThrift and @FromThrift methods for types %s", (Object)coercionsClass.getName(), (Object)difference);
        HashMap<Type, TypeCoercion> coercions = new HashMap<Type, TypeCoercion>();
        for (Map.Entry entry : toThriftCoercions.entrySet()) {
            ThriftType type = (ThriftType)entry.getKey();
            Method toThriftMethod = (Method)entry.getValue();
            Method fromThriftMethod = (Method)fromThriftCoercions.get(type);
            Preconditions.checkState((fromThriftMethod != null ? 1 : 0) != 0, (String)"Coercion class %s does not have matched @ToThrift and @FromThrift methods for type %s", (Object)coercionsClass.getName(), (Object)type);
            TypeCoercion coercion = new TypeCoercion(type, toThriftMethod, fromThriftMethod);
            coercions.put(type.getJavaType(), coercion);
        }
        this.coercions.putAll(coercions);
    }

    private void verifyCoercionMethod(Method method) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)"Method %s is not static", (Object)method.toGenericString());
        Preconditions.checkArgument((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (String)"Method %s must have exactly one parameter", (Object)method.toGenericString());
        Preconditions.checkArgument((method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (String)"Method %s must have a return value", (Object)method.toGenericString());
    }

    public TypeCoercion getDefaultCoercion(Type type) {
        return (TypeCoercion)this.coercions.get(type);
    }

    public ThriftType getThriftType(Type javaType) throws IllegalArgumentException {
        ThriftType thriftType = this.getThriftTypeFromCache(javaType);
        if (thriftType == null) {
            thriftType = this.buildThriftType(javaType);
        }
        return thriftType;
    }

    public ThriftType getThriftTypeFromCache(Type javaType) {
        return (ThriftType)this.typeCache.get(javaType);
    }

    private ThriftType buildThriftType(Type javaType) {
        ThriftType thriftType = this.buildThriftTypeInternal(javaType);
        this.typeCache.putIfAbsent(javaType, thriftType);
        if (this.stack.get().isEmpty()) {
            Deque<Type> unresolvedJavaTypes = this.deferredTypesWorkList.get();
            while (!unresolvedJavaTypes.isEmpty()) {
                Type unresolvedJavaType = unresolvedJavaTypes.pop();
                if (this.typeCache.containsKey(unresolvedJavaType)) continue;
                ThriftType resolvedThriftType = this.buildThriftTypeInternal(unresolvedJavaType);
                this.typeCache.putIfAbsent(unresolvedJavaType, resolvedThriftType);
            }
        }
        return thriftType;
    }

    private ThriftType buildThriftTypeInternal(Type javaType) throws IllegalArgumentException {
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        ThriftType manualType = (ThriftType)this.manualTypes.get(rawType);
        if (manualType != null) {
            return manualType;
        }
        if (Boolean.TYPE == rawType) {
            return ThriftType.BOOL;
        }
        if (Byte.TYPE == rawType) {
            return ThriftType.BYTE;
        }
        if (Short.TYPE == rawType) {
            return ThriftType.I16;
        }
        if (Integer.TYPE == rawType) {
            return ThriftType.I32;
        }
        if (Long.TYPE == rawType) {
            return ThriftType.I64;
        }
        if (Double.TYPE == rawType) {
            return ThriftType.DOUBLE;
        }
        if (Float.TYPE == rawType) {
            return ThriftType.FLOAT;
        }
        if (String.class == rawType) {
            return ThriftType.STRING;
        }
        if (ByteBuffer.class.isAssignableFrom(rawType)) {
            return ThriftType.BINARY;
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            ThriftEnumMetadata<?> thriftEnumMetadata = this.getThriftEnumMetadata(rawType);
            return ThriftType.enumType(thriftEnumMetadata);
        }
        if (rawType.isArray()) {
            Class<?> elementType = rawType.getComponentType();
            if (elementType == Byte.TYPE) {
                return ((TypeCoercion)this.coercions.get(javaType)).getThriftType();
            }
            return ThriftType.array(this.getCollectionElementThriftTypeReference(elementType));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type mapKeyType = ReflectionHelper.getMapKeyType(javaType);
            Type mapValueType = ReflectionHelper.getMapValueType(javaType);
            return ThriftType.map(this.getMapKeyThriftTypeReference(mapKeyType), this.getMapValueThriftTypeReference(mapValueType));
        }
        if (Set.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return ThriftType.set(this.getCollectionElementThriftTypeReference(elementType));
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return ThriftType.list(this.getCollectionElementThriftTypeReference(elementType));
        }
        if (Optional.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getOptionalType(javaType);
            return ThriftType.optional(this.getOptionalThriftTypeReference(elementType));
        }
        if (Void.TYPE.isAssignableFrom(rawType) || Void.class.isAssignableFrom(rawType)) {
            return ThriftType.VOID;
        }
        if (ThriftCatalog.isStructType(rawType)) {
            ThriftStructMetadata structMetadata = this.getThriftStructMetadata(javaType);
            return ThriftType.struct(structMetadata);
        }
        if (ListenableFuture.class.isAssignableFrom(rawType)) {
            Type returnType = ReflectionHelper.getFutureReturnType(javaType);
            return this.getThriftType(returnType);
        }
        TypeCoercion coercion = (TypeCoercion)this.coercions.get(javaType);
        if (coercion != null) {
            return coercion.getThriftType();
        }
        throw new IllegalArgumentException("Type can not be coerced to a Thrift type: " + javaType);
    }

    public ThriftTypeReference getFieldThriftTypeReference(FieldMetadata fieldMetadata) {
        Boolean isRecursive = fieldMetadata.isRecursiveReference();
        if (isRecursive == null) {
            throw new IllegalStateException("Field normalization should have set a non-null value for isRecursiveReference");
        }
        return this.getThriftTypeReference(fieldMetadata.getJavaType(), isRecursive != false ? Recursiveness.FORCED : Recursiveness.NOT_ALLOWED);
    }

    public ThriftTypeReference getCollectionElementThriftTypeReference(Type javaType) {
        if (ThriftCatalog.isStructType(javaType)) {
            return this.getThriftTypeReference(javaType, Recursiveness.FORCED);
        }
        return this.getThriftTypeReference(javaType, Recursiveness.NOT_ALLOWED);
    }

    public ThriftTypeReference getMapKeyThriftTypeReference(Type javaType) {
        if (ThriftCatalog.isStructType(javaType)) {
            return this.getThriftTypeReference(javaType, Recursiveness.FORCED);
        }
        return this.getThriftTypeReference(javaType, Recursiveness.NOT_ALLOWED);
    }

    public ThriftTypeReference getMapValueThriftTypeReference(Type javaType) {
        if (ThriftCatalog.isStructType(javaType)) {
            return this.getThriftTypeReference(javaType, Recursiveness.FORCED);
        }
        return this.getThriftTypeReference(javaType, Recursiveness.NOT_ALLOWED);
    }

    public ThriftTypeReference getOptionalThriftTypeReference(Type javaType) {
        if (ThriftCatalog.isStructType(javaType)) {
            return this.getThriftTypeReference(javaType, Recursiveness.FORCED);
        }
        return this.getThriftTypeReference(javaType, Recursiveness.NOT_ALLOWED);
    }

    private ThriftTypeReference getThriftTypeReference(Type javaType, Recursiveness recursiveness) {
        ThriftType thriftType = this.getThriftTypeFromCache(javaType);
        if (thriftType == null) {
            if (recursiveness == Recursiveness.FORCED || recursiveness == Recursiveness.ALLOWED && this.stack.get().contains(javaType)) {
                this.deferredTypesWorkList.get().add(javaType);
                return new RecursiveThriftTypeReference(this, javaType);
            }
            thriftType = this.buildThriftType(javaType);
            this.typeCache.putIfAbsent(javaType, thriftType);
        }
        return new DefaultThriftTypeReference(thriftType);
    }

    public boolean isSupportedStructFieldType(Type javaType) {
        return this.getThriftProtocolType(javaType) != ThriftProtocolType.UNKNOWN;
    }

    public ThriftProtocolType getThriftProtocolType(Type javaType) {
        Type elementType;
        ThriftType manualType = (ThriftType)this.manualTypes.get(javaType);
        if (manualType != null) {
            return manualType.getProtocolType();
        }
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        if (Boolean.TYPE == rawType) {
            return ThriftProtocolType.BOOL;
        }
        if (Byte.TYPE == rawType) {
            return ThriftProtocolType.BYTE;
        }
        if (Short.TYPE == rawType) {
            return ThriftProtocolType.I16;
        }
        if (Integer.TYPE == rawType) {
            return ThriftProtocolType.I32;
        }
        if (Long.TYPE == rawType) {
            return ThriftProtocolType.I64;
        }
        if (Double.TYPE == rawType) {
            return ThriftProtocolType.DOUBLE;
        }
        if (Float.TYPE == rawType) {
            return ThriftProtocolType.FLOAT;
        }
        if (String.class == rawType) {
            return ThriftProtocolType.STRING;
        }
        if (ByteBuffer.class.isAssignableFrom(rawType)) {
            return ThriftProtocolType.BINARY;
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            return ThriftProtocolType.ENUM;
        }
        if (rawType.isArray() && this.isSupportedArrayComponentType((Class<?>)(elementType = rawType.getComponentType()))) {
            return ThriftProtocolType.LIST;
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type mapKeyType = ReflectionHelper.getMapKeyType(javaType);
            Type mapValueType = ReflectionHelper.getMapValueType(javaType);
            if (this.isSupportedStructFieldType(mapKeyType) && this.isSupportedStructFieldType(mapValueType)) {
                return ThriftProtocolType.MAP;
            }
        }
        if (Set.class.isAssignableFrom(rawType) && this.isSupportedStructFieldType(elementType = ReflectionHelper.getIterableType(javaType))) {
            return ThriftProtocolType.SET;
        }
        if (Iterable.class.isAssignableFrom(rawType) && this.isSupportedStructFieldType(elementType = ReflectionHelper.getIterableType(javaType))) {
            return ThriftProtocolType.LIST;
        }
        if (Optional.class.isAssignableFrom(rawType)) {
            elementType = ReflectionHelper.getOptionalType(javaType);
            return this.getThriftProtocolType(elementType);
        }
        if (ThriftCatalog.isStructType(rawType)) {
            return ThriftProtocolType.STRUCT;
        }
        TypeCoercion coercion = (TypeCoercion)this.coercions.get(javaType);
        if (coercion != null) {
            return coercion.getThriftType().getProtocolType();
        }
        return ThriftProtocolType.UNKNOWN;
    }

    public static boolean isStructType(Type javaType) {
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        return rawType.isAnnotationPresent(ThriftStruct.class) || rawType.isAnnotationPresent(ThriftUnion.class);
    }

    public boolean isSupportedArrayComponentType(Class<?> componentType) {
        return Boolean.TYPE == componentType || Byte.TYPE == componentType || Short.TYPE == componentType || Integer.TYPE == componentType || Long.TYPE == componentType || Double.TYPE == componentType || Float.TYPE == componentType;
    }

    public <T extends Enum<T>> ThriftEnumMetadata<?> getThriftEnumMetadata(Class<?> enumClass) {
        ThriftEnumMetadata<?> current;
        Preconditions.checkArgument((boolean)enumClass.isEnum(), (String)"Class %s is not an enum", (Object)enumClass.getName());
        ThriftEnumMetadata<?> enumMetadata = (ThriftEnumMetadata<?>)this.enums.get(enumClass);
        if (enumMetadata == null && (current = this.enums.putIfAbsent(enumClass, enumMetadata = ThriftEnumMetadataBuilder.thriftEnumMetadata(enumClass))) != null) {
            enumMetadata = current;
        }
        return enumMetadata;
    }

    public <T> ThriftStructMetadata getThriftStructMetadata(Type structType) {
        ThriftStructMetadata structMetadata = (ThriftStructMetadata)this.structs.get(structType);
        Class structClass = TypeToken.of((Type)structType).getRawType();
        if (structMetadata == null) {
            if (structClass.isAnnotationPresent(ThriftStruct.class)) {
                structMetadata = this.extractThriftStructMetadata(structType);
            } else if (structClass.isAnnotationPresent(ThriftUnion.class)) {
                structMetadata = this.extractThriftUnionMetadata(structType);
            } else {
                throw new IllegalStateException("getThriftStructMetadata called on a class that has no @ThriftStruct or @ThriftUnion annotation");
            }
            ThriftStructMetadata current = this.structs.putIfAbsent(structType, structMetadata);
            if (current != null) {
                structMetadata = current;
            }
        }
        return structMetadata;
    }

    private static Class<?> getDriftMetaClassOf(Class<?> cls) throws ClassNotFoundException {
        ClassLoader loader = cls.getClassLoader();
        if (loader == null) {
            throw new ClassNotFoundException("null class loader");
        }
        return loader.loadClass(cls.getName() + "$DriftMeta");
    }

    public static ImmutableList<String> getThriftDocumentation(Class<?> objectClass) {
        ThriftDocumentation documentation = objectClass.getAnnotation(ThriftDocumentation.class);
        if (documentation == null) {
            try {
                Class<?> docsClass = ThriftCatalog.getDriftMetaClassOf(objectClass);
                documentation = docsClass.getAnnotation(ThriftDocumentation.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return documentation == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])documentation.value());
    }

    public static ImmutableList<String> getThriftDocumentation(Method method) {
        ThriftDocumentation documentation = method.getAnnotation(ThriftDocumentation.class);
        if (documentation == null) {
            try {
                Class<?> docsClass = ThriftCatalog.getDriftMetaClassOf(method.getDeclaringClass());
                documentation = docsClass.getDeclaredMethod(method.getName(), new Class[0]).getAnnotation(ThriftDocumentation.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return documentation == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])documentation.value());
    }

    public static ImmutableList<String> getThriftDocumentation(Field field) {
        ThriftDocumentation documentation = field.getAnnotation(ThriftDocumentation.class);
        if (documentation == null) {
            try {
                Class<?> docsClass = ThriftCatalog.getDriftMetaClassOf(field.getDeclaringClass());
                documentation = docsClass.getDeclaredField(field.getName()).getAnnotation(ThriftDocumentation.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return documentation == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])documentation.value());
    }

    public static <T extends Enum<T>> ImmutableList<String> getThriftDocumentation(Enum<T> enumConstant) {
        try {
            Field f = enumConstant.getDeclaringClass().getField(enumConstant.name());
            return ThriftCatalog.getThriftDocumentation(f);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return ImmutableList.of();
        }
    }

    public static Optional<Integer> getMethodOrder(Method method) {
        ThriftOrder order = method.getAnnotation(ThriftOrder.class);
        if (order == null) {
            try {
                Class<?> docsClass = ThriftCatalog.getDriftMetaClassOf(method.getDeclaringClass());
                order = docsClass.getDeclaredMethod(method.getName(), new Class[0]).getAnnotation(ThriftOrder.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return order == null ? Optional.empty() : Optional.of(order.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThriftStructMetadata extractThriftStructMetadata(Type structType) {
        Objects.requireNonNull(structType, "structType is null");
        Deque<Type> stack = this.stack.get();
        if (stack.contains(structType)) {
            String path = Stream.concat(stack.stream(), Stream.of(structType)).map(type -> TypeToken.of((Type)type).getRawType().getName()).collect(Collectors.joining("->"));
            throw new IllegalArgumentException("Circular references must be qualified with 'isRecursive' on a @ThriftField annotation in the cycle: " + path);
        }
        stack.push(structType);
        try {
            ThriftStructMetadataBuilder builder = new ThriftStructMetadataBuilder(this, structType);
            ThriftStructMetadata thriftStructMetadata = builder.build();
            return thriftStructMetadata;
        }
        finally {
            Type top = stack.pop();
            Preconditions.checkState((boolean)structType.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object)structType, (Object)top);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThriftStructMetadata extractThriftUnionMetadata(Type unionType) {
        Objects.requireNonNull(unionType, "unionType is null");
        Deque<Type> stack = this.stack.get();
        if (stack.contains(unionType)) {
            String path = Stream.concat(stack.stream(), Stream.of(unionType)).map(type -> TypeToken.of((Type)type).getRawType().getName()).collect(Collectors.joining("->"));
            throw new IllegalArgumentException("Circular references must be qualified with 'isRecursive' on a @ThriftField annotation in the cycle: " + path);
        }
        stack.push(unionType);
        try {
            ThriftUnionMetadataBuilder builder = new ThriftUnionMetadataBuilder(this, unionType);
            ThriftStructMetadata thriftStructMetadata = builder.build();
            return thriftStructMetadata;
        }
        finally {
            Type top = stack.pop();
            Preconditions.checkState((boolean)unionType.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object)unionType, (Object)top);
        }
    }

    static enum Recursiveness {
        NOT_ALLOWED,
        ALLOWED,
        FORCED;

    }
}

