/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.builtin;

import com.facebook.drift.codec.CodecThriftType;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.OptionalDouble;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OptionalDoubleThriftCodec
implements ThriftCodec<OptionalDouble> {
    private static final ThriftType THRIFT_TYPE = new ThriftType(ThriftType.DOUBLE, (Type)((Object)OptionalDouble.class), OptionalDouble.empty());

    @CodecThriftType
    public static ThriftType getThriftType() {
        return THRIFT_TYPE;
    }

    @Override
    public ThriftType getType() {
        return THRIFT_TYPE;
    }

    @Override
    public OptionalDouble read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return OptionalDouble.of(protocol.readDouble());
    }

    @Override
    public void write(OptionalDouble value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        protocol.writeDouble(value.orElseThrow(() -> new IllegalArgumentException("value is not present")));
    }

    @Override
    public boolean isNull(OptionalDouble value) {
        return value == null || !value.isPresent();
    }
}

