/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.idl.generator;

import com.facebook.drift.annotations.ThriftService;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.ThriftProtocolType;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.MetadataErrorException;
import com.facebook.drift.codec.metadata.MetadataErrors;
import com.facebook.drift.codec.metadata.MetadataWarningException;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftMethodMetadata;
import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.codec.metadata.ThriftTypeReference;
import com.facebook.drift.idl.generator.ThriftIdlGeneratorConfig;
import com.facebook.drift.idl.generator.ThriftIdlGeneratorException;
import com.facebook.drift.idl.generator.ThriftIdlRenderer;
import com.facebook.drift.idl.generator.ThriftTypeRenderer;
import com.google.common.base.MoreObjects;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ThriftIdlGenerator {
    private static final Set<ThriftType> BUILT_IN_TYPES = ImmutableSet.builder().add((Object)ThriftType.BOOL).add((Object)ThriftType.BYTE).add((Object)ThriftType.I16).add((Object)ThriftType.I32).add((Object)ThriftType.I64).add((Object)ThriftType.DOUBLE).add((Object)ThriftType.STRING).add((Object)ThriftType.BINARY).add((Object)new ThriftType(ThriftType.BOOL, Boolean.class)).add((Object)new ThriftType(ThriftType.BYTE, Byte.class)).add((Object)new ThriftType(ThriftType.I16, Short.class)).add((Object)new ThriftType(ThriftType.I32, Integer.class)).add((Object)new ThriftType(ThriftType.I64, Long.class)).add((Object)new ThriftType(ThriftType.DOUBLE, Double.class)).add((Object)new ThriftType(ThriftType.STRING, String.class)).add((Object)new ThriftType(ThriftType.BINARY, byte[].class)).build();
    private final ClassLoader classLoader;
    private final Consumer<String> verboseLogger;
    private final ThriftCodecManager codecManager;
    private final String defaultPackage;
    private final Map<Object, String> includes = new HashMap<Object, String>();
    private final Set<ThriftType> usedIncludedTypes = new HashSet<ThriftType>();
    private final Map<String, String> namespaces;
    private Set<ThriftType> knownTypes = new HashSet<ThriftType>(BUILT_IN_TYPES);
    private ThriftTypeRenderer typeRenderer = new ThriftTypeRenderer((Map<ThriftType, String>)ImmutableMap.of());
    private List<ThriftType> thriftTypes = new CopyOnWriteArrayList<ThriftType>();
    private List<ThriftServiceMetadata> thriftServices = new CopyOnWriteArrayList<ThriftServiceMetadata>();
    private boolean recursive;

    public ThriftIdlGenerator(ThriftIdlGeneratorConfig config) {
        this(config, (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)ClassLoader.getSystemClassLoader()));
    }

    public ThriftIdlGenerator(ThriftIdlGeneratorConfig config, ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        MetadataErrors.Monitor monitor = ThriftIdlGenerator.createMonitor(config.getErrorLogger(), config.getWarningLogger());
        this.codecManager = new ThriftCodecManager(new ThriftCatalog(monitor));
        this.verboseLogger = config.getVerboseLogger();
        String defaultPackage = config.getDefaultPackage();
        this.defaultPackage = defaultPackage.isEmpty() ? "" : defaultPackage + ".";
        Map<String, String> paramIncludeMap = config.getIncludes();
        for (Map.Entry<String, String> entry : paramIncludeMap.entrySet()) {
            Class<?> clazz = this.load(entry.getKey());
            if (clazz == null) continue;
            Object result = this.convertToThrift(clazz);
            this.includes.put(result, entry.getValue());
        }
        this.namespaces = config.getNamespaces();
        this.recursive = config.isRecursive();
    }

    public String generate(Iterable<String> inputs) {
        for (String className : inputs) {
            Object result = this.convertToThrift(this.load(className));
            if (result instanceof ThriftType) {
                this.thriftTypes.add((ThriftType)result);
            } else {
                this.thriftServices.add((ThriftServiceMetadata)result);
            }
            this.includes.remove(result);
        }
        if (!this.verify()) {
            throw new ThriftIdlGeneratorException("Errors found during verification.");
        }
        return this.generate();
    }

    private String getFullClassName(String className) {
        if (className.indexOf(46) == -1) {
            return this.defaultPackage + className;
        }
        return className;
    }

    @SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT"})
    private boolean verify() {
        if (this.recursive) {
            int size;
            do {
                size = this.thriftTypes.size();
                for (ThriftType type : this.thriftTypes) {
                    this.verifyStruct(type, true);
                }
            } while (size != this.thriftTypes.size());
            do {
                size = this.thriftServices.size();
                for (ThriftServiceMetadata service : this.thriftServices) {
                    this.verifyService(service, true);
                }
            } while (size != this.thriftServices.size());
            this.recursive = false;
            this.usedIncludedTypes.clear();
            this.knownTypes = new HashSet<ThriftType>(BUILT_IN_TYPES);
        }
        return this.verifyTypes() & this.verifyServices();
    }

    private boolean verifyTypes() {
        SuccessAndResult<ThriftType> output = ThriftIdlGenerator.topologicalSort(this.thriftTypes, type -> {
            ThriftProtocolType proto = type.getProtocolType();
            if (proto == ThriftProtocolType.ENUM || proto == ThriftProtocolType.STRUCT) {
                return this.verifyStruct((ThriftType)type, true);
            }
            throw new VerifyException("Top-level non-enum and non-struct?");
        });
        if (output.isSuccess()) {
            this.thriftTypes = output.getResult();
            return true;
        }
        for (ThriftType type2 : output.getResult()) {
            this.verifyStruct(type2, false);
        }
        return false;
    }

    private boolean verifyServices() {
        SuccessAndResult<ThriftServiceMetadata> output = ThriftIdlGenerator.topologicalSort(this.thriftServices, metadata -> this.verifyService((ThriftServiceMetadata)metadata, true));
        if (output.isSuccess()) {
            this.thriftServices = output.getResult();
            return true;
        }
        for (ThriftServiceMetadata s : output.getResult()) {
            this.verifyService(s, false);
        }
        return false;
    }

    private static <T> SuccessAndResult<T> topologicalSort(List<T> list, Predicate<T> isKnown) {
        List<T> remaining = list;
        ArrayList<T> newList = new ArrayList<T>();
        int prevSize = 0;
        while (prevSize != remaining.size()) {
            prevSize = remaining.size();
            ArrayList<T> bad = new ArrayList<T>();
            for (T value : remaining) {
                if (isKnown.test(value)) {
                    newList.add(value);
                    continue;
                }
                bad.add(value);
            }
            remaining = bad;
        }
        if (prevSize == 0) {
            return new SuccessAndResult(true, newList);
        }
        return new SuccessAndResult<T>(false, remaining);
    }

    private boolean verifyService(ThriftServiceMetadata service, boolean quiet) {
        boolean ok = true;
        for (Map.Entry method : service.getMethods().entrySet()) {
            for (ThriftFieldMetadata field : ((ThriftMethodMetadata)method.getValue()).getParameters()) {
                if (this.verifyField(field.getThriftType())) continue;
                ok = false;
                if (quiet) continue;
                throw new ThriftIdlGeneratorException(String.format("Unknown argument type %s in %s.%s", this.typeName(field.getThriftType()), service.getName(), method.getKey()));
            }
            for (ThriftType exception : ((ThriftMethodMetadata)method.getValue()).getExceptions().values()) {
                if (this.verifyField(exception)) continue;
                ok = false;
                if (quiet) continue;
                throw new ThriftIdlGeneratorException(String.format("Unknown exception type %s in %s.%s", this.typeName(exception), service.getName(), method.getKey()));
            }
            if (((ThriftMethodMetadata)method.getValue()).getReturnType().equals((Object)ThriftType.VOID) || this.verifyField(((ThriftMethodMetadata)method.getValue()).getReturnType())) continue;
            ok = false;
            if (quiet) continue;
            throw new ThriftIdlGeneratorException(String.format("Unknown return type %s in %s.%s", this.typeName(((ThriftMethodMetadata)method.getValue()).getReturnType()), service.getName(), method.getKey()));
        }
        return ok;
    }

    private boolean verifyElementType(ThriftTypeReference type) {
        if (!this.recursive && type.isRecursive()) {
            return true;
        }
        return this.verifyField(type.get());
    }

    @SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT"})
    private boolean verifyField(ThriftType type) {
        ThriftProtocolType proto = type.getProtocolType();
        if (proto == ThriftProtocolType.SET || proto == ThriftProtocolType.LIST) {
            return this.verifyElementType(type.getValueTypeReference());
        }
        if (proto == ThriftProtocolType.MAP) {
            return this.verifyElementType(type.getKeyTypeReference()) & this.verifyElementType(type.getValueTypeReference());
        }
        if (this.knownTypes.contains(type)) {
            return true;
        }
        if (this.includes.containsKey(type)) {
            this.usedIncludedTypes.add(type);
            return true;
        }
        if (this.recursive) {
            this.thriftTypes.add(type);
            return this.verifyStruct(type, true);
        }
        return false;
    }

    private boolean verifyStruct(ThriftType type, boolean quiet) {
        if (type.getProtocolType() == ThriftProtocolType.ENUM) {
            this.knownTypes.add(type);
            return true;
        }
        ThriftStructMetadata metadata = type.getStructMetadata();
        boolean ok = true;
        this.knownTypes.add(type);
        for (ThriftFieldMetadata fieldMetadata : metadata.getFields(FieldKind.THRIFT_FIELD)) {
            boolean fieldOk;
            if (!this.recursive && fieldMetadata.isTypeReferenceRecursive() || (fieldOk = this.verifyField(fieldMetadata.getThriftType()))) continue;
            ok = false;
            if (quiet) continue;
            throw new ThriftIdlGeneratorException(String.format("Unknown type %s in %s.%s", this.typeName(fieldMetadata.getThriftType()), metadata.getStructName(), fieldMetadata.getName()));
        }
        if (!ok) {
            this.knownTypes.remove(type);
        }
        return ok;
    }

    private Class<?> load(String className) {
        className = this.getFullClassName(className);
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ThriftIdlGeneratorException("Class not found: " + className);
        }
    }

    private Object convertToThrift(Class<?> clazz) {
        try {
            return this.getThriftType(clazz);
        }
        catch (MetadataErrorException e) {
            throw new ThriftIdlGeneratorException(e);
        }
    }

    private Object getThriftType(Class<?> clazz) {
        Set serviceAnnotations = ReflectionHelper.getEffectiveClassAnnotations(clazz, ThriftService.class);
        if (serviceAnnotations.isEmpty()) {
            ThriftType thriftType = this.codecManager.getCatalog().getThriftType(clazz);
            this.verboseLogger.accept("Found Thrift type: " + this.typeName(thriftType));
            return thriftType;
        }
        ThriftServiceMetadata serviceMetadata = new ThriftServiceMetadata(clazz, this.codecManager.getCatalog());
        this.verboseLogger.accept("Found Thrift service: " + clazz.getSimpleName());
        return serviceMetadata;
    }

    private String generate() {
        ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder includesBuilder = ImmutableSet.builder();
        for (ThriftType type : this.usedIncludedTypes) {
            String filename = this.includes.get(type);
            includesBuilder.add((Object)filename);
            typesBuilder.put((Object)type, (Object)Files.getNameWithoutExtension((String)filename));
        }
        this.typeRenderer = new ThriftTypeRenderer((Map<ThriftType, String>)typesBuilder.build());
        return ThriftIdlRenderer.renderThriftIdl(this.namespaces, (Set<String>)includesBuilder.build(), this.thriftTypes, this.thriftServices, this.typeRenderer);
    }

    private String typeName(ThriftType type) {
        return this.typeRenderer.toString(type);
    }

    private static MetadataErrors.Monitor createMonitor(final Consumer<String> errorLogger, final Consumer<String> warningLogger) {
        return new MetadataErrors.Monitor(){

            public void onError(MetadataErrorException e) {
                errorLogger.accept(e.getMessage());
            }

            public void onWarning(MetadataWarningException e) {
                warningLogger.accept(e.getMessage());
            }
        };
    }

    private static class SuccessAndResult<T> {
        private final boolean success;
        private final List<T> result;

        SuccessAndResult(boolean success, List<T> result) {
            this.success = success;
            this.result = ImmutableList.copyOf(result);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public List<T> getResult() {
            return this.result;
        }
    }
}

