/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.idl.generator;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.codec.ThriftProtocolType;
import com.facebook.drift.codec.metadata.ThriftEnumMetadata;
import com.facebook.drift.codec.metadata.ThriftFieldMetadata;
import com.facebook.drift.codec.metadata.ThriftMethodMetadata;
import com.facebook.drift.codec.metadata.ThriftServiceMetadata;
import com.facebook.drift.codec.metadata.ThriftStructMetadata;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.idl.generator.ThriftTypeRenderer;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
public final class ThriftIdlRenderer {
    private final ThriftTypeRenderer typeRenderer;

    private ThriftIdlRenderer(ThriftTypeRenderer typeRenderer) {
        this.typeRenderer = Objects.requireNonNull(typeRenderer, "typeRenderer is null");
    }

    public static String renderThriftIdl(Map<String, String> namespaces, Set<String> includes, List<ThriftType> thriftTypes, List<ThriftServiceMetadata> services, ThriftTypeRenderer typeRenderer) {
        List<ThriftEnumMetadata<?>> enums = thriftTypes.stream().filter(type -> type.getProtocolType() == ThriftProtocolType.ENUM).map(ThriftType::getEnumMetadata).collect(Collectors.toList());
        List<ThriftStructMetadata> structs = thriftTypes.stream().filter(type -> type.getProtocolType() == ThriftProtocolType.STRUCT).map(ThriftType::getStructMetadata).collect(Collectors.toList());
        return new ThriftIdlRenderer(typeRenderer).render(namespaces, includes, enums, structs, services);
    }

    private String render(Map<String, String> namespaces, Set<String> includes, List<ThriftEnumMetadata<?>> enums, List<ThriftStructMetadata> structs, List<ThriftServiceMetadata> services) {
        return Joiner.on((String)"\n").skipNulls().join((Object)ThriftIdlRenderer.renderNamespaces(namespaces), (Object)ThriftIdlRenderer.renderIncludes(includes), new Object[]{ThriftIdlRenderer.renderEnums(enums), this.renderStructs(structs), this.renderServices(services)});
    }

    private static String renderNamespaces(Map<String, String> namespaces) {
        if (namespaces.isEmpty()) {
            return null;
        }
        return namespaces.entrySet().stream().map(entry -> String.format("namespace %s %s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n")) + "\n";
    }

    private static String renderIncludes(Set<String> includes) {
        if (includes.isEmpty()) {
            return null;
        }
        return includes.stream().map(include -> String.format("include \"%s\"", include)).collect(Collectors.joining("\n")) + "\n";
    }

    private static String renderEnums(List<ThriftEnumMetadata<?>> enums) {
        return Strings.emptyToNull((String)enums.stream().map(ThriftIdlRenderer::renderEnum).collect(Collectors.joining("\n")));
    }

    private static String renderEnum(ThriftEnumMetadata<?> metadata) {
        return ThriftIdlRenderer.documentation((List<String>)metadata.getDocumentation(), "") + String.format("enum %s {\n%s}\n", metadata.getEnumName(), ThriftIdlRenderer.renderEnumElements(metadata));
    }

    private static <T extends Enum<T>> String renderEnumElements(ThriftEnumMetadata<T> metadata) {
        if (metadata.getElementsDocumentation().values().stream().allMatch(Collection::isEmpty) && metadata.getByEnumConstant() == null) {
            return "  " + metadata.getElementsDocumentation().keySet().stream().map(Enum::name).collect(Collectors.joining(", ")) + "\n";
        }
        LineSeparator separator = new LineSeparator();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : metadata.getElementsDocumentation().entrySet()) {
            builder.append(separator.getAndUpdate(!((ImmutableList)entry.getValue()).isEmpty())).append(ThriftIdlRenderer.documentation((List)entry.getValue(), "  ")).append("  ").append(((Enum)entry.getKey()).name());
            if (metadata.getByEnumConstant() != null) {
                builder.append(" = ").append(metadata.getByEnumConstant().get(entry.getKey()));
            }
            builder.append(";\n");
        }
        return builder.toString();
    }

    private String renderStructs(List<ThriftStructMetadata> structs) {
        return Strings.emptyToNull((String)structs.stream().map(this::renderStruct).collect(Collectors.joining("\n")));
    }

    private String renderStruct(ThriftStructMetadata struct) {
        StringBuilder builder = new StringBuilder().append(ThriftIdlRenderer.documentation((List<String>)struct.getDocumentation(), "")).append(String.format("%s %s {\n", ThriftIdlRenderer.structKind(struct), struct.getStructName()));
        LineSeparator separator = new LineSeparator();
        for (ThriftFieldMetadata field : struct.getFields()) {
            if (field.isInternal()) continue;
            builder.append(separator.getAndUpdate(!field.getDocumentation().isEmpty())).append(ThriftIdlRenderer.documentation((List<String>)field.getDocumentation(), "  ")).append(String.format("  %s: %s%s %s;\n", field.getId(), ThriftIdlRenderer.requiredness(field.getRequiredness()), this.typeName(field.getThriftType()), field.getName()));
        }
        return builder.append("}\n").toString();
    }

    private static String structKind(ThriftStructMetadata struct) {
        if (struct.isStruct()) {
            return "struct";
        }
        if (struct.isException()) {
            return "exception";
        }
        if (struct.isUnion()) {
            return "union";
        }
        throw new IllegalArgumentException("Unknown type: " + struct);
    }

    private static String requiredness(ThriftField.Requiredness requiredness) {
        switch (requiredness) {
            case REQUIRED: {
                return "required ";
            }
            case OPTIONAL: {
                return "optional ";
            }
        }
        return "";
    }

    private String renderServices(List<ThriftServiceMetadata> services) {
        return Strings.emptyToNull((String)services.stream().map(this::renderService).collect(Collectors.joining("\n")));
    }

    private String renderService(ThriftServiceMetadata service) {
        return ThriftIdlRenderer.documentation(service.getDocumentation(), "") + String.format("service %s {\n", service.getIdlName()) + service.getMethods().stream().map(this::renderMethod).collect(Collectors.joining("\n")) + "}\n";
    }

    private String renderMethod(ThriftMethodMetadata method) {
        StringBuilder builder = new StringBuilder().append(ThriftIdlRenderer.documentation(method.getDocumentation(), "  "));
        String methodStart = String.format("  %s%s %s(", method.getOneway() ? "oneway " : "", this.typeName(method.getReturnType()), method.getName());
        List<String> parameters = method.getParameters().stream().map(parameter -> String.format("%s: %s %s", parameter.getId(), this.typeName(parameter.getThriftType()), parameter.getName())).collect(Collectors.toList());
        builder.append(ThriftIdlRenderer.renderParameters(methodStart, parameters));
        if (!method.getExceptions().isEmpty()) {
            List<String> exceptions = Streams.mapWithIndex(method.getExceptions().entrySet().stream(), (entry, index) -> String.format("%s: %s ex%s", entry.getKey(), this.typeName((ThriftType)entry.getValue()), index + 1L)).collect(Collectors.toList());
            builder.append("\n").append(ThriftIdlRenderer.renderParameters("    throws (", exceptions));
        }
        return builder.append(";\n").toString();
    }

    private static String renderParameters(String start, List<String> parameters) {
        String joined = Joiner.on((String)", ").join(parameters) + ")";
        if (start.length() + joined.length() <= 80) {
            return start + joined;
        }
        return start + "\n      " + Joiner.on((String)",\n      ").join(parameters) + ")";
    }

    private String typeName(ThriftType type) {
        return this.typeRenderer.toString(type);
    }

    private static String documentation(List<String> documentation, String indent) {
        if (documentation.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder().append(indent).append("/**\n");
        for (String line : documentation) {
            builder.append(indent).append(" *");
            if (!line.isEmpty()) {
                builder.append(" ").append(line);
            }
            builder.append("\n");
        }
        return builder.append(indent).append(" */\n").toString();
    }

    private static class LineSeparator {
        private boolean first = true;
        private boolean wasDocumented;

        private LineSeparator() {
        }

        public String getAndUpdate(boolean documented) {
            boolean needed = !this.first && (this.wasDocumented || documented);
            this.first = false;
            this.wasDocumented = documented;
            return needed ? "\n" : "";
        }
    }
}

