/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.maven;

import com.facebook.drift.idl.generator.ThriftIdlGenerator;
import com.facebook.drift.idl.generator.ThriftIdlGeneratorConfig;
import com.facebook.drift.idl.generator.ThriftIdlGeneratorException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-thrift-idl", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class IdlGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true)
    private List<String> classes;
    @Parameter
    private String defaultPackage;
    @Parameter(required=true)
    private File outputFile;
    @Parameter
    private Map<String, String> namespaces;
    @Parameter
    private Map<String, String> includes;
    @Parameter(required=true)
    private boolean recursive;
    @Parameter
    private boolean quiet;

    public void execute() throws MojoExecutionException {
        String idl;
        ClassLoader classLoader = this.createClassLoaderFromCompileTimeDependencies();
        ThriftIdlGeneratorConfig config = ThriftIdlGeneratorConfig.builder().defaultPackage(this.defaultPackage).namespaces(this.namespaces).includes(this.includes).recursive(this.recursive).errorLogger(message -> this.getLog().error((CharSequence)message)).warningLogger(message -> this.getLog().warn((CharSequence)message)).verboseLogger(this::verbose).build();
        try {
            idl = new ThriftIdlGenerator(config, classLoader).generate(this.classes);
        }
        catch (ThriftIdlGeneratorException e) {
            throw new MojoExecutionException("Failed to generate Thrift IDL: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.outputFile.getParentFile() != null) {
            IdlGeneratorMojo.mkdirs(this.outputFile.getParentFile());
        }
        IdlGeneratorMojo.writeFile(this.outputFile, idl.getBytes(StandardCharsets.UTF_8));
        this.verbose("Wrote Thrift IDL to " + this.outputFile);
    }

    private void verbose(String message) {
        if (this.quiet) {
            this.getLog().debug((CharSequence)message);
        } else {
            this.getLog().info((CharSequence)message);
        }
    }

    private ClassLoader createClassLoaderFromCompileTimeDependencies() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(IdlGeneratorMojo.fileToUrl(this.classesDirectory));
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getFile() == null) continue;
            urls.add(IdlGeneratorMojo.fileToUrl(artifact.getFile()));
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    private static URL fileToUrl(File file) throws MojoExecutionException {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to create URL for file: " + file, (Exception)e);
        }
    }

    private static void writeFile(File file, byte[] bytes) throws MojoExecutionException {
        try {
            Files.write(file.toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write file: " + file, (Exception)e);
        }
    }

    private static void mkdirs(File file) throws MojoExecutionException {
        try {
            Files.createDirectories(file.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directory: " + file, (Exception)e);
        }
    }
}

