/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.apache.client;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.google.common.net.HostAndPort;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class ApacheThriftClientConfig {
    private Transport transport = Transport.FRAMED;
    private Protocol protocol = Protocol.BINARY;
    private DataSize maxFrameSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private Duration connectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private Duration requestTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private HostAndPort socksProxy;
    private boolean sslEnabled;
    private File trustCertificate;
    private File key;
    private String keyPassword;

    @NotNull
    public Transport getTransport() {
        return this.transport;
    }

    @Config(value="thrift.client.transport")
    public ApacheThriftClientConfig setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    @NotNull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Config(value="thrift.client.protocol")
    public ApacheThriftClientConfig setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="thrift.client.connect-timeout")
    public ApacheThriftClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="thrift.client.request-timeout")
    public ApacheThriftClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="thrift.client.socks-proxy")
    public ApacheThriftClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    @MaxDataSize(value="1023MB")
    public DataSize getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Config(value="thrift.client.max-frame-size")
    public ApacheThriftClientConfig setMaxFrameSize(DataSize maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    @Config(value="thrift.client.ssl.enabled")
    public ApacheThriftClientConfig setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    public File getTrustCertificate() {
        return this.trustCertificate;
    }

    @Config(value="thrift.client.ssl.trust-certificate")
    public ApacheThriftClientConfig setTrustCertificate(File trustCertificate) {
        this.trustCertificate = trustCertificate;
        return this;
    }

    public File getKey() {
        return this.key;
    }

    @Config(value="thrift.client.ssl.key")
    public ApacheThriftClientConfig setKey(File key) {
        this.key = key;
        return this;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    @ConfigSecuritySensitive
    @Config(value="thrift.client.ssl.key-password")
    public ApacheThriftClientConfig setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public static enum Protocol {
        BINARY,
        COMPACT;

    }

    public static enum Transport {
        UNFRAMED,
        FRAMED,
        HEADER;

    }
}

