/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.apache.client;

import com.facebook.drift.TException;
import com.facebook.drift.protocol.TField;
import com.facebook.drift.protocol.TMap;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TStruct;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;

public class ThriftToDriftProtocolWriter
implements TProtocolWriter {
    private final TProtocol protocol;

    public ThriftToDriftProtocolWriter(TProtocol protocol) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
    }

    public void writeMessageBegin(TMessage message) throws TException {
        try {
            this.protocol.writeMessageBegin(new org.apache.thrift.protocol.TMessage(message.getName(), message.getType(), message.getSequenceId()));
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeMessageEnd() throws TException {
        try {
            this.protocol.writeMessageEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeStructBegin(TStruct struct) throws TException {
        try {
            this.protocol.writeStructBegin(new org.apache.thrift.protocol.TStruct(struct.getName()));
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeStructEnd() throws TException {
        try {
            this.protocol.writeStructEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeFieldBegin(TField field) throws TException {
        try {
            this.protocol.writeFieldBegin(new org.apache.thrift.protocol.TField(field.getName(), field.getType(), field.getId()));
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeFieldEnd() throws TException {
        try {
            this.protocol.writeFieldEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeFieldStop() throws TException {
        try {
            this.protocol.writeFieldStop();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeMapBegin(TMap map) throws TException {
        try {
            this.protocol.writeMapBegin(new org.apache.thrift.protocol.TMap(map.getKeyType(), map.getValueType(), map.getSize()));
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeMapEnd() throws TException {
        try {
            this.protocol.writeMapEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeListBegin(com.facebook.drift.protocol.TList list) throws TException {
        try {
            this.protocol.writeListBegin(new TList(list.getType(), list.getSize()));
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeListEnd() throws TException {
        try {
            this.protocol.writeListEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeSetBegin(com.facebook.drift.protocol.TSet set) throws TException {
        try {
            this.protocol.writeSetBegin(new TSet(set.getType(), set.getSize()));
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeSetEnd() throws TException {
        try {
            this.protocol.writeSetEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeBool(boolean value) throws TException {
        try {
            this.protocol.writeBool(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeByte(byte value) throws TException {
        try {
            this.protocol.writeByte(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeI16(short value) throws TException {
        try {
            this.protocol.writeI16(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeI32(int value) throws TException {
        try {
            this.protocol.writeI32(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeI64(long value) throws TException {
        try {
            this.protocol.writeI64(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeFloat(float value) throws TException {
        throw new TException("float is not supported");
    }

    public void writeDouble(double value) throws TException {
        try {
            this.protocol.writeDouble(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeString(String value) throws TException {
        try {
            this.protocol.writeString(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void writeBinary(ByteBuffer value) throws TException {
        try {
            this.protocol.writeBinary(value);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }
}

