/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.apache.client;

import com.facebook.drift.TApplicationException;
import com.facebook.drift.TException;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.ProtocolReader;
import com.facebook.drift.codec.internal.ProtocolWriter;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.MethodMetadata;
import com.facebook.drift.transport.ParameterMetadata;
import com.facebook.drift.transport.apache.client.ThriftToDriftProtocolReader;
import com.facebook.drift.transport.apache.client.ThriftToDriftProtocolWriter;
import com.facebook.drift.transport.client.Address;
import com.facebook.drift.transport.client.ConnectionFailedException;
import com.facebook.drift.transport.client.DriftApplicationException;
import com.facebook.drift.transport.client.InvokeRequest;
import com.facebook.drift.transport.client.MethodInvoker;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.airlift.units.Duration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ApacheThriftMethodInvoker
implements MethodInvoker {
    private static final int SEQUENCE_ID = 77;
    private final ListeningExecutorService executorService;
    private final ListeningScheduledExecutorService delayService;
    private final TTransportFactory transportFactory;
    private final TProtocolFactory protocolFactory;
    private final int connectTimeoutMillis;
    private final int requestTimeoutMillis;
    private final Optional<HostAndPort> socksProxy;
    private final Optional<SSLContext> sslContext;

    public ApacheThriftMethodInvoker(ListeningExecutorService executorService, ListeningScheduledExecutorService delayService, TTransportFactory transportFactory, TProtocolFactory protocolFactory, Duration connectTimeout, Duration requestTimeout, Optional<HostAndPort> socksProxy, Optional<SSLContext> sslContext) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.delayService = Objects.requireNonNull(delayService, "delayService is null");
        this.transportFactory = Objects.requireNonNull(transportFactory, "transportFactory is null");
        this.protocolFactory = Objects.requireNonNull(protocolFactory, "protocolFactory is null");
        this.connectTimeoutMillis = Ints.saturatedCast((long)Objects.requireNonNull(connectTimeout, "connectTimeout is null").toMillis());
        this.requestTimeoutMillis = Ints.saturatedCast((long)Objects.requireNonNull(requestTimeout, "requestTimeout is null").toMillis());
        this.socksProxy = Objects.requireNonNull(socksProxy, "socksProxy is null");
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext is null");
    }

    public ListenableFuture<Object> invoke(InvokeRequest request) {
        try {
            return this.executorService.submit(() -> this.invokeSynchronous(request));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)ApacheThriftMethodInvoker.toDriftException(e));
        }
    }

    public ListenableFuture<?> delay(Duration duration) {
        try {
            return this.delayService.schedule(() -> null, duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)ApacheThriftMethodInvoker.toDriftException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeSynchronous(InvokeRequest request) throws Exception {
        Address address = request.getAddress();
        TSocket socket = this.createTSocket(address.getHostAndPort());
        if (!socket.isOpen()) {
            try {
                socket.open();
            }
            catch (org.apache.thrift.transport.TTransportException e) {
                throw new ConnectionFailedException(address, (Throwable)e);
            }
        }
        try {
            TTransport transport = this.transportFactory.getTransport((TTransport)socket);
            TProtocol protocol = this.protocolFactory.getProtocol(transport);
            ApacheThriftMethodInvoker.writeRequest(request.getMethod(), request.getParameters(), protocol);
            Object object = ApacheThriftMethodInvoker.readResponse(request.getMethod(), protocol);
            return object;
        }
        finally {
            socket.close();
        }
    }

    private TSocket createTSocket(HostAndPort address) throws TTransportException {
        Proxy proxy = this.socksProxy.map(socksAddress -> new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved(socksAddress.getHost(), socksAddress.getPort()))).orElse(Proxy.NO_PROXY);
        Socket socket = new Socket(proxy);
        try {
            this.setSocketProperties(socket);
            socket.connect(new InetSocketAddress(address.getHost(), address.getPort()), Ints.saturatedCast((long)this.connectTimeoutMillis));
            if (this.sslContext.isPresent()) {
                SSLContext sslContext = this.sslContext.get();
                HostAndPort sslConnectAddress = this.socksProxy.orElse(address);
                socket = sslContext.getSocketFactory().createSocket(socket, sslConnectAddress.getHost(), sslConnectAddress.getPort(), true);
                this.setSocketProperties(socket);
            }
            return new TSocket(socket);
        }
        catch (Throwable t) {
            try {
                socket.close();
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new TTransportException(t);
        }
    }

    private void setSocketProperties(Socket socket) throws SocketException {
        socket.setSoLinger(false, 0);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setSoTimeout(Ints.saturatedCast((long)this.requestTimeoutMillis));
    }

    private static void writeRequest(MethodMetadata method, List<Object> parameters, TProtocol protocol) throws Exception {
        TMessage requestMessage = new TMessage(method.getName(), 1, 77);
        protocol.writeMessageBegin(requestMessage);
        ProtocolWriter writer = new ProtocolWriter((TProtocolWriter)new ThriftToDriftProtocolWriter(protocol));
        writer.writeStructBegin(method.getName() + "_args");
        for (int i = 0; i < parameters.size(); ++i) {
            Object value = parameters.get(i);
            ParameterMetadata parameter = (ParameterMetadata)method.getParameters().get(i);
            writer.writeField(parameter.getName(), parameter.getFieldId(), parameter.getCodec(), value);
        }
        writer.writeStructEnd();
        protocol.writeMessageEnd();
        protocol.getTransport().flush();
    }

    private static Object readResponse(MethodMetadata method, TProtocol responseProtocol) throws TException, org.apache.thrift.TException {
        TMessage message = responseProtocol.readMessageBegin();
        if (message.type == 3) {
            org.apache.thrift.TApplicationException exception = org.apache.thrift.TApplicationException.readFrom((TProtocol)responseProtocol);
            responseProtocol.readMessageEnd();
            throw exception;
        }
        if (message.type != 2) {
            throw new TApplicationException(TApplicationException.Type.INVALID_MESSAGE_TYPE, String.format("Received invalid message type %s from server", message.type));
        }
        if (!message.name.equals(method.getName())) {
            throw new TApplicationException(TApplicationException.Type.WRONG_METHOD_NAME, String.format("Wrong method name in reply: expected %s but received %s", method.getName(), message.name));
        }
        if (message.seqid != 77) {
            throw new TApplicationException(TApplicationException.Type.BAD_SEQUENCE_ID, String.format("%s failed: out of sequence response", method.getName()));
        }
        ProtocolReader reader = new ProtocolReader((TProtocolReader)new ThriftToDriftProtocolReader(responseProtocol));
        reader.readStructBegin();
        Object results = null;
        Exception exception = null;
        try {
            while (reader.nextField()) {
                if (reader.getFieldId() == 0) {
                    results = reader.readField(method.getResultCodec());
                    continue;
                }
                ThriftCodec exceptionCodec = (ThriftCodec)method.getExceptionCodecs().get(reader.getFieldId());
                if (exceptionCodec != null) {
                    exception = (Exception)reader.readField(exceptionCodec);
                    continue;
                }
                reader.skipFieldData();
            }
            reader.readStructEnd();
            responseProtocol.readMessageEnd();
        }
        catch (TException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
        if (exception != null) {
            throw new DriftApplicationException(exception);
        }
        if (method.getResultCodec().getType() == ThriftType.VOID) {
            return null;
        }
        if (results == null) {
            throw new TApplicationException(TApplicationException.Type.MISSING_RESULT, String.format("%s failed: unknown result", method.getName()));
        }
        return results;
    }

    private static Exception toDriftException(Exception e) {
        if (e instanceof org.apache.thrift.TApplicationException) {
            org.apache.thrift.TApplicationException tae = (org.apache.thrift.TApplicationException)e;
            return new TApplicationException(tae.getType(), tae.getMessage());
        }
        if (e instanceof org.apache.thrift.transport.TTransportException) {
            return new TTransportException((Throwable)e);
        }
        if (e instanceof TProtocolException) {
            return new com.facebook.drift.protocol.TProtocolException((Throwable)e);
        }
        if (e instanceof org.apache.thrift.TException) {
            return new TException((Throwable)e);
        }
        return e;
    }
}

