/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.apache.client;

import com.facebook.drift.TException;
import com.facebook.drift.protocol.TField;
import com.facebook.drift.protocol.TMap;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TStruct;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;

public class ThriftToDriftProtocolReader
implements TProtocolReader {
    private final TProtocol protocol;

    public ThriftToDriftProtocolReader(TProtocol protocol) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
    }

    public TMessage readMessageBegin() throws TException {
        try {
            org.apache.thrift.protocol.TMessage message = this.protocol.readMessageBegin();
            return new TMessage(message.name, message.type, message.seqid);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void readMessageEnd() throws TException {
        try {
            this.protocol.readMessageEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public TStruct readStructBegin() throws TException {
        try {
            org.apache.thrift.protocol.TStruct struct = this.protocol.readStructBegin();
            return new TStruct(struct.name);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void readStructEnd() throws TException {
        try {
            this.protocol.readStructEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public TField readFieldBegin() throws TException {
        try {
            org.apache.thrift.protocol.TField field = this.protocol.readFieldBegin();
            return new TField(field.name, field.type, field.id);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void readFieldEnd() throws TException {
        try {
            this.protocol.readFieldEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public TMap readMapBegin() throws TException {
        try {
            org.apache.thrift.protocol.TMap map = this.protocol.readMapBegin();
            return new TMap(map.keyType, map.valueType, map.size);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void readMapEnd() throws TException {
        try {
            this.protocol.readMapEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public com.facebook.drift.protocol.TList readListBegin() throws TException {
        try {
            TList list = this.protocol.readListBegin();
            return new com.facebook.drift.protocol.TList(list.elemType, list.size);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void readListEnd() throws TException {
        try {
            this.protocol.readListEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public com.facebook.drift.protocol.TSet readSetBegin() throws TException {
        try {
            TSet set = this.protocol.readSetBegin();
            return new com.facebook.drift.protocol.TSet(set.elemType, set.size);
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public void readSetEnd() throws TException {
        try {
            this.protocol.readSetEnd();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public boolean readBool() throws TException {
        try {
            return this.protocol.readBool();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public byte readByte() throws TException {
        try {
            return this.protocol.readByte();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public short readI16() throws TException {
        try {
            return this.protocol.readI16();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public int readI32() throws TException {
        try {
            return this.protocol.readI32();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public long readI64() throws TException {
        try {
            return this.protocol.readI64();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public float readFloat() throws TException {
        throw new TException("float is not supported");
    }

    public double readDouble() throws TException {
        try {
            return this.protocol.readDouble();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public String readString() throws TException {
        try {
            return this.protocol.readString();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public ByteBuffer readBinary() throws TException {
        try {
            return this.protocol.readBinary();
        }
        catch (org.apache.thrift.TException e) {
            throw new TException((Throwable)e);
        }
    }

    public int readBinary(byte[] buf, int offset) {
        throw new UnsupportedOperationException();
    }
}

