/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.apache.client;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.security.pem.PemReader;
import com.facebook.drift.transport.apache.client.ApacheThriftClientConfig;
import com.facebook.drift.transport.apache.client.ApacheThriftConnectionFactoryConfig;
import com.facebook.drift.transport.apache.client.ApacheThriftMethodInvoker;
import com.facebook.drift.transport.client.MethodInvoker;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ApacheThriftMethodInvokerFactory<I>
implements MethodInvokerFactory<I>,
Closeable {
    private final Function<I, ApacheThriftClientConfig> clientConfigurationProvider;
    private final ListeningExecutorService executorService;
    private final ListeningScheduledExecutorService delayService;
    private final HostAndPort defaultSocksProxy;

    public static ApacheThriftMethodInvokerFactory<?> createStaticApacheThriftMethodInvokerFactory(ApacheThriftClientConfig clientConfig) {
        return ApacheThriftMethodInvokerFactory.createStaticApacheThriftMethodInvokerFactory(clientConfig, new ApacheThriftConnectionFactoryConfig());
    }

    public static ApacheThriftMethodInvokerFactory<?> createStaticApacheThriftMethodInvokerFactory(ApacheThriftClientConfig clientConfig, ApacheThriftConnectionFactoryConfig factoryConfig) {
        Objects.requireNonNull(clientConfig, "clientConfig is null");
        return new ApacheThriftMethodInvokerFactory<Object>(factoryConfig, clientIdentity -> clientConfig);
    }

    @Inject
    public ApacheThriftMethodInvokerFactory(ApacheThriftConnectionFactoryConfig factoryConfig, Function<I, ApacheThriftClientConfig> clientConfigurationProvider) {
        Objects.requireNonNull(factoryConfig, "factoryConfig is null");
        ThreadFactory threadFactory = Threads.daemonThreadsNamed((String)"drift-client-%s");
        if (factoryConfig.getThreadCount() == null) {
            this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(threadFactory));
            this.delayService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"drift-client-delay-%s")));
        } else {
            this.delayService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(factoryConfig.getThreadCount(), threadFactory));
            this.executorService = this.delayService;
        }
        this.clientConfigurationProvider = Objects.requireNonNull(clientConfigurationProvider, "clientConfigurationProvider is null");
        this.defaultSocksProxy = factoryConfig.getSocksProxy();
    }

    public MethodInvoker createMethodInvoker(I clientIdentity) {
        TBinaryProtocol.Factory protocolFactory;
        TTransportFactory transportFactory;
        ApacheThriftClientConfig config = this.clientConfigurationProvider.apply(clientIdentity);
        if (config.getSocksProxy() == null) {
            config.setSocksProxy(this.defaultSocksProxy);
        }
        switch (config.getTransport()) {
            case UNFRAMED: {
                transportFactory = new TTransportFactory();
                break;
            }
            case FRAMED: {
                transportFactory = new TFramedTransport.Factory(Math.toIntExact(config.getMaxFrameSize().toBytes()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown transport: " + (Object)((Object)config.getTransport()));
            }
        }
        switch (config.getProtocol()) {
            case BINARY: {
                protocolFactory = new TBinaryProtocol.Factory();
                break;
            }
            case COMPACT: {
                protocolFactory = new TCompactProtocol.Factory();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown protocol: " + (Object)((Object)config.getProtocol()));
            }
        }
        Optional<SSLContext> sslContext = Optional.empty();
        if (config.isSslEnabled()) {
            sslContext = Optional.of(ApacheThriftMethodInvokerFactory.createSslContext(config));
        }
        return new ApacheThriftMethodInvoker(this.executorService, this.delayService, transportFactory, (TProtocolFactory)protocolFactory, config.getConnectTimeout(), config.getRequestTimeout(), Optional.ofNullable(config.getSocksProxy()), sslContext);
    }

    private static SSLContext createSslContext(ApacheThriftClientConfig config) {
        try {
            KeyStore trustStore = PemReader.loadTrustStore((File)config.getTrustCertificate());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            KeyManager[] keyManagers = null;
            if (config.getKey() != null) {
                Optional<String> keyPassword = Optional.ofNullable(config.getKeyPassword());
                KeyStore keyStore = PemReader.loadKeyStore((File)config.getTrustCertificate(), (File)config.getKey(), keyPassword);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, new char[0]);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Unable to load SSL keys", e);
        }
    }

    @Override
    @PreDestroy
    public void close() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)5L, (TimeUnit)TimeUnit.MINUTES);
    }
}

