/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.drift.transport.client.DriftClientConfig;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.client.DriftNettyConnectionFactoryConfig;
import com.facebook.drift.transport.netty.client.DriftNettyMethodInvokerFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import io.airlift.configuration.ConfigBinder;
import io.netty.buffer.ByteBufAllocator;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;

public class DriftNettyClientModule
implements Module {
    private final ByteBufAllocator allocator;

    public DriftNettyClientModule() {
        this(ByteBufAllocator.DEFAULT);
    }

    @VisibleForTesting
    public DriftNettyClientModule(ByteBufAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator, "allocator is null");
    }

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(DriftNettyConnectionFactoryConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigurationBindingListener((binding, configBinder) -> {
            if (binding.getConfigClass().equals(DriftClientConfig.class)) {
                configBinder.bindConfig(DriftNettyClientConfig.class, binding.getKey().getAnnotation(), (String)binding.getPrefix().orElse(null));
            }
        });
        binder.bind(ByteBufAllocator.class).toInstance((Object)this.allocator);
        binder.bind((TypeLiteral)new TypeLiteral<MethodInvokerFactory<Annotation>>(){}).toProvider(MethodInvokerFactoryProvider.class).in(Scopes.SINGLETON);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static class MethodInvokerFactoryProvider
    implements Provider<MethodInvokerFactory<Annotation>> {
        private Injector injector;
        private DriftNettyMethodInvokerFactory<Annotation> factory;

        private MethodInvokerFactoryProvider() {
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public MethodInvokerFactory<Annotation> get() {
            Preconditions.checkState((this.factory == null ? 1 : 0) != 0, (Object)"factory already created");
            this.factory = new DriftNettyMethodInvokerFactory<Annotation>((DriftNettyConnectionFactoryConfig)this.injector.getInstance(DriftNettyConnectionFactoryConfig.class), annotation -> (DriftNettyClientConfig)this.injector.getInstance(Key.get(DriftNettyClientConfig.class, (Annotation)annotation)), (ByteBufAllocator)this.injector.getInstance(ByteBufAllocator.class));
            return this.factory;
        }

        @PreDestroy
        public void destroy() {
            this.factory.close();
        }
    }
}

