/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TTransportException;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.ThriftFrame;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferInputTransport;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import java.util.Objects;

public class SimpleFrameCodec
extends ChannelDuplexHandler {
    private final Transport transport;
    private final Protocol protocol;
    private final boolean assumeClientsSupportOutOfOrderResponses;

    public SimpleFrameCodec(Transport transport, Protocol protocol, boolean assumeClientsSupportOutOfOrderResponses) {
        this.transport = Objects.requireNonNull(transport, "transport is null");
        this.protocol = Objects.requireNonNull(protocol, "protocol is null");
        this.assumeClientsSupportOutOfOrderResponses = assumeClientsSupportOutOfOrderResponses;
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        ByteBuf buffer;
        if (message instanceof ByteBuf && (buffer = (ByteBuf)message).isReadable()) {
            context.fireChannelRead((Object)new ThriftFrame(this.extractResponseSequenceId(buffer.retain()), buffer, (Map<String, String>)ImmutableMap.of(), this.transport, this.protocol, this.assumeClientsSupportOutOfOrderResponses));
            return;
        }
        context.fireChannelRead(message);
    }

    private int extractResponseSequenceId(ByteBuf buffer) throws TTransportException {
        TChannelBufferInputTransport inputTransport = new TChannelBufferInputTransport(buffer.duplicate());
        try {
            TMessage message = this.protocol.createProtocol(inputTransport).readMessageBegin();
            int n = message.getSequenceId();
            return n;
        }
        catch (Throwable e) {
            throw new TTransportException("Could not find sequenceId in Thrift message", e);
        }
        finally {
            inputTransport.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) {
        if (message instanceof ThriftFrame) {
            ThriftFrame thriftFrame = (ThriftFrame)message;
            try {
                message = thriftFrame.getMessage();
            }
            finally {
                thriftFrame.release();
            }
        }
        context.write(message, promise);
    }
}

