/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.TException;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.transport.netty.codec.FrameInfo;
import com.facebook.drift.transport.netty.codec.FrameInfoDecoder;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.TChannelBufferInputTransport;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;

public class SimpleFrameInfoDecoder
implements FrameInfoDecoder {
    private final Transport transportType;
    private final Protocol protocolType;
    private final boolean assumeClientsSupportOutOfOrderResponses;

    public SimpleFrameInfoDecoder(Transport transportType, Protocol protocolType, boolean assumeClientsSupportOutOfOrderResponses) {
        this.transportType = Objects.requireNonNull(transportType, "transportType is null");
        this.protocolType = Objects.requireNonNull(protocolType, "protocolType is null");
        this.assumeClientsSupportOutOfOrderResponses = assumeClientsSupportOutOfOrderResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<FrameInfo> tryDecodeFrameInfo(ByteBuf buffer) {
        TChannelBufferInputTransport transport = new TChannelBufferInputTransport(buffer.retainedDuplicate());
        try {
            TMessage message;
            TProtocol protocol = this.protocolType.createProtocol(transport);
            try {
                message = protocol.readMessageBegin();
            }
            catch (TException | RuntimeException e) {
                Optional<FrameInfo> optional = Optional.empty();
                transport.release();
                return optional;
            }
            Optional<FrameInfo> optional = Optional.of(new FrameInfo(message.getName(), message.getType(), message.getSequenceId(), this.transportType, this.protocolType, this.assumeClientsSupportOutOfOrderResponses));
            return optional;
        }
        finally {
            transport.release();
        }
    }
}

