/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.codec;

import com.facebook.drift.transport.netty.codec.FrameInfo;
import com.facebook.drift.transport.netty.codec.FrameInfoDecoder;
import com.facebook.drift.transport.netty.codec.FrameTooLargeException;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class ThriftFramedDecoder
extends ByteToMessageDecoder {
    private final FrameInfoDecoder frameInfoDecoder;
    private final int maxFrameSizeInBytes;
    private Optional<FrameInfo> tooLongFrameInfo = Optional.empty();
    private long tooLongFrameSizeInBytes;
    private long bytesToDiscard;

    public ThriftFramedDecoder(FrameInfoDecoder frameInfoDecoder, int maxFrameSizeInBytes) {
        this.frameInfoDecoder = Objects.requireNonNull(frameInfoDecoder, "sequenceIdDecoder is null");
        Preconditions.checkArgument((maxFrameSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"maxFrameSizeInBytes");
        this.maxFrameSizeInBytes = maxFrameSizeInBytes;
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> output) {
        this.decode(buffer).ifPresent(output::add);
    }

    private Optional<ByteBuf> decode(ByteBuf buffer) {
        if (this.bytesToDiscard > 0L) {
            this.discardTooLongFrame(buffer);
            return Optional.empty();
        }
        int initialReaderIndex = buffer.readerIndex();
        if (buffer.readableBytes() < 4) {
            return Optional.empty();
        }
        long frameSizeInBytes = buffer.readUnsignedInt();
        if (frameSizeInBytes > (long)this.maxFrameSizeInBytes) {
            Optional<FrameInfo> frameInfo = this.frameInfoDecoder.tryDecodeFrameInfo(buffer);
            if (frameInfo.isPresent()) {
                this.tooLongFrameInfo = frameInfo;
                this.tooLongFrameSizeInBytes = frameSizeInBytes;
                this.bytesToDiscard = frameSizeInBytes;
                this.discardTooLongFrame(buffer);
                return Optional.empty();
            }
            if (buffer.readableBytes() >= this.maxFrameSizeInBytes) {
                this.tooLongFrameInfo = Optional.empty();
                this.tooLongFrameSizeInBytes = frameSizeInBytes;
                this.bytesToDiscard = frameSizeInBytes;
                this.discardTooLongFrame(buffer);
                return Optional.empty();
            }
            buffer.readerIndex(initialReaderIndex);
            return Optional.empty();
        }
        if ((long)buffer.readableBytes() >= frameSizeInBytes) {
            ByteBuf frame = buffer.retainedSlice(buffer.readerIndex(), Math.toIntExact(frameSizeInBytes));
            buffer.readerIndex(buffer.readerIndex() + Math.toIntExact(frameSizeInBytes));
            return Optional.of(frame);
        }
        buffer.readerIndex(initialReaderIndex);
        return Optional.empty();
    }

    private void discardTooLongFrame(ByteBuf buffer) {
        int bytesToSkip = Math.toIntExact(Math.min(this.bytesToDiscard, (long)buffer.readableBytes()));
        buffer.skipBytes(bytesToSkip);
        this.bytesToDiscard -= (long)bytesToSkip;
        if (this.bytesToDiscard == 0L) {
            FrameTooLargeException exception = new FrameTooLargeException(this.tooLongFrameInfo, this.tooLongFrameSizeInBytes, this.maxFrameSizeInBytes);
            this.tooLongFrameInfo = Optional.empty();
            this.tooLongFrameSizeInBytes = 0L;
            throw exception;
        }
    }
}

