/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class DriftNettyServerConfig {
    private static final int DEFAULT_WORKER_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private int port;
    private int acceptBacklog = 1024;
    private int ioThreadCount = 3;
    private int workerThreadCount = DEFAULT_WORKER_THREAD_COUNT;
    private DataSize maxFrameSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private Duration requestTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration sslContextRefreshTime = new Duration(1.0, TimeUnit.MINUTES);
    private boolean allowPlaintext = true;
    private boolean sslEnabled;
    private List<String> ciphers = ImmutableList.of();
    private File trustCertificate;
    private File key;
    private String keyPassword;
    private long sessionCacheSize = 10000L;
    private Duration sessionTimeout = new Duration(1.0, TimeUnit.DAYS);
    private boolean assumeClientsSupportOutOfOrderResponses = true;

    @Min(value=0L)
    @Max(value=65535L)
    public int getPort() {
        return this.port;
    }

    @Config(value="thrift.server.port")
    public DriftNettyServerConfig setPort(int port) {
        this.port = port;
        return this;
    }

    @Min(value=0L)
    public int getAcceptBacklog() {
        return this.acceptBacklog;
    }

    @Config(value="thrift.server.accept-backlog")
    public DriftNettyServerConfig setAcceptBacklog(int acceptBacklog) {
        this.acceptBacklog = acceptBacklog;
        return this;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    @Config(value="thrift.server.io-thread-count")
    public DriftNettyServerConfig setIoThreadCount(int threadCount) {
        this.ioThreadCount = threadCount;
        return this;
    }

    public int getWorkerThreadCount() {
        return this.workerThreadCount;
    }

    @Config(value="thrift.server.worker-thread-count")
    public DriftNettyServerConfig setWorkerThreadCount(int threadCount) {
        this.workerThreadCount = threadCount;
        return this;
    }

    @MaxDataSize(value="128MB")
    public DataSize getMaxFrameSize() {
        return this.maxFrameSize;
    }

    @Config(value="thrift.server.max-frame-size")
    public DriftNettyServerConfig setMaxFrameSize(DataSize maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="thrift.server.request-timeout")
    public DriftNettyServerConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public boolean isAllowPlaintext() {
        return this.allowPlaintext;
    }

    @Config(value="thrift.server.allow-plaintext")
    public DriftNettyServerConfig setAllowPlaintext(boolean allowPlaintext) {
        this.allowPlaintext = allowPlaintext;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getSslContextRefreshTime() {
        return this.sslContextRefreshTime;
    }

    @Config(value="thrift.server.ssl-context.refresh-time")
    public DriftNettyServerConfig setSslContextRefreshTime(Duration sslContextRefreshTime) {
        this.sslContextRefreshTime = sslContextRefreshTime;
        return this;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    @Config(value="thrift.server.ssl.enabled")
    public DriftNettyServerConfig setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    public File getTrustCertificate() {
        return this.trustCertificate;
    }

    @Config(value="thrift.server.ssl.trust-certificate")
    public DriftNettyServerConfig setTrustCertificate(File trustCertificate) {
        this.trustCertificate = trustCertificate;
        return this;
    }

    public File getKey() {
        return this.key;
    }

    @Config(value="thrift.server.ssl.key")
    public DriftNettyServerConfig setKey(File key) {
        this.key = key;
        return this;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Config(value="thrift.server.ssl.key-password")
    public DriftNettyServerConfig setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public long getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Config(value="thrift.server.ssl.session-cache-size")
    public DriftNettyServerConfig setSessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Config(value="thrift.server.ssl.session-timeout")
    public DriftNettyServerConfig setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    @Config(value="thrift.server.ssl.ciphers")
    public DriftNettyServerConfig setCiphers(String ciphers) {
        this.ciphers = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(ciphers, "ciphers is null"));
        return this;
    }

    public boolean isAssumeClientsSupportOutOfOrderResponses() {
        return this.assumeClientsSupportOutOfOrderResponses;
    }

    @Config(value="thrift.server.assume-clients-support-out-of-order-responses")
    public DriftNettyServerConfig setAssumeClientsSupportOutOfOrderResponses(boolean assumeClientsSupportOutOfOrderResponses) {
        this.assumeClientsSupportOutOfOrderResponses = assumeClientsSupportOutOfOrderResponses;
        return this;
    }
}

