/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.server;

import com.facebook.drift.transport.netty.server.DriftNettyServerConfig;
import com.facebook.drift.transport.netty.server.ThriftServerInitializer;
import com.facebook.drift.transport.netty.ssl.SslContextFactory;
import com.facebook.drift.transport.server.ServerMethodInvoker;
import com.facebook.drift.transport.server.ServerTransport;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.concurrent.Threads;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class DriftNettyServerTransport
implements ServerTransport {
    private final ServerBootstrap bootstrap;
    private final int port;
    private final EventLoopGroup ioGroup;
    private final EventLoopGroup workerGroup;
    private Channel channel;
    private final AtomicBoolean running = new AtomicBoolean();

    public DriftNettyServerTransport(ServerMethodInvoker methodInvoker, DriftNettyServerConfig config) {
        this(methodInvoker, config, ByteBufAllocator.DEFAULT);
    }

    @VisibleForTesting
    public DriftNettyServerTransport(ServerMethodInvoker methodInvoker, DriftNettyServerConfig config, ByteBufAllocator allocator) {
        Objects.requireNonNull(methodInvoker, "methodInvoker is null");
        Objects.requireNonNull(config, "config is null");
        this.port = config.getPort();
        this.ioGroup = new NioEventLoopGroup(config.getIoThreadCount(), Threads.threadsNamed((String)"drift-server-io-%s"));
        this.workerGroup = new NioEventLoopGroup(config.getWorkerThreadCount(), Threads.threadsNamed((String)"drift-server-worker-%s"));
        Optional<Supplier<SslContext>> sslContext = Optional.empty();
        if (config.isSslEnabled()) {
            SslContextFactory sslContextFactory = SslContextFactory.createSslContextFactory(false, config.getSslContextRefreshTime(), (ScheduledExecutorService)this.workerGroup);
            sslContext = Optional.of(sslContextFactory.get(config.getTrustCertificate(), Optional.ofNullable(config.getKey()), Optional.ofNullable(config.getKey()), Optional.ofNullable(config.getKeyPassword()), config.getSessionCacheSize(), config.getSessionTimeout(), config.getCiphers()));
            sslContext.get().get();
        }
        ThriftServerInitializer serverInitializer = new ThriftServerInitializer(methodInvoker, config.getMaxFrameSize(), config.getRequestTimeout(), sslContext, config.isAllowPlaintext(), config.isAssumeClientsSupportOutOfOrderResponses(), (ScheduledExecutorService)this.workerGroup);
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.ioGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)serverInitializer).option(ChannelOption.SO_BACKLOG, (Object)config.getAcceptBacklog())).option(ChannelOption.ALLOCATOR, (Object)allocator)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).validate();
    }

    public void start() {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        try {
            this.channel = this.bootstrap.bind(this.port).sync().channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted while starting", e);
        }
    }

    public int getPort() {
        return ((InetSocketAddress)this.channel.localAddress()).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            if (this.channel != null) {
                DriftNettyServerTransport.await(this.channel.close());
            }
        }
        finally {
            Future ioShutdown;
            try {
                ioShutdown = this.ioGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            }
            finally {
                DriftNettyServerTransport.await(this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS));
            }
            DriftNettyServerTransport.await(ioShutdown);
        }
    }

    private static void await(Future<?> future) {
        try {
            future.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

