/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.drift.transport.client.MethodInvoker;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import com.facebook.drift.transport.netty.client.ConnectionFactory;
import com.facebook.drift.transport.netty.client.ConnectionManager;
import com.facebook.drift.transport.netty.client.ConnectionPool;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.client.DriftNettyConnectionFactoryConfig;
import com.facebook.drift.transport.netty.client.DriftNettyMethodInvoker;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.facebook.drift.transport.netty.ssl.SslContextFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PreDestroy;

public class DriftNettyMethodInvokerFactory<I>
implements MethodInvokerFactory<I>,
Closeable {
    private final Function<I, DriftNettyClientConfig> clientConfigurationProvider;
    private final EventLoopGroup group;
    private final SslContextFactory sslContextFactory;
    private final Optional<HostAndPort> defaultSocksProxy;
    private final ConnectionManager connectionManager;

    public static DriftNettyMethodInvokerFactory<?> createStaticDriftNettyMethodInvokerFactory(DriftNettyClientConfig clientConfig) {
        return DriftNettyMethodInvokerFactory.createStaticDriftNettyMethodInvokerFactory(clientConfig, ByteBufAllocator.DEFAULT);
    }

    @VisibleForTesting
    public static DriftNettyMethodInvokerFactory<?> createStaticDriftNettyMethodInvokerFactory(DriftNettyClientConfig clientConfig, ByteBufAllocator allocator) {
        return new DriftNettyMethodInvokerFactory<Object>(new DriftNettyConnectionFactoryConfig(), clientIdentity -> clientConfig, allocator);
    }

    public DriftNettyMethodInvokerFactory(DriftNettyConnectionFactoryConfig factoryConfig, Function<I, DriftNettyClientConfig> clientConfigurationProvider) {
        this(factoryConfig, clientConfigurationProvider, ByteBufAllocator.DEFAULT);
    }

    @VisibleForTesting
    public DriftNettyMethodInvokerFactory(DriftNettyConnectionFactoryConfig factoryConfig, Function<I, DriftNettyClientConfig> clientConfigurationProvider, ByteBufAllocator allocator) {
        Objects.requireNonNull(factoryConfig, "factoryConfig is null");
        if (factoryConfig.isNativeTransportEnabled()) {
            Preconditions.checkState((boolean)Epoll.isAvailable(), (Object)"native transport is not available");
            this.group = new EpollEventLoopGroup(factoryConfig.getThreadCount(), Threads.daemonThreadsNamed((String)"drift-client-%s"));
        } else {
            this.group = new NioEventLoopGroup(factoryConfig.getThreadCount(), Threads.daemonThreadsNamed((String)"drift-client-%s"));
        }
        this.clientConfigurationProvider = Objects.requireNonNull(clientConfigurationProvider, "clientConfigurationProvider is null");
        this.sslContextFactory = SslContextFactory.createSslContextFactory(true, factoryConfig.getSslContextRefreshTime(), (ScheduledExecutorService)this.group);
        this.defaultSocksProxy = Optional.ofNullable(factoryConfig.getSocksProxy());
        ConnectionManager connectionManager = new ConnectionFactory(this.group, this.sslContextFactory, allocator, factoryConfig);
        if (factoryConfig.isConnectionPoolEnabled()) {
            connectionManager = new ConnectionPool(connectionManager, this.group, factoryConfig.getConnectionPoolMaxSize(), factoryConfig.getConnectionPoolIdleTimeout());
        }
        this.connectionManager = connectionManager;
    }

    public MethodInvoker createMethodInvoker(I clientIdentity) {
        ConnectionManager.ConnectionParameters clientConfig = this.toConnectionConfig(this.clientConfigurationProvider.apply(clientIdentity));
        clientConfig.getSslContextParameters().ifPresent(sslContextParameters -> this.sslContextFactory.get((SslContextFactory.SslContextParameters)sslContextParameters).get());
        return new DriftNettyMethodInvoker(clientConfig, this.connectionManager, (ScheduledExecutorService)this.group);
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.connectionManager.close();
        }
        finally {
            try {
                this.group.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ConnectionManager.ConnectionParameters toConnectionConfig(DriftNettyClientConfig clientConfig) {
        Optional<HostAndPort> socksProxy;
        if (clientConfig.getTransport() == Transport.HEADER && clientConfig.getProtocol() == Protocol.COMPACT) {
            throw new IllegalArgumentException("HEADER transport cannot be used with COMPACT protocol, use FB_COMPACT instead");
        }
        Optional<SslContextFactory.SslContextParameters> sslContextConfig = Optional.empty();
        if (clientConfig.isSslEnabled()) {
            sslContextConfig = Optional.of(new SslContextFactory.SslContextParameters(clientConfig.getTrustCertificate(), Optional.ofNullable(clientConfig.getKey()), Optional.ofNullable(clientConfig.getKey()), Optional.ofNullable(clientConfig.getKeyPassword()), clientConfig.getSessionCacheSize(), clientConfig.getSessionTimeout(), clientConfig.getCiphers()));
        }
        if (!(socksProxy = Optional.ofNullable(clientConfig.getSocksProxy())).isPresent()) {
            socksProxy = this.defaultSocksProxy;
        }
        return new ConnectionManager.ConnectionParameters(clientConfig.getTransport(), clientConfig.getProtocol(), clientConfig.getMaxFrameSize(), clientConfig.getConnectTimeout(), clientConfig.getRequestTimeout(), socksProxy, sslContextConfig);
    }
}

