/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.drift.transport.netty.client.ConnectionManager;
import com.facebook.drift.transport.netty.client.ConnectionPool;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.google.common.net.HostAndPort;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.netty.channel.Channel;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConnectionPool {
    private static final ConnectionManager.ConnectionParameters PARAMETERS = new ConnectionManager.ConnectionParameters(Transport.HEADER, Protocol.FB_COMPACT, new DataSize(1.0, DataSize.Unit.MEGABYTE), new Duration(1.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.MINUTES), Optional.empty(), Optional.empty(), false, false);
    private ScheduledExecutorService scheduledExecutorService;

    @BeforeClass
    public void setup() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"drift-connection-maintenance"));
    }

    @AfterClass(alwaysRun=true)
    public void teardown() throws InterruptedException {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService.awaitTermination(1L, TimeUnit.MINUTES);
            this.scheduledExecutorService = null;
        }
    }

    @Test
    public void testPoolingWithSingleConnection() {
        try (ConnectionPool pool = new ConnectionPool((ConnectionManager)new TestingConnectionManager(), (EventLoopGroup)new DefaultEventLoopGroup(), 10, 1, new Duration(1.0, TimeUnit.MINUTES), this.scheduledExecutorService);){
            HostAndPort address1 = HostAndPort.fromParts((String)"localhost", (int)1234);
            HostAndPort address2 = HostAndPort.fromParts((String)"localhost", (int)4567);
            Channel channel1 = (Channel)TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address1));
            Channel channel2 = (Channel)TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address1));
            Assert.assertSame((Object)channel1, (Object)channel2);
            Channel channel3 = (Channel)TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address2));
            Assert.assertNotSame((Object)channel1, (Object)channel3);
            Channel channel4 = (Channel)TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address1));
            Assert.assertSame((Object)channel1, (Object)channel4);
        }
    }

    @Test
    public void testPoolingWithMultipleConnections() {
        try (ConnectionPool pool = new ConnectionPool((ConnectionManager)new TestingConnectionManager(), (EventLoopGroup)new DefaultEventLoopGroup(), 10, 2, new Duration(1.0, TimeUnit.MINUTES), this.scheduledExecutorService);){
            HostAndPort address = HostAndPort.fromParts((String)"localhost", (int)1234);
            TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address));
            TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address));
        }
    }

    @Test
    public void testConnectionClosed() {
        try (ConnectionPool pool = new ConnectionPool((ConnectionManager)new TestingConnectionManager(), (EventLoopGroup)new DefaultEventLoopGroup(), 10, 1, new Duration(1.0, TimeUnit.MINUTES), this.scheduledExecutorService);){
            HostAndPort address = HostAndPort.fromParts((String)"localhost", (int)1234);
            Channel channel1 = (Channel)TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address));
            Assert.assertTrue((boolean)channel1.isOpen());
            channel1.close();
            Assert.assertFalse((boolean)channel1.isOpen());
            Channel channel2 = (Channel)TestConnectionPool.futureGet(pool.getConnection(PARAMETERS, address));
            Assert.assertTrue((boolean)channel2.isOpen());
            Assert.assertNotSame((Object)channel1, (Object)channel2);
        }
    }

    private static <T> T futureGet(Future<T> future) {
        Assert.assertTrue((boolean)future.isSuccess());
        return (T)future.getNow();
    }

    private static class TestingConnectionManager
    implements ConnectionManager {
        private TestingConnectionManager() {
        }

        public Future<Channel> getConnection(ConnectionManager.ConnectionParameters connectionParameters, HostAndPort address) {
            return ImmediateEventExecutor.INSTANCE.newSucceededFuture((Object)new EmbeddedChannel());
        }

        public void returnConnection(Channel connection) {
        }

        public void close() {
        }
    }
}

