/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.drift.transport.netty.client.DriftNettyClientConfig;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.drift.transport.netty.codec.Transport;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDriftNettyClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DriftNettyClientConfig)ConfigAssertions.recordDefaults(DriftNettyClientConfig.class)).setTransport(Transport.HEADER).setProtocol(Protocol.BINARY).setConnectTimeout(new Duration(500.0, TimeUnit.MILLISECONDS)).setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSocksProxy(null).setMaxFrameSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setSslEnabled(false).setTrustCertificate(null).setKey(null).setKeyPassword(null).setSessionCacheSize(10000L).setSessionTimeout(new Duration(1.0, TimeUnit.DAYS)).setCiphers("").setConnectionPoolEnabled(null).setConnectionPoolMaxConnectionsPerDestination(null).setConnectionPoolMaxSize(null).setConnectionPoolIdleTimeout(null).setTcpNoDelayEnabled(false).setReuseAddressEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"thrift.client.transport", (Object)"FRAMED").put((Object)"thrift.client.protocol", (Object)"COMPACT").put((Object)"thrift.client.connect-timeout", (Object)"99ms").put((Object)"thrift.client.request-timeout", (Object)"33m").put((Object)"thrift.client.socks-proxy", (Object)"localhost:11").put((Object)"thrift.client.max-frame-size", (Object)"55MB").put((Object)"thrift.client.ssl.enabled", (Object)"true").put((Object)"thrift.client.ssl.trust-certificate", (Object)"trust").put((Object)"thrift.client.ssl.key", (Object)"key").put((Object)"thrift.client.ssl.key-password", (Object)"key_password").put((Object)"thrift.client.ssl.session-cache-size", (Object)"678").put((Object)"thrift.client.ssl.session-timeout", (Object)"78h").put((Object)"thrift.client.ssl.ciphers", (Object)"some_cipher").put((Object)"thrift.client.connection-pool.enabled", (Object)"true").put((Object)"thrift.client.connection-pool.max-connections-per-destination", (Object)"123").put((Object)"thrift.client.connection-pool.max-size", (Object)"321").put((Object)"thrift.client.connection-pool.idle-timeout", (Object)"12m").put((Object)"thrift.client.tcp-no-delay.enabled", (Object)"true").put((Object)"thrift.client.reuse-address.enabled", (Object)"true").build();
        DriftNettyClientConfig expected = new DriftNettyClientConfig().setTransport(Transport.FRAMED).setProtocol(Protocol.COMPACT).setConnectTimeout(new Duration(99.0, TimeUnit.MILLISECONDS)).setRequestTimeout(new Duration(33.0, TimeUnit.MINUTES)).setSocksProxy(HostAndPort.fromParts((String)"localhost", (int)11)).setMaxFrameSize(new DataSize(55.0, DataSize.Unit.MEGABYTE)).setSslEnabled(true).setTrustCertificate(new File("trust")).setKey(new File("key")).setKeyPassword("key_password").setSessionCacheSize(678L).setSessionTimeout(new Duration(78.0, TimeUnit.HOURS)).setCiphers("some_cipher").setConnectionPoolEnabled(Boolean.valueOf(true)).setConnectionPoolMaxConnectionsPerDestination(Integer.valueOf(123)).setConnectionPoolMaxSize(Integer.valueOf(321)).setConnectionPoolIdleTimeout(new Duration(12.0, TimeUnit.MINUTES)).setTcpNoDelayEnabled(true).setReuseAddressEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

