/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.client;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.drift.transport.netty.client.DriftNettyConnectionFactoryConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestDriftNettyConnectionFactoryConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DriftNettyConnectionFactoryConfig)ConfigAssertions.recordDefaults(DriftNettyConnectionFactoryConfig.class)).setThreadCount(Runtime.getRuntime().availableProcessors() * 2).setConnectionPoolEnabled(true).setConnectionPoolMaxSize(1000).setConnectionPoolMaxConnectionsPerDestination(1).setConnectionPoolIdleTimeout(new Duration(1.0, TimeUnit.MINUTES)).setSslContextRefreshTime(new Duration(1.0, TimeUnit.MINUTES)).setSocksProxy(null).setNativeTransportEnabled(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"thrift.client.thread-count", (Object)"99").put((Object)"thrift.client.connection-pool.enabled", (Object)"false").put((Object)"thrift.client.connection-pool.max-size", (Object)"555").put((Object)"thrift.client.connection-pool.max-connections-per-destination", (Object)"10").put((Object)"thrift.client.connection-pool.idle-timeout", (Object)"7m").put((Object)"thrift.client.ssl-context.refresh-time", (Object)"33m").put((Object)"thrift.client.socks-proxy", (Object)"example.com:9876").put((Object)"thrift.client.native-transport.enabled", (Object)"true").build();
        DriftNettyConnectionFactoryConfig expected = new DriftNettyConnectionFactoryConfig().setThreadCount(99).setConnectionPoolEnabled(false).setConnectionPoolMaxSize(555).setConnectionPoolMaxConnectionsPerDestination(10).setConnectionPoolIdleTimeout(new Duration(7.0, TimeUnit.MINUTES)).setSslContextRefreshTime(new Duration(33.0, TimeUnit.MINUTES)).setSocksProxy(HostAndPort.fromParts((String)"example.com", (int)9876)).setNativeTransportEnabled(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

